/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.machines.FossilMachineBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.FossilMachineTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class RenderTileEntityFossilMachine
extends TileEntityRenderer<FossilMachineTileEntity> {
    public static final ResourceLocation MACHINE_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/block/fossil_extractor.png");
    private static final GenericModelHolder<GenericSmdModel> machineBase = new GenericModelHolder("blocks/fossil_machine/fossil_extractor.pqc");
    public static final GenericSmdModel machineGlass = new GenericSmdModel("models/blocks/fossil_machine", "fossil_extractor_glass.pqc");
    private static final Map<Integer, StatueConfig> OVERRIDE_MAP = new HashMap<Integer, StatueConfig>();
    private static final StatueConfig DEFAULT = new StatueConfig(0.15f, 0, AnimationType.WALK);

    public RenderTileEntityFossilMachine(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
        RenderTileEntityFossilMachine.machineGlass.modelRenderer.setTransparent(0.5f);
        this.correctionAngles = 180;
        PixelmonSpecies.OMANYTE.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.15f, 0, AnimationType.IDLE)));
        PixelmonSpecies.KABUTO.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.001f, 0, AnimationType.IDLE)));
        PixelmonSpecies.AERODACTYL.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.6f, 0, AnimationType.IDLE)));
        PixelmonSpecies.LILEEP.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.16f, 0, AnimationType.IDLE)));
        PixelmonSpecies.ANORITH.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.1f, 0, AnimationType.IDLE)));
        PixelmonSpecies.CRANIDOS.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.22f, 0, AnimationType.IDLE)));
        PixelmonSpecies.SHIELDON.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.001f, 0, AnimationType.IDLE)));
        PixelmonSpecies.TIRTOUGA.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.05f, 0, AnimationType.IDLE)));
        PixelmonSpecies.ARCHEN.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.15f, 6, AnimationType.FLY)));
        PixelmonSpecies.TYRUNT.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.25f, 0, AnimationType.IDLE)));
        PixelmonSpecies.AMAURA.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.01f, 0, AnimationType.IDLE)));
        PixelmonSpecies.ARCTOZOLT.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.5f, 20, AnimationType.IDLE)));
        PixelmonSpecies.ARCTOVISH.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.45f, 20, AnimationType.IDLE)));
        PixelmonSpecies.DRACOVISH.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.5f, 0, AnimationType.IDLE)));
        PixelmonSpecies.DRACOZOLT.ifInitialized(species -> OVERRIDE_MAP.put(species.getDex(), new StatueConfig(0.45f, 20, AnimationType.IDLE)));
    }

    @Override
    public void render(FossilMachineTileEntity machine, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        StatueConfig config;
        this.renderSMD(matrix, buffer, (Model)machineBase.getModel(), MACHINE_TEXTURE, combinedLight, combinedOverlay);
        this.renderTransparentSMD(matrix, buffer, machineGlass, MACHINE_TEXTURE, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.m_85849_();
        matrix.m_85836_();
        int rotate = this.getRotation(state);
        Direction facing = Direction.NORTH;
        if (state.m_60734_() instanceof FossilMachineBlock) {
            facing = (Direction)state.m_61143_((Property)MultiBlock.FACING);
        }
        this.renderCompletionLevel(machine, matrix, buffer, machine.completionRate + "%", facing, rotate, x, 0.0, z, false, -1);
        if (machine.staticFlicker && machine.completionRate == 100 && machine.pokeball == null) {
            this.renderCompletionLevel(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.fossilmachine.pokeball", (Object[])new Object[0]), facing, rotate, x, 0.08f, z, true, -65536);
        } else if (machine.completionRate > 0 && machine.completionRate < 100) {
            this.renderCompletionLevel(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.fossilmachine.working", (Object[])new Object[0]) + machine.dots, facing, rotate, x, 0.1f, z, true, -16711936);
        } else if (machine.staticFlicker && machine.completionRate == 0 && machine.currentFossil == EnumFossils.NULL) {
            this.renderCompletionLevel(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.fossilmachine.fossil", (Object[])new Object[0]), facing, rotate, x, 0.08f, z, true, -65536);
        } else if (machine.staticFlicker && machine.completionRate == 0 && machine.currentFossil.getPokemon() == null) {
            this.renderCompletionLevel(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.fossilmachine.incomplete", (Object[])new Object[0]), facing, rotate, x, 0.08f, z, true, -65536);
        } else if (machine.staticFlicker && machine.completionRate == 100 && machine.pokeball != null) {
            this.renderCompletionLevel(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.fossilmachine.retrieve", (Object[])new Object[0]), facing, rotate, x, 0.08f, z, true, -16711936);
        }
        this.renderBarLevel(machine, matrix, buffer, facing, rotate, x, y, z);
        if (machine.currentFossil != EnumFossils.NULL) {
            this.renderFossil(machine.currentFossil, machine, matrix, buffer, combinedLight, combinedOverlay, rotate, x, y, z, facing);
        }
        if (machine.pokeball != null) {
            this.renderPokeball(machine.pokeball, machine, matrix, buffer, combinedLight, combinedOverlay, rotate, x, y, z, facing);
        }
        if (!(machine.statue != null && machine.statue.m_7755_().getString().equalsIgnoreCase(machine.currentPokemon) || machine.currentPokemon.equals("") || !PixelmonSpecies.has(machine.currentPokemon))) {
            machine.statue = new StatueEntity(machine.m_58904_());
            machine.statue.setPokemon(PokemonFactory.create(PixelmonSpecies.fromName(machine.currentPokemon).getValueUnsafe()));
            machine.statue.setGrowth(EnumGrowth.Small);
            if (machine.isShiny) {
                machine.statue.setPalette("shiny");
            }
            config = OVERRIDE_MAP.getOrDefault(machine.statue.getSpecies().getDex(), DEFAULT);
            machine.statue.setAnimation(config.type);
            machine.statue.setAnimationFrame(config.frame);
        }
        if (machine.statue != null) {
            matrix.m_85836_();
            matrix.m_252880_((float)x + 0.5f, (float)y + 0.9f, (float)z + 0.5f);
            config = OVERRIDE_MAP.getOrDefault(machine.statue.getSpecies(), DEFAULT);
            float scale = Math.max(machine.pokemonProgress / 1000.0f / 4.0f - config.scale, 0.0f);
            matrix.m_85841_(scale, scale, scale);
            machine.statue.m_7678_(x, y, z, 0.0f, 0.0f);
            PixelmonRendering.renderEntity(new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), machine.statue, false, partialTicks);
            matrix.m_85849_();
        }
        matrix.m_85849_();
        matrix.m_85836_();
    }

    @Override
    protected int getRotation(BlockState state) {
        if (state.m_60734_() instanceof FossilMachineBlock) {
            Direction facing = (Direction)state.m_61143_((Property)MultiBlock.FACING);
            if (facing == Direction.WEST) {
                return 90;
            }
            if (facing == Direction.SOUTH) {
                return 180;
            }
            if (facing == Direction.EAST) {
                return 270;
            }
            return 0;
        }
        return 0;
    }

    private void renderBarLevel(FossilMachineTileEntity tile, PoseStack matrix, MultiBufferSource bufferSource, Direction facing, int rotate, double x1, double y1, double z1) {
        matrix.m_85836_();
        float f2 = 1.5f;
        float f3 = 0.00666667f * f2;
        if (facing == Direction.NORTH) {
            matrix.m_252880_(0.5f, 0.32f, 0.97f);
        } else if (facing == Direction.WEST) {
            matrix.m_252880_(0.97f, 0.32f, 0.5f);
        } else if (facing == Direction.SOUTH) {
            matrix.m_252880_(0.5f, 0.32f, 0.03f);
        } else {
            matrix.m_252880_(0.03f, 0.32f, 0.5f);
        }
        matrix.m_252781_(QuaternionHelper.fromEuler(rotate + 180, 0.0f, 1.0f, 0.0f));
        matrix.m_85841_(-f3, -f3, f3);
        Matrix4f pose = matrix.m_85850_().m_252922_();
        int byte0 = -20;
        float f8 = (float)tile.completionRate / 2.0f;
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_285907_());
        buffer.m_252986_(pose, -25.0f + f8, (float)(-7 + byte0), 0.0f).m_85950_(0.0039f, 0.03137f, 0.4196f, 1.0f).m_5752_();
        buffer.m_252986_(pose, -25.0f + f8, (float)(-6 + byte0), 0.0f).m_85950_(0.0039f, 0.03137f, 0.4196f, 1.0f).m_5752_();
        buffer.m_252986_(pose, 25.0f, (float)(-6 + byte0), 0.0f).m_85950_(0.0039f, 0.03137f, 0.4196f, 1.0f).m_5752_();
        buffer.m_252986_(pose, 25.0f, (float)(-7 + byte0), 0.0f).m_85950_(0.0039f, 0.03137f, 0.4196f, 1.0f).m_5752_();
        buffer.m_252986_(pose, -25.0f, (float)(-7 + byte0), 0.0f).m_85950_(0.0f, 0.8901f, 0.8901f, 1.0f).m_5752_();
        buffer.m_252986_(pose, -25.0f, (float)(-6 + byte0), 0.0f).m_85950_(0.0f, 0.8901f, 0.8901f, 1.0f).m_5752_();
        buffer.m_252986_(pose, f8 - 25.0f, (float)(-6 + byte0), 0.0f).m_85950_(0.0f, 0.8901f, 0.8901f, 1.0f).m_5752_();
        buffer.m_252986_(pose, f8 - 25.0f, (float)(-7 + byte0), 0.0f).m_85950_(0.0f, 0.8901f, 0.8901f, 1.0f).m_5752_();
        matrix.m_85849_();
    }

    private void renderCompletionLevel(FossilMachineTileEntity tile, PoseStack matrix, MultiBufferSource bufferSource, String text, Direction facing, int rotation, double x1, double y1, double z1, boolean par10, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        matrix.m_85836_();
        float var13 = 1.5f;
        float var14 = 0.011f * var13;
        if (facing == Direction.NORTH) {
            matrix.m_85837_(0.5, y1 + 0.75, (double)0.97f);
            rotation = 180 - rotation;
        } else if (facing == Direction.WEST) {
            matrix.m_85837_((double)0.97f, y1 + 0.75, 0.5);
        } else if (facing == Direction.SOUTH) {
            matrix.m_85837_(0.5, y1 + 0.75, (double)0.03f);
            rotation = 180 - rotation;
        } else {
            matrix.m_85837_((double)0.03f, y1 + 0.75, 0.5);
        }
        if (!par10) {
            matrix.m_85841_(-var14, -var14, var14);
        } else {
            matrix.m_85841_(-var14 + 0.011f, -var14 + 0.011f, var14 - 0.011f);
        }
        matrix.m_252781_(QuaternionHelper.fromEuler(rotation, 0.0f, 1.0f, 0.0f));
        Matrix4f pose = matrix.m_85850_().m_252922_();
        int stringWidth = fontRenderer.m_92895_(text) / 2;
        fontRenderer.m_271703_(text, (float)(-stringWidth), 0.0f, color, false, pose, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_285907_());
        buffer.m_252986_(pose, (float)(-stringWidth - 1), -1.0f, -0.5f).m_6122_(0, 0, 0, 1).m_5752_();
        buffer.m_252986_(pose, (float)(-stringWidth - 1), 8.0f, -0.5f).m_6122_(0, 0, 0, 1).m_5752_();
        buffer.m_252986_(pose, (float)(stringWidth + 1), 8.0f, -0.5f).m_6122_(0, 0, 0, 1).m_5752_();
        buffer.m_252986_(pose, (float)(stringWidth + 1), -1.0f, -0.5f).m_6122_(0, 0, 0, 1).m_5752_();
        fontRenderer.m_271703_(text, (float)(-stringWidth), 0.0f, color, false, pose, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        matrix.m_85849_();
    }

    private void renderFossil(EnumFossils fossil, FossilMachineTileEntity machine, PoseStack matrix, MultiBufferSource buffer, int light, int overlay, int rotate, double x, double y, double z, Direction facing) {
        matrix.m_85836_();
        matrix.m_252880_(0.5f, 1.0f + machine.fossilJitter, 0.5f);
        matrix.m_85841_(0.8f - machine.fossilProgress / 1000.0f / 2.0f, -0.8f + machine.fossilProgress / 1000.0f / 2.0f, -0.8f + machine.fossilProgress / 1000.0f / 2.0f);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            matrix.m_252781_(QuaternionHelper.fromEuler(rotate, 0.0f, 1.0f, 0.0f));
        } else {
            matrix.m_252781_(QuaternionHelper.fromEuler((float)rotate + 180.0f, 0.0f, 0.5f, 0.0f));
        }
        this.renderSMD(matrix, buffer, (Model)fossil.getModel().getModel(), fossil.getTexture(), light, overlay);
        matrix.m_85849_();
    }

    private void renderPokeball(PokeBall pokeBall, FossilMachineTileEntity machine, PoseStack matrix, MultiBufferSource buffer, int light, int overlay, int rotate, double x, double y, double z, Direction facing) {
        matrix.m_85836_();
        if (rotate == 270) {
            matrix.m_85837_((double)-0.1f, (double)0.42f, 0.86);
        } else if (rotate == 180) {
            matrix.m_85837_(0.14, (double)0.42f, -0.1);
        } else if (rotate == 90) {
            matrix.m_85837_(1.1, (double)0.42f, 0.14);
        } else {
            matrix.m_85837_(0.86, (double)0.42f, 1.1);
        }
        matrix.m_252781_(QuaternionHelper.fromEuler(rotate, 0.0f, 1.0f, 0.0f));
        GenericModelHolder<ModelPokeballs> pokeball = pokeBall.getModelHolder();
        ((ModelPokeballs)((Object)pokeball.getModel())).theModel.setAnimation(AnimationType.IDLE);
        float scale = 0.002f;
        matrix.m_85841_(scale, scale, scale);
        this.renderSMD(matrix, buffer, (Model)pokeball.getModel(), pokeBall.getModelTexture(), light, overlay);
        matrix.m_85849_();
    }

    private static class StatueConfig {
        float scale = 0.15f;
        int frame = 0;
        AnimationType type = AnimationType.WALK;

        public StatueConfig(float scale, int frame, AnimationType type) {
            this.scale = scale;
            this.frame = frame;
            this.type = type;
        }
    }
}

