/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.CloningMachineTileEntity;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelBrokenCloningMachine;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelCloningMachine;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTileEntityCloningMachine
extends TileEntityRenderer<CloningMachineTileEntity> {
    private static final ResourceLocation CLONING_MACHINE_TEX = ResourceLocationHelper.of("pixelmon:textures/block/cloning_machine.png");
    private static final ResourceLocation CLONING_MACHINE_BLOCKS = ResourceLocationHelper.of("pixelmon:textures/gui/clonerblocks.png");
    private static final GenericModelHolder<ModelCloningMachine> model = new GenericModelHolder<ModelCloningMachine>(ModelCloningMachine.class);
    private static final GenericModelHolder<ModelBrokenCloningMachine> brokenModel = new GenericModelHolder<ModelBrokenCloningMachine>(ModelBrokenCloningMachine.class);
    private PixelmonEntity pokemon;

    public RenderTileEntityCloningMachine(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
        this.flip = false;
    }

    @Override
    public void render(CloningMachineTileEntity machine, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (machine.isBroken) {
            ((ModelBrokenCloningMachine)((Object)brokenModel.getModel())).renderTileEntity(machine, matrix, buffer.m_6299_(PixelmonRendering.getSMDRenderType(CLONING_MACHINE_TEX)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            ((ModelCloningMachine)((Object)model.getModel())).renderTileEntity(machine, matrix, buffer.m_6299_(PixelmonRendering.getSMDRenderType(CLONING_MACHINE_TEX)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrix.m_85849_();
        matrix.m_85836_();
        Direction facing = Direction.NORTH;
        int rotation = super.getRotation(state);
        if (state.m_60734_() instanceof MultiBlock) {
            facing = (Direction)state.m_61143_((Property)MultiBlock.FACING);
        }
        if (machine.hasMew() && !machine.isBroken && !machine.isFinished) {
            if (this.pokemon == null) {
                this.pokemon = PokemonSpecificationProxy.create(PixelmonSpecies.MEW.getValueUnsafe().getName()).get().create(machine.m_58904_());
                this.pokemon.getPokemon().setGrowth(EnumGrowth.Runt);
                this.pokemon.getLvl().setLevel(1);
                this.pokemon.getPokemon().setPalette(machine.mew.getPalette());
                this.pokemon.initAnimation();
            }
            matrix.m_85836_();
            if (this.pokemon != null) {
                matrix.m_252880_(0.5f, 0.45f, 0.5f);
                matrix.m_252781_(QuaternionHelper.fromEuler(rotation, 0.0f, 1.0f, 0.0f));
                this.pokemon.m_7678_(x, y, z, 0.0f, 0.0f);
                this.pokemon.setAnimation(AnimationType.IDLE);
                if (this.pokemon.getAnimationVariables().hasInt(-1)) {
                    this.pokemon.getAnimationVariables().getCounter((int)-1).value = 30.0f;
                }
                PixelmonRendering.renderEntity(new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), this.pokemon, false, partialTicks);
            }
            matrix.m_85849_();
        }
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.0, 0.5);
        matrix.m_252781_(QuaternionHelper.fromEuler(rotation, 0.0f, 1.0f, 0.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
        matrix.m_85841_(1.0f, -1.0f, -1.0f);
        if (machine.isBroken) {
            ((ModelBrokenCloningMachine)((Object)brokenModel.getModel())).renderGlass(matrix, buffer.m_6299_(PixelmonRendering.getSMDRenderType(CLONING_MACHINE_TEX)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            ((ModelCloningMachine)((Object)model.getModel())).renderGlass(matrix, buffer.m_6299_(PixelmonRendering.getSMDRenderType(CLONING_MACHINE_TEX)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrix.m_85849_();
        if (machine.isBroken) {
            this.renderLeftDisplay(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.cloningmachine.error", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
        } else {
            if (machine.isFinished) {
                this.renderLeftDisplay(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.cloningmachine.finished", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            } else if (machine.hasMew()) {
                this.renderLeftDisplay(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.cloningmachine.scanning", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            } else {
                this.renderLeftDisplay(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.cloningmachine.mew", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            }
            if (machine.hasMew()) {
                this.renderRightDisplay(machine, matrix, buffer, I18n.m_118938_((String)"pixelmon.blocks.cloningmachine.catalyst", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            }
            if (!machine.pokemonName.equals("")) {
                if (machine.pixelmon == null) {
                    machine.pixelmon = PokemonSpecificationProxy.create(machine.pokemonName, machine.isShiny ? "s" : "!s", "gr:Runt", "lvl:1").get().create(machine.m_58904_());
                    machine.pixelmon.initAnimation();
                }
                matrix.m_85836_();
                matrix.m_252880_(0.5f + machine.xboost, 0.8f, 0.5f + machine.zboost);
                machine.pixelmon.m_284535_(machine.m_58904_());
                matrix.m_252781_(QuaternionHelper.fromEuler(rotation, 0.0f, 1.0f, 0.0f));
                matrix.m_85841_(0.0f + (float)machine.pokemonProgress / 200.0f, 0.0f + (float)machine.pokemonProgress / 200.0f, 0.0f + (float)machine.pokemonProgress / 200.0f);
                PixelmonRendering.renderEntity(new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), machine.pixelmon, false, partialTicks);
                matrix.m_85849_();
            }
        }
    }

    private void renderLeftDisplay(CloningMachineTileEntity tile, PoseStack matrix, MultiBufferSource buffer, String par2Str, Direction facing, double par3, double par5, double par7, int par9, boolean par10, int par11) {
        int j = 0;
        if (facing == Direction.EAST) {
            j = 270;
        } else if (facing == Direction.NORTH) {
            j = 0;
        } else if (facing == Direction.WEST) {
            j = 90;
        } else if (facing == Direction.SOUTH) {
            j = 180;
        }
        Font var12 = Minecraft.m_91087_().f_91062_;
        float var13 = 1.6f;
        float var14 = 0.011666667f * var13;
        matrix.m_85836_();
        if (facing == Direction.NORTH) {
            matrix.m_252880_(0.5f, 0.9f, 1.22f);
        } else if (facing == Direction.WEST) {
            matrix.m_252880_(1.23f, 0.9f, 0.5f);
        } else if (facing == Direction.SOUTH) {
            matrix.m_252880_(0.5f, 0.9f, -0.23f);
        } else {
            matrix.m_252880_(-0.23f, 0.9f, 0.51f);
        }
        matrix.m_252781_(QuaternionHelper.fromEuler(j + 180, 0.0f, 1.0f, 0.0f));
        if (!par10) {
            matrix.m_85841_(-var14, -var14, var14);
        } else {
            matrix.m_85841_(-var14 + 0.012f, -var14 + 0.012f, var14 + 0.012f);
        }
        matrix.m_85841_(0.5f, 0.5f, 0.5f);
        var12.m_271703_(par2Str, (float)(-var12.m_92895_(par2Str)) / 2.0f, 0.0f, Color.WHITE.getRGB(), false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        matrix.m_85849_();
    }

    private void renderRightDisplay(CloningMachineTileEntity tile, PoseStack matrix, MultiBufferSource buffer, String par2Str, Direction facing, double par3, double par5, double par7, int par9, boolean par10, int par11) {
        int j = 0;
        if (facing == Direction.EAST) {
            j = 270;
        } else if (facing == Direction.NORTH) {
            j = 0;
        } else if (facing == Direction.WEST) {
            j = 90;
        } else if (facing == Direction.SOUTH) {
            j = 180;
        }
        Font var12 = Minecraft.m_91087_().f_91062_;
        float var13 = 1.6f;
        float var14 = 0.011666667f * var13;
        matrix.m_85836_();
        if (facing == Direction.NORTH) {
            matrix.m_252880_(3.87f, 0.9f, 1.22f);
        } else if (facing == Direction.WEST) {
            matrix.m_252880_(1.23f, 0.9f, -2.87f);
        } else if (facing == Direction.SOUTH) {
            matrix.m_252880_(-2.87f, 0.9f, -0.23f);
        } else {
            matrix.m_252880_(-0.23f, 0.9f, 3.87f);
        }
        matrix.m_252781_(QuaternionHelper.fromEuler(j + 180, 0.0f, 1.0f, 0.0f));
        if (!par10) {
            matrix.m_85841_(-var14, -var14, var14);
        } else {
            matrix.m_85841_(-var14 + 0.012f, -var14 + 0.012f, var14 + 0.012f);
        }
        boolean var16 = false;
        matrix.m_85841_(0.3f, 0.3f, 0.3f);
        var12.m_92895_((String)par2Str);
        if (tile.isFinished) {
            par2Str = I18n.m_118938_((String)"pixelmon.blocks.cloningmachine.retrieve", (Object[])new Object[0]);
        } else if (tile.processingClone || tile.growingPokemon) {
            par2Str = I18n.m_118938_((String)"pixelmon.blocks.cloningmachine.processing", (Object[])new Object[0]);
        }
        if (!(tile.processingClone || tile.growingPokemon || tile.isFinished)) {
            ScreenHelper.drawImageQuad(CLONING_MACHINE_BLOCKS, new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), -30.0f, 10.0f, 60.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            par2Str = I18n.m_118938_((String)"pixelmon.blocks.cloningmachine.boost", (Object[])new Object[0]) + " " + tile.boostCount + "/3";
            var12.m_271703_((String)par2Str, (float)(-var12.m_92895_((String)par2Str)) / 2.0f, 0.0f, Color.WHITE.getRGB(), false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            int x = -30;
            int w = 60;
            int y = 35;
            int h = 17;
            boolean zLevel = false;
            float boostPercent = (float)tile.boostLevel / 40.0f;
            VertexConsumer worldRenderer = buffer.m_6299_(RenderType.m_285907_());
            worldRenderer.m_5483_((double)x, (double)(y + h), (double)zLevel + 0.01).m_85950_(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).m_5752_();
            worldRenderer.m_5483_((double)(x + w), (double)(y + h), (double)zLevel + 0.01).m_85950_(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).m_5752_();
            worldRenderer.m_5483_((double)(x + w), (double)y, (double)zLevel + 0.01).m_85950_(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).m_5752_();
            worldRenderer.m_5483_((double)x, (double)y, (double)zLevel + 0.01).m_85950_(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).m_5752_();
        }
        var12.m_271703_((String)par2Str, (float)(-var12.m_92895_((String)par2Str)) / 2.0f, 0.0f, Color.WHITE.getRGB(), false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        matrix.m_85849_();
    }

    public boolean shouldRenderOffScreen(CloningMachineTileEntity p_188185_1_) {
        return true;
    }
}

