/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.BellBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.BellTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class RenderTileEntityBell
extends TileEntityRenderer<BellTileEntity> {
    private static final GenericModelHolder<GenericSmdModel> tidal_model = new GenericModelHolder("blocks/bells/tidal_bell.pqc");
    private static final ResourceLocation tidal_texture = ResourceLocationHelper.of("pixelmon", "textures/block/tidal_bell.png");
    private static final GenericModelHolder<GenericSmdModel> clear_model = new GenericModelHolder("blocks/bells/clear_bell.pqc");
    private static final ResourceLocation clear_texture = ResourceLocationHelper.of("pixelmon", "textures/block/clear_bell.png");
    private int ticker = 0;
    private float randomValue = RandomHelper.getRandom().nextFloat();

    public RenderTileEntityBell(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(BellTileEntity bell, BlockState state, double x, double y, double z, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (state.m_60734_().equals((Object)PixelmonBlocks.clear_bell) || state.m_60734_().equals((Object)PixelmonBlocks.tidal_bell)) {
            switch (((BellBlock)state.m_60734_()).getBell()) {
                case CLEAR: {
                    this.renderModel(matrix, buffer, combinedLight, combinedOverlay, clear_model, clear_texture);
                    break;
                }
                case TIDAL: {
                    this.renderModel(matrix, buffer, combinedLight, combinedOverlay, tidal_model, tidal_texture);
                }
            }
            if (bell.isSpawning()) {
                bell.setTicks(bell.getTicks() + 1);
                int ticker = bell.getTicks();
                float f = ((float)ticker + partialTicks) / 300.0f;
                matrix.m_85836_();
                matrix.m_252880_(0.0f, -0.65f, 0.0f);
                int count = 15;
                float scale = 9.0E-4f;
                if (bell.isSpawning() && bell.m_58904_().m_46468_() > 12000L && bell.m_58904_().m_46468_() < 14000L) {
                    long factor = 13000L - bell.m_58904_().m_46468_();
                    double size = (double)factor / 1000.0;
                    scale = (float)Math.max((1.0 - size) / 1000.0, 3.0E-4);
                    int additional = (int)((1.0 - size) * 10.0);
                    count += additional;
                }
                VertexConsumer bufferBuilder = buffer.m_6299_(PixelmonRendering.triangleFan());
                matrix.m_85841_(scale, scale, scale);
                for (int i = 0; i < count; ++i) {
                    matrix.m_252781_(QuaternionHelper.fromEuler(RandomHelper.getLegacyRandom().nextFloat(), 1.0f, 0.0f, 0.0f));
                    matrix.m_252781_(QuaternionHelper.fromEuler(RandomHelper.getLegacyRandom().nextFloat(), 0.0f, 1.0f, 0.0f));
                    matrix.m_252781_(QuaternionHelper.fromEuler(RandomHelper.getLegacyRandom().nextFloat(), 0.0f, 0.0f, 1.0f));
                    matrix.m_252781_(QuaternionHelper.fromEuler(RandomHelper.getLegacyRandom().nextFloat(), 1.0f, 0.0f, 0.0f));
                    matrix.m_252781_(QuaternionHelper.fromEuler(RandomHelper.getLegacyRandom().nextFloat(), 0.0f, 1.0f, 0.0f));
                    matrix.m_252781_(QuaternionHelper.fromEuler(f * 90.0f, 0.0f, 0.0f, 1.0f));
                    float f2 = RandomHelper.getLegacyRandom().nextFloat() * 20.0f + 5.0f + 2000.0f;
                    float f3 = RandomHelper.getLegacyRandom().nextFloat() * 2.0f + 1.0f + 400.0f;
                    Matrix4f pose = matrix.m_85850_().m_252922_();
                    bufferBuilder.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 0.84313726f, 0.0f, 0.45f).m_5752_();
                    bufferBuilder.m_252986_(pose, -0.866f * f3, f2, -0.5f * f3).m_6122_(0, 0, 0, 0).m_5752_();
                    bufferBuilder.m_252986_(pose, 0.866f * f3, f2, -0.5f * f3).m_6122_(0, 0, 0, 0).m_5752_();
                    bufferBuilder.m_252986_(pose, 0.0f, f2, 1.0f * f3).m_6122_(0, 0, 0, 0).m_5752_();
                    bufferBuilder.m_252986_(pose, -0.866f * f3, f2, -0.5f * f3).m_6122_(0, 0, 0, 0).m_5752_();
                }
                matrix.m_85849_();
            }
        }
    }

    public void renderModel(PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay, GenericModelHolder<GenericSmdModel> model, ResourceLocation texture) {
        matrix.m_85836_();
        float rotate = -90.0f;
        float scale = 0.3f;
        matrix.m_85841_(scale, scale, scale);
        matrix.m_85837_(0.0, -1.3, 0.0);
        matrix.m_252781_(QuaternionHelper.fromEuler(rotate, 0.0f, 1.0f, 0.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
        this.renderSMD(matrix, buffer, (Model)model.getModel(), texture, combinedLight, combinedOverlay);
        matrix.m_85849_();
    }
}

