/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.shader;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.data.BlockedDataSerializer;
import com.pixelmonmod.pixelmon.client.render.shader.PixelmonCodecs;
import com.pixelmonmod.pixelmon.client.render.shader.PixelmonShaders;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;

@Immutable
public class ShaderParameters {
    public static final EntityDataSerializer<ShaderParameters> SHADER_DATA_SERIALIZER = new BlockedDataSerializer<ShaderParameters>((friendlyByteBuf, shaderParameters) -> {
        friendlyByteBuf.m_130085_(shaderParameters.getId());
        friendlyByteBuf.m_236831_(shaderParameters.parameters, FriendlyByteBuf::m_130070_, (buf, value) -> value.write((FriendlyByteBuf)buf));
        friendlyByteBuf.writeInt(shaderParameters.getRenderColor().getRed());
        friendlyByteBuf.writeInt(shaderParameters.getRenderColor().getGreen());
        friendlyByteBuf.writeInt(shaderParameters.getRenderColor().getBlue());
        friendlyByteBuf.writeInt(shaderParameters.getRenderColor().getAlpha());
        friendlyByteBuf.writeBoolean(shaderParameters.onlyShader());
        friendlyByteBuf.writeBoolean(shaderParameters.withTexture());
        friendlyByteBuf.writeBoolean(shaderParameters.isWireframe());
        friendlyByteBuf.writeBoolean(shaderParameters.isVertex());
    }, friendlyByteBuf -> new ShaderParameters(friendlyByteBuf.m_130281_(), friendlyByteBuf.m_236847_(FriendlyByteBuf::m_130277_, Value::read), new Color(friendlyByteBuf.readInt(), friendlyByteBuf.readInt(), friendlyByteBuf.readInt(), friendlyByteBuf.readInt()), friendlyByteBuf.readBoolean(), friendlyByteBuf.readBoolean(), friendlyByteBuf.readBoolean(), friendlyByteBuf.readBoolean()), Function.identity());
    public static final EntityDataSerializer<Optional<ShaderParameters>> OPTIONAL_SHADER_DATA_SERIALIZER = new BlockedDataSerializer<Optional>((friendlyByteBuf, shaderParameters) -> {
        friendlyByteBuf.writeBoolean(shaderParameters.isPresent());
        shaderParameters.ifPresent(value -> SHADER_DATA_SERIALIZER.m_6856_(friendlyByteBuf, value));
    }, friendlyByteBuf -> {
        if (friendlyByteBuf.readBoolean()) {
            return Optional.of((ShaderParameters)SHADER_DATA_SERIALIZER.m_6709_(friendlyByteBuf));
        }
        return Optional.empty();
    }, Function.identity());
    private final ResourceLocation id;
    private final Map<String, Value<?>> parameters;
    private final Color renderColor;
    private final boolean onlyShader;
    private final boolean withTexture;
    private final boolean wireframe;
    private final boolean vertex;

    public ShaderParameters(ResourceLocation id, Map<String, Value<?>> parameters, Color renderColor, boolean onlyShader, boolean withTexture, boolean wireframe, boolean vertex) {
        this.id = id;
        this.parameters = parameters;
        this.renderColor = renderColor;
        this.onlyShader = onlyShader;
        this.withTexture = withTexture;
        this.wireframe = wireframe;
        this.vertex = vertex;
    }

    @Nullable
    public <T> T getParameter(String key) {
        Value<?> value = this.parameters.get(key);
        if (value == null) {
            return null;
        }
        return value.value;
    }

    public boolean onlyShader() {
        return this.onlyShader;
    }

    public boolean withTexture() {
        return this.withTexture;
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public boolean isVertex() {
        return this.vertex;
    }

    public Color getRenderColor() {
        return this.renderColor;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ShaderInstance getShaderState() {
        return PixelmonShaders.getShader(this.id);
    }

    public <T> ShaderParameters setParameter(String key, Codec<T> codec, T value) {
        return new Builder(this).withParameter(key, codec, value).build();
    }

    public ShaderParameters setRenderColor(Color color) {
        return new Builder(this).renderColor(color).build();
    }

    public ShaderParameters markOnlyShader() {
        return new Builder(this).onlyShader().build();
    }

    public ShaderParameters markModelAndShader() {
        return new Builder(this).modelAndShader().build();
    }

    public ShaderParameters useTexture() {
        return new Builder(this).texture().build();
    }

    public ShaderParameters noTexture() {
        return new Builder(this).texture().build();
    }

    public ShaderParameters wireframe() {
        return new Builder(this).wireframe().build();
    }

    public ShaderParameters vertex() {
        return new Builder(this).vertex().build();
    }

    public ShaderParameters full() {
        return new Builder(this).full().build();
    }

    public void apply() {
        ShaderInstance shader = PixelmonShaders.getShader(this.id);
        if (shader == null) {
            return;
        }
        for (Map.Entry<String, Value<?>> entry : this.parameters.entrySet()) {
            entry.getValue().apply(shader.m_173356_(entry.getKey()));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Value<T> {
        private final Codec<T> codec;
        private final T value;

        public Value(Codec<T> codec, T value) {
            this.codec = codec;
            this.value = value;
        }

        public void apply(AbstractUniform uniform) {
            T t = this.value;
            if (t instanceof Integer) {
                Integer intValue = (Integer)t;
                uniform.m_142617_(intValue.intValue());
            } else {
                t = this.value;
                if (t instanceof Float) {
                    Float floatValue = (Float)t;
                    uniform.m_5985_(floatValue.floatValue());
                } else {
                    t = this.value;
                    if (t instanceof List) {
                        List listValue = (List)t;
                        if (listValue.isEmpty()) {
                            return;
                        }
                        List floatList = listValue;
                        uniform.m_5941_(this.toFloats(floatList));
                    }
                }
            }
        }

        private float[] toFloats(List<Float> floats) {
            float[] array = new float[floats.size()];
            for (int i = 0; i < floats.size(); ++i) {
                array[i] = floats.get(i).floatValue();
            }
            return array;
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130070_((String)PixelmonCodecs.CODECS.inverse().get(this.codec));
            buf.m_272073_(this.codec, this.value);
        }

        public static <A> Value<A> read(FriendlyByteBuf buf) {
            Codec codec = (Codec)PixelmonCodecs.CODECS.get((Object)buf.m_130277_());
            return new Value<Object>(codec, buf.m_271872_(codec));
        }
    }

    public static class Builder {
        private ResourceLocation id;
        private Map<String, Value<?>> parameters = Maps.newHashMap();
        private Color renderColor = Color.WHITE;
        private boolean onlyShader = false;
        private boolean withTexture = false;
        private boolean wireframe = false;
        private boolean vertex = false;

        protected Builder() {
        }

        protected Builder(ShaderParameters parameters) {
            this.id(parameters.id).withParameters(parameters.parameters).renderColor(parameters.renderColor);
            this.onlyShader = parameters.onlyShader;
            this.withTexture = parameters.withTexture();
        }

        public Builder id(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder renderColor(Color renderColor) {
            this.renderColor = renderColor;
            return this;
        }

        public Builder withParameters(Map<String, Value<?>> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public <T> Builder withParameter(String key, Codec<T> codec, T value) {
            this.parameters.put(key, new Value<T>(codec, value));
            return this;
        }

        public Builder onlyShader() {
            this.onlyShader = true;
            return this;
        }

        public Builder modelAndShader() {
            this.onlyShader = false;
            return this;
        }

        public Builder noTexture() {
            this.withTexture = false;
            return this;
        }

        public Builder texture() {
            this.withTexture = true;
            return this;
        }

        public Builder wireframe() {
            this.wireframe = true;
            this.vertex = false;
            return this;
        }

        public Builder vertex() {
            this.vertex = true;
            this.wireframe = false;
            return this;
        }

        public Builder full() {
            this.wireframe = false;
            this.vertex = false;
            return this;
        }

        public ShaderParameters build() {
            if (this.id == null) {
                throw new IllegalArgumentException("Shader ID must be specified");
            }
            return new ShaderParameters(this.id, this.parameters, this.renderColor, this.onlyShader, this.withTexture, this.wireframe, this.vertex);
        }
    }
}

