/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.ThrowableSupplier;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pixelmon", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class PixelmonShaders {
    public static final ResourceLocation FRESNEL_SHADER = ResourceLocationHelper.of("pixelmon", "rendertype_entity_smooth_cutout_fresnel");
    public static final ResourceLocation NORMAL_MAP_SHADER = ResourceLocationHelper.of("pixelmon", "normal_mapping");
    public static final ResourceLocation BLACK_AND_WHITE_SHADER = ResourceLocationHelper.of("pixelmon", "black_and_white");
    public static final ResourceLocation RAINBOW_SHADER = ResourceLocationHelper.of("pixelmon", "rainbow");
    public static final ResourceLocation CEL_SHADER = ResourceLocationHelper.of("pixelmon", "cel");
    public static ShaderInstance rendertypeEntitySmoothCutoutFresnelShader;
    public static ShaderInstance normalMappingShader;
    public static ShaderInstance blackAndWhiteShader;
    public static ShaderInstance rainbowShader;
    public static ShaderInstance celShader;
    public static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_SMOOTH_CUTOUT_FRESNEL_SHADER;

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) {
        PixelmonShaders.createShaderSafely(event, () -> new ShaderInstance(event.getResourceProvider(), FRESNEL_SHADER, DefaultVertexFormat.f_85812_), shader -> {
            rendertypeEntitySmoothCutoutFresnelShader = shader;
        });
        PixelmonShaders.createShaderSafely(event, () -> new ShaderInstance(event.getResourceProvider(), NORMAL_MAP_SHADER, DefaultVertexFormat.f_85812_), shader -> {
            normalMappingShader = shader;
        });
        PixelmonShaders.createShaderSafely(event, () -> new ShaderInstance(event.getResourceProvider(), BLACK_AND_WHITE_SHADER, DefaultVertexFormat.f_85812_), shader -> {
            blackAndWhiteShader = shader;
        });
        PixelmonShaders.createShaderSafely(event, () -> new ShaderInstance(event.getResourceProvider(), RAINBOW_SHADER, DefaultVertexFormat.f_85812_), shader -> {
            rainbowShader = shader;
        });
        PixelmonShaders.createShaderSafely(event, () -> new ShaderInstance(event.getResourceProvider(), CEL_SHADER, DefaultVertexFormat.f_85812_), shader -> {
            celShader = shader;
        });
    }

    private static void createShaderSafely(RegisterShadersEvent event, ThrowableSupplier<ShaderInstance> supplier, Consumer<ShaderInstance> setter) {
        try {
            ShaderInstance shader = supplier.get();
            event.registerShader(shader, setter);
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Failed to create shader!");
            e.printStackTrace();
        }
    }

    public static ShaderInstance getShader(ResourceLocation shaderLocation) {
        return Minecraft.m_91087_().f_91063_.m_172734_(shaderLocation.m_135827_().equals("minecraft") ? shaderLocation.m_135815_() : shaderLocation.toString());
    }

    static {
        RENDERTYPE_ENTITY_SMOOTH_CUTOUT_FRESNEL_SHADER = new RenderStateShard.ShaderStateShard(() -> rendertypeEntitySmoothCutoutFresnelShader);
    }
}

