/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.shader;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector3f;

public class PixelmonCodecs {
    public static final Codec<Color> COLOR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf("red").forGetter(Color::getRed), (App)Codec.intRange((int)0, (int)255).fieldOf("green").forGetter(Color::getGreen), (App)Codec.intRange((int)0, (int)255).fieldOf("blue").forGetter(Color::getBlue), (App)Codec.intRange((int)0, (int)255).fieldOf("alpha").forGetter(Color::getAlpha)).apply((Applicative)instance, Color::new));
    public static final Codec<Vector3f> OPTIONAL_DIMENSIONS_CODEC = Codec.either((Codec)ExtraCodecs.f_252432_, (Codec)Codec.FLOAT).xmap(either -> {
        if (either.left().isPresent()) {
            return (Vector3f)either.left().get();
        }
        if (either.right().isPresent()) {
            Float val = (Float)either.right().get();
            return new Vector3f(val.floatValue(), val.floatValue(), val.floatValue());
        }
        return null;
    }, Either::left);
    public static final BiMap<String, Codec<?>> CODECS = HashBiMap.create();

    public static void init() {
        CODECS.put((Object)"int", (Object)Codec.INT);
        CODECS.put((Object)"float", (Object)Codec.FLOAT);
        CODECS.put((Object)"float_array", (Object)Codec.FLOAT.listOf());
    }
}

