/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.render.layers.LayerEquippables;
import com.pixelmonmod.pixelmon.client.render.player.LayerWrapper;
import com.pixelmonmod.pixelmon.client.render.player.ModelPlayerOnBike;
import com.pixelmonmod.pixelmon.client.render.player.PixelRenderPlayer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.UIKeyPressPacket;
import com.pixelmonmod.pixelmon.entities.bikes.BikeEntity;
import com.pixelmonmod.pixelmon.enums.TextJustification;
import com.pixelmonmod.pixelmon.items.UIElementItem;
import java.awt.Color;
import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderEvents {
    private PlayerModel<AbstractClientPlayer> oldModel = null;
    private HumanoidModel<?> oldModelArmor = null;
    private HumanoidModel<?> oldModelLeggings = null;
    private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.Pre event) {
        if (event.getItemStack().m_41720_() instanceof UIElementItem && event.getItemStack().m_41786_().getString().isEmpty()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKeyPress(ScreenEvent.KeyPressed.Pre event) {
        if (event.getScreen() instanceof MenuAccess) {
            MenuAccess container = (MenuAccess)event.getScreen();
            for (Slot slot : container.m_6262_().f_38839_) {
                ItemStack stack;
                if (!slot.m_6657_() || !((stack = slot.m_7993_()).m_41720_() instanceof UIElementItem)) continue;
                int keyCode = event.getKeyCode();
                int scanCode = event.getScanCode();
                int modifiers = event.getModifiers();
                NetworkHelper.sendToServer(new UIKeyPressPacket(keyCode, scanCode, modifiers));
                if (Minecraft.m_91087_().f_91066_.f_92092_.getKey().m_84873_() != event.getKeyCode()) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onRenderContainer(ContainerScreenEvent.Render.Foreground event) {
        for (Slot slot : event.getContainerScreen().m_6262_().f_38839_) {
            ItemStack stack;
            if (!slot.m_6657_() || !((stack = slot.m_7993_()).m_41720_() instanceof UIElementItem)) continue;
            PoseStack matrix = event.getGuiGraphics().m_280168_();
            boolean hover = event.getContainerScreen().getSlotUnderMouse() == slot;
            int x = UIElementItem.getXOverride(stack).orElse(slot.f_40220_ - 1) + UIElementItem.getXOffset(stack).orElse(0);
            int y = UIElementItem.getYOverride(stack).orElse(slot.f_40221_ - 1) + UIElementItem.getYOffset(stack).orElse(0);
            int z = UIElementItem.getZLevel(stack).orElse(0);
            float[] rgba = UIElementItem.getColor(stack, hover).orElse(WHITE);
            matrix.m_85836_();
            matrix.m_252880_((float)x, (float)y, (float)z);
            matrix.m_252781_(QuaternionHelper.fromEuler(UIElementItem.getRotation(stack), 0.0f, 0.0f, 1.0f));
            float[] scale = UIElementItem.getScale(stack);
            matrix.m_85841_(scale[0], scale[1], 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            UIElementItem.getImage(stack, hover).ifPresent(rl -> {
                int w = UIElementItem.getImageWidth(stack).orElse(16);
                int h = UIElementItem.getImageHeight(stack).orElse(16);
                float u = UIElementItem.getImageU(stack).orElse(Float.valueOf(0.0f)).floatValue();
                float v = UIElementItem.getImageV(stack).orElse(Float.valueOf(0.0f)).floatValue();
                ScreenHelper.drawImageQuadUV(rl, event.getGuiGraphics(), 1.0f, 1.0f, w, h, u, v, w, h, rgba[0], rgba[1], rgba[2], rgba[3], z);
            });
            UIElementItem.getText(stack, hover).ifPresent(text -> {
                TextJustification j = UIElementItem.getTextJustification(stack);
                float s = UIElementItem.getTextScale(stack);
                switch (j) {
                    case RIGHT: {
                        ScreenHelper.drawScaledString(event.getGuiGraphics(), text, 0.0f, 0.0f, new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB(), s);
                        break;
                    }
                    case CENTER: {
                        ScreenHelper.drawScaledCenteredString(event.getGuiGraphics(), text, 0.0f, 0.0f, new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB(), s);
                        break;
                    }
                    case LEFT: {
                        ScreenHelper.drawScaledStringRightAligned(event.getGuiGraphics(), text, 0.0f, 0.0f, new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB(), false, s);
                    }
                }
            });
            matrix.m_85849_();
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        if (event.getRenderer() instanceof PixelRenderPlayer) {
            RenderLayer layer;
            ListIterator<LayerWrapper> i;
            PixelRenderPlayer renderPlayer = (PixelRenderPlayer)event.getRenderer();
            if (LayerEquippables.hasEquippables(player)) {
                i = event.getRenderer().f_115291_.listIterator();
                while (i.hasNext()) {
                    layer = (RenderLayer)i.next();
                    if (!(layer instanceof CustomHeadLayer)) continue;
                    i.remove();
                }
            }
            if (player.m_20202_() instanceof BikeEntity) {
                this.oldModel = (PlayerModel)renderPlayer.m_7200_();
                renderPlayer.setModel(new ModelPlayerOnBike(this.oldModel.f_102810_, renderPlayer.isAlex));
                i = event.getRenderer().f_115291_.listIterator();
                while (i.hasNext()) {
                    layer = (RenderLayer)i.next();
                    if (layer instanceof HumanoidArmorLayer) {
                        HumanoidArmorLayer layerArmor = (HumanoidArmorLayer)layer;
                        this.oldModelArmor = layerArmor.f_117072_;
                        this.oldModelLeggings = layerArmor.f_117071_;
                        continue;
                    }
                    if (layer instanceof ElytraLayer) {
                        i.set(new LayerWrapper((RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)layer).setTranslates(0.0, 0.03, -0.25));
                        continue;
                    }
                    if (layer instanceof CustomHeadLayer) {
                        i.set(new LayerWrapper((RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)layer).setTranslates(0.0, 0.05, -0.2f));
                        continue;
                    }
                    if (!(layer instanceof ArrowLayer) && !(layer instanceof CustomHeadLayer)) continue;
                    i.set(new LayerWrapper((RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)layer).setEnabled(false));
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        boolean hasCustomHead = false;
        ListIterator i2 = event.getRenderer().f_115291_.listIterator();
        while (i2.hasNext()) {
            RenderLayer layer = (RenderLayer)i2.next();
            if (!(layer instanceof CustomHeadLayer)) continue;
            hasCustomHead = true;
            break;
        }
        if (this.oldModel != null) {
            if (event.getRenderer() instanceof PixelRenderPlayer) {
                PixelRenderPlayer renderPlayer = (PixelRenderPlayer)event.getRenderer();
                renderPlayer.setModel(this.oldModel);
                ListIterator<RenderLayer> i = event.getRenderer().f_115291_.listIterator();
                while (i.hasNext()) {
                    RenderLayer layer = (RenderLayer)i.next();
                    if (this.oldModelArmor != null && layer instanceof HumanoidArmorLayer || !(layer instanceof LayerWrapper)) continue;
                    if (((LayerWrapper)layer).layer instanceof CustomHeadLayer) {
                        RenderLayer customHead = layer;
                        i.set(customHead);
                        continue;
                    }
                    i.set(layer);
                }
                this.oldModelArmor = null;
                this.oldModelLeggings = null;
            }
            this.oldModel = null;
        }
    }
}

