/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers.npc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.NPCRenderer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.enums.CustomModel;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class LayerMegaItemsNPC
extends RenderLayer<NPCEntity, PlayerModel<NPCEntity>> {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/megabraceletoras.png");
    private static final ResourceLocation NECKLACE_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/boost_necklace.png");
    private static final ResourceLocation GLASSES_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_glasses.png");
    private static final ResourceLocation ANCHOR_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_anchor.png");
    private static final ResourceLocation DYNAMAX_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/dynamax_band.png");
    private final Model braceletModel = CustomModel.MEGA_BRACELET_ORAS.getModel();
    private final Model stoneModel = CustomModel.MEGA_BRACELET_ORAS_STONE.getModel();
    private final Model necklace = CustomModel.MEGA_BOOST_NECKLACE.getModel();
    private final Model glasses = CustomModel.MEGA_GLASSES.getModel();
    private final Model anchor = CustomModel.MEGA_ANCHOR.getModel();
    private final Model dynamax = CustomModel.DYNAMAX_BAND.getModel();
    private final NPCRenderer renderer;
    private float scale = 1.0f;

    public LayerMegaItemsNPC(NPCRenderer renderer) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int packedLight, NPCEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof NPCTrainer)) {
            return;
        }
        NPCTrainer trainer = (NPCTrainer)entity;
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f);
        boolean oldGenWorld = PixelmonConfigProxy.getGeneral().getOldGenDimensions().contains(entity.m_9236_().m_46472_().toString());
        EnumOldGenMode oldGenMode = trainer.getOldGen();
        EnumMegaItemsUnlocked itemInUse = trainer.getMegaItem();
        EnumMegaItem megaItem = EnumMegaItem.None;
        if (oldGenMode == EnumOldGenMode.World) {
            if (oldGenWorld && itemInUse.canMega()) {
                megaItem = EnumMegaItem.BraceletORAS;
            } else if (!oldGenWorld && itemInUse.canDynamax()) {
                megaItem = EnumMegaItem.DynamaxBand;
            }
        } else if (oldGenMode == EnumOldGenMode.Mega && itemInUse.canMega()) {
            megaItem = EnumMegaItem.BraceletORAS;
        } else if (oldGenMode == EnumOldGenMode.Dynamax && itemInUse.canDynamax()) {
            megaItem = EnumMegaItem.DynamaxBand;
        }
        if (megaItem == EnumMegaItem.None || trainer.m_20145_()) {
            return;
        }
        PlayerModel biped = (PlayerModel)this.renderer.m_7200_();
        ModelPart left = biped.f_102812_;
        matrix.m_85836_();
        if (megaItem == EnumMegaItem.BraceletORAS) {
            if (entity.m_6144_()) {
                matrix.m_252880_(0.0f, 0.2f, 0.0f);
            }
            this.scale = !left.f_104212_.isEmpty() && ((ModelPart.Cube)left.f_104212_.get((int)0)).f_104338_ == 2.0f ? 0.17f : 0.19f;
            biped.m_6002_(HumanoidArm.LEFT, matrix);
            matrix.m_252880_(0.0f, 0.4f, 0.0f);
            matrix.m_85841_(this.scale, this.scale, this.scale);
            matrix.m_252880_(0.35f, 0.0f, 0.0f);
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(TEXTURE));
            this.braceletModel.m_7695_(matrix, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            this.stoneModel.m_7695_(matrix, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 0.4f);
        } else {
            if (entity.m_6144_()) {
                matrix.m_252880_(0.0f, 0.2f, 0.0f);
            }
            this.scale = 1.05f;
            if (!left.f_104212_.isEmpty() && ((ModelPart.Cube)left.f_104212_.get((int)0)).f_104338_ == 2.0f) {
                this.scale = 1.02f;
            }
            biped.m_6002_(HumanoidArm.LEFT, matrix);
            matrix.m_252880_(0.0f, 0.4f, 0.0f);
            matrix.m_85841_(this.scale, this.scale, this.scale);
            matrix.m_252781_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
            matrix.m_252880_(-0.3f, 0.0f, 0.875f);
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(DYNAMAX_TEXTURE));
            this.dynamax.m_7695_(matrix, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrix.m_85849_();
    }
}

