/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PixelmonLayerRobe
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final ResourceLocation WIZARD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/wizard.png");
    private static final ResourceLocation HWEEN_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/hween.png");
    private static final ResourceLocation ALTER_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/alter.png");
    private static final ResourceLocation STRIKE_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/strike.png");
    private static final ResourceLocation ASHEN_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/ashen.png");
    private static final ResourceLocation ABOMASNOW_CLOAK_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/abomasnow_cloak.png");
    private static final ResourceLocation FROSLASS_YUKATA_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/robe/yukata.png");
    private static final ModelHolder<GenericSmdModel> WIZARD_ROBE = new GenericModelHolder<GenericSmdModel>("playeritems/robe/robe.pqc");
    private static final ModelHolder<GenericSmdModel> WIZARD_ROBE_ARM = new GenericModelHolder<GenericSmdModel>("playeritems/robe/robe_arm.pqc");
    private static final ModelHolder<GenericSmdModel> HWEEN_ROBE = new GenericModelHolder<GenericSmdModel>("playeritems/robe/hween_robe.pqc");
    private static final ModelHolder<GenericSmdModel> HWEEN_ROBE_LEFT = new GenericModelHolder<GenericSmdModel>("playeritems/robe/hween_robe_left_arm.pqc");
    private static final ModelHolder<GenericSmdModel> HWEEN_ROBE_RIGHT = new GenericModelHolder<GenericSmdModel>("playeritems/robe/hween_robe_right_arm.pqc");
    private static final ModelHolder<GenericSmdModel> ABOMASNOW_CLOAK = new GenericModelHolder<GenericSmdModel>("playeritems/robe/abomasnow_cloak.pqc");
    private static final ModelHolder<GenericSmdModel> ABOMASNOW_CLOAK_ARM = new GenericModelHolder<GenericSmdModel>("playeritems/robe/abomasnow_cloak_arm.pqc");
    private static final ModelHolder<GenericSmdModel> YUKATA_ROBE = new GenericModelHolder<GenericSmdModel>("playeritems/robe/yukata.pqc");
    private static final ModelHolder<GenericSmdModel> YUKATA_LEFT_ARM = new GenericModelHolder<GenericSmdModel>("playeritems/robe/yukata_left_arm.pqc");
    private static final ModelHolder<GenericSmdModel> YUKATA_RIGHT_ARM = new GenericModelHolder<GenericSmdModel>("playeritems/robe/yukata_right_arm.pqc");
    private final PlayerRenderer renderer;
    ModelPart leftArm;
    ModelPart rightArm;

    public PixelmonLayerRobe(PlayerRenderer renderer) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        PixelExtrasData extras = PlayerExtraDataStore.get((Player)player);
        if (!extras.isReady() || !extras.isEnabled(PixelExtrasData.Category.ROBE) || extras.getRobeType() == PixelExtrasData.RobeType.NONE || player.m_20145_()) {
            return;
        }
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        PixelExtrasData.RobeType robeType = extras.getRobeType();
        this.leftArm = ((PlayerModel)this.renderer.m_7200_()).f_102812_;
        this.rightArm = ((PlayerModel)this.renderer.m_7200_()).f_102811_;
        ModelPart body = ((PlayerModel)this.renderer.m_7200_()).f_102810_;
        Minecraft.m_91087_().m_91307_().m_6180_("layer_robe");
        matrix.m_85836_();
        body.m_104299_(matrix);
        matrix.m_252880_(0.0f, 1.22f, 0.0f);
        matrix.m_85841_(0.36f, 0.45f, 0.45f);
        VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(this.getTexture(robeType)));
        if (robeType == PixelExtrasData.RobeType.WIZARD || robeType == PixelExtrasData.RobeType.ALTER || robeType == PixelExtrasData.RobeType.STRIKE || robeType == PixelExtrasData.RobeType.ASHEN) {
            WIZARD_ROBE.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (robeType == PixelExtrasData.RobeType.DROWNED) {
            HWEEN_ROBE.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (robeType == PixelExtrasData.RobeType.WINTER_CLOAK) {
            ABOMASNOW_CLOAK.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (robeType == PixelExtrasData.RobeType.FROSLASS_YUKATA) {
            YUKATA_ROBE.getModel().render(matrix, vertices, packedLight, packedOverlay);
        }
        matrix.m_85849_();
        matrix.m_85836_();
        this.renderArm(matrix, vertices, packedLight, packedOverlay, robeType, HumanoidArm.RIGHT);
        matrix.m_85849_();
        matrix.m_85836_();
        this.renderArm(matrix, vertices, packedLight, packedOverlay, robeType, HumanoidArm.LEFT);
        matrix.m_85849_();
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    private ResourceLocation getTexture(PixelExtrasData.RobeType type) {
        if (type == PixelExtrasData.RobeType.WIZARD) {
            return WIZARD_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.DROWNED) {
            return HWEEN_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.ALTER) {
            return ALTER_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.STRIKE) {
            return STRIKE_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.ASHEN) {
            return ASHEN_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.FROSLASS_YUKATA) {
            return FROSLASS_YUKATA_TEXTURE;
        }
        if (type == PixelExtrasData.RobeType.WINTER_CLOAK) {
            return ABOMASNOW_CLOAK_TEXTURE;
        }
        return WIZARD_TEXTURE;
    }

    private void renderArm(PoseStack matrix, VertexConsumer vertices, int light, int overlay, PixelExtrasData.RobeType type, HumanoidArm arm) {
        if (type == PixelExtrasData.RobeType.WIZARD || type == PixelExtrasData.RobeType.ALTER || type == PixelExtrasData.RobeType.STRIKE || type == PixelExtrasData.RobeType.ASHEN) {
            if (arm == HumanoidArm.RIGHT) {
                ((PlayerModel)this.renderer.m_7200_()).m_6002_(HumanoidArm.RIGHT, matrix);
                matrix.m_85841_(0.43f, 0.43f, 0.46f);
            } else {
                ((PlayerModel)this.renderer.m_7200_()).m_6002_(HumanoidArm.LEFT, matrix);
                matrix.m_85841_(0.43f, 0.43f, 0.46f);
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
            }
            PixelmonLayerRobe.WIZARD_ROBE_ARM.getModel().modelRenderer.offsetX = -0.2;
            WIZARD_ROBE_ARM.getModel().render(matrix, vertices, light, overlay);
        } else if (type == PixelExtrasData.RobeType.DROWNED) {
            if (arm == HumanoidArm.RIGHT) {
                ((PlayerModel)this.renderer.m_7200_()).m_6002_(HumanoidArm.RIGHT, matrix);
                matrix.m_85841_(0.43f, 0.43f, 0.46f);
                matrix.m_85837_(0.1, 0.0, 0.0);
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                HWEEN_ROBE_RIGHT.getModel().render(matrix, vertices, light, overlay);
            } else {
                ((PlayerModel)this.renderer.m_7200_()).m_6002_(HumanoidArm.LEFT, matrix);
                matrix.m_85841_(0.43f, 0.43f, 0.46f);
                matrix.m_85837_(-0.1, 0.0, 0.0);
                HWEEN_ROBE_LEFT.getModel().render(matrix, vertices, light, overlay);
            }
        } else if (type == PixelExtrasData.RobeType.WINTER_CLOAK) {
            if (arm == HumanoidArm.RIGHT) {
                ((PlayerModel)this.renderer.m_7200_()).m_6002_(HumanoidArm.RIGHT, matrix);
                matrix.m_85841_(0.43f, 0.43f, 0.46f);
                matrix.m_85837_(0.05, 0.06, 0.0);
                ABOMASNOW_CLOAK_ARM.getModel().render(matrix, vertices, light, overlay);
            } else {
                ((PlayerModel)this.renderer.m_7200_()).m_6002_(HumanoidArm.LEFT, matrix);
                matrix.m_85841_(0.43f, 0.43f, 0.46f);
                matrix.m_85837_(-0.09, 0.04, 0.0);
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                ABOMASNOW_CLOAK_ARM.getModel().render(matrix, vertices, light, overlay);
            }
        } else if (type == PixelExtrasData.RobeType.FROSLASS_YUKATA) {
            if (arm == HumanoidArm.RIGHT) {
                ((PlayerModel)this.renderer.m_7200_()).m_6002_(HumanoidArm.RIGHT, matrix);
                matrix.m_85841_(0.43f, 0.43f, 0.46f);
                matrix.m_85837_(0.05, 0.06, 0.0);
                YUKATA_RIGHT_ARM.getModel().render(matrix, vertices, light, overlay);
            } else {
                ((PlayerModel)this.renderer.m_7200_()).m_6002_(HumanoidArm.LEFT, matrix);
                matrix.m_85841_(0.43f, 0.43f, 0.46f);
                matrix.m_85837_(-0.09, 0.06, 0.0);
                YUKATA_LEFT_ARM.getModel().render(matrix, vertices, light, overlay);
            }
        }
    }
}

