/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class PixelmonLayerHead
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final ResourceLocation TOP_HAT_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/tophat.png");
    private final ResourceLocation FEZ_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/fez.png");
    private final ResourceLocation FEDORA_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/fedora.png");
    private final ResourceLocation TRAINERHAT_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/trainerhat.png");
    private final ResourceLocation PIKAHOOD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/pikahood.png");
    private final ResourceLocation EEVEEHOOD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/eeveehood.png");
    private final ResourceLocation SCORHOOD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/scorhood.png");
    private final ResourceLocation ESPEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/espeon_scarf.png");
    private final ResourceLocation FLAREON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/flareon_scarf.png");
    private final ResourceLocation GLACEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/glaceon_scarf.png");
    private final ResourceLocation JOLTEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/jolteon_scarf.png");
    private final ResourceLocation LEAFEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/leafeon_scarf.png");
    private final ResourceLocation SYLVEON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/sylveon_scarf.png");
    private final ResourceLocation UMBREON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/umbreon_scarf.png");
    private final ResourceLocation VAPOREON_SCARF_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/vaporeon_scarf.png");
    private final ResourceLocation WIKI_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/grad_cap.png");
    private final ResourceLocation GOLD_MONOCLE_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/monocle_gold.png");
    private final ResourceLocation BLACK_MONOCLE_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/monocle_black.png");
    private final ResourceLocation QUAGSIRE_MASK_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/quagsire_mask.png");
    private final ResourceLocation QUARANTINE_MASK_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/quarantine_mask.png");
    private final ResourceLocation WELKIN_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/welkin.png");
    private final ResourceLocation SABLEYE_HOOD_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/hats/sableye_hood.png");
    public static final ResourceLocation WITCH_HAT_MODEL = ResourceLocationHelper.of("pixelmon", "playeritems/hats/witch");
    private final ModelHolder<GenericSmdModel> TOPHAT_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/tophat.pqc");
    private final ModelHolder<GenericSmdModel> FEZ_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/fez.pqc");
    private final ModelHolder<GenericSmdModel> FEDORA_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/fedora.pqc");
    private final ModelHolder<GenericSmdModel> TRAINERHAT_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/trainerhat.pqc");
    private final ModelHolder<GenericSmdModel> PIKAHOOD_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/pikahood.pqc");
    private final ModelHolder<GenericSmdModel> ESPEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/espeon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> FLAREON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/flareon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> GLACEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/glaceon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> JOLTEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/jolteon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> LEAFEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/leafeon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> SYLVEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sylveon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> UMBREON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/umbreon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> VAPOREON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/vaporeon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> WIKI_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/grad_cap.pqc");
    private final ModelHolder<GenericSmdModel> MONOCLE_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/monocle.pqc");
    private final ModelHolder<GenericSmdModel> QUAGSIRE_MASK_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/quagsire_mask.pqc");
    private final ModelHolder<GenericSmdModel> QUARANTINE_MASK_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/quarantine_mask.pqc");
    private final ModelHolder<GenericSmdModel> WELKIN_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/welkin.pqc");
    private final ModelHolder<GenericSmdModel> SABLEYE_HOOD_HEAD_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sableye_hood_head.pqc");
    private final ModelHolder<GenericSmdModel> SABLEYE_HOOD_BODY_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sableye_hood_body.pqc");
    private final ResourceLocation SPHEAL_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/sphealhat.png");
    private final ResourceLocation SHINYSPHEAL_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/shinysphealhat.png");
    private final ResourceLocation SPHEAL_STITCHED_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/sphealhatstitches.png");
    private final ResourceLocation SHINYSPHEAL_STICHED_TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/shinysphealhatstitches.png");
    private final ModelHolder<GenericSmdModel> SPHEALHAT_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sphealhat.pqc");
    private ModelPart head;
    private final PlayerRenderer renderer;
    private ResourceLocation locationCapBG;
    private DynamicTexture capBG;
    private boolean init = false;

    public PixelmonLayerHead(PlayerRenderer renderer) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        PixelExtrasData extras;
        if (!this.init) {
            this.capBG = new DynamicTexture(1, 1, true);
            this.capBG.m_117991_().m_84988_(0, 0, -1);
            this.capBG.m_117985_();
            this.locationCapBG = Minecraft.m_91087_().m_91097_().m_118490_("capbg", this.capBG);
            this.init = true;
        }
        if (!(extras = PlayerExtraDataStore.get((Player)player)).isReady() || player.m_20145_()) {
            return;
        }
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        this.head = ((PlayerModel)this.renderer.m_7200_()).f_102808_;
        Minecraft.m_91087_().m_91307_().m_6180_("layer_hat");
        if (extras.isEnabled(PixelExtrasData.Category.HAT) && extras.getHatType() != PixelExtrasData.HatType.NONE) {
            if (extras.getHatType() == PixelExtrasData.HatType.SABLEYE_HOOD) {
                matrix.m_85836_();
                ModelPart body = ((PlayerModel)this.renderer.m_7200_()).f_102810_;
                body.m_104299_(matrix);
                matrix.m_85837_(0.0, 1.4, 0.0);
                this.SABLEYE_HOOD_BODY_MODEL.getModel().render(matrix, buffer.m_6299_(PixelmonRendering.getSMDRenderType(this.SABLEYE_HOOD_TEXTURE)), packedLight, packedOverlay);
                matrix.m_85849_();
            } else if (extras.getHatType() == PixelExtrasData.HatType.WITCH) {
                matrix.m_85836_();
                BakedModel model = Minecraft.m_91087_().m_91304_().getModel(WITCH_HAT_MODEL);
                ((PlayerModel)this.renderer.m_7200_()).m_5585_().m_104299_(matrix);
                matrix.m_252781_(Axis.f_252393_.m_252977_(180.0f));
                matrix.m_85837_(-0.5, 0.4, -0.5);
                if (model != null) {
                    PixelmonRendering.renderQuadList(matrix.m_85850_(), buffer.m_6299_(RenderType.m_110463_()), 1.0f, 1.0f, 1.0f, model.getQuads(null, null, RandomSource.m_216327_(), ModelData.EMPTY, RenderType.m_110463_()), packedLight, packedOverlay);
                }
                matrix.m_85849_();
            }
            matrix.m_85836_();
            this.renderHat(matrix, buffer, packedLight, packedOverlay, (Player)player, extras, partialTicks);
            matrix.m_85849_();
        }
        if (extras.isEnabled(PixelExtrasData.Category.MONOCLE) && (extras.getMonocleType() == PixelExtrasData.MonocleType.QUAGSIRE_MASK || extras.getMonocleType() == PixelExtrasData.MonocleType.QUARANTINE_MASK)) {
            matrix.m_85836_();
            this.renderMask(matrix, buffer, packedLight, packedOverlay, (Player)player, extras, partialTicks);
            matrix.m_85849_();
        } else if (extras.isEnabled(PixelExtrasData.Category.MONOCLE) && extras.getMonocleType() != PixelExtrasData.MonocleType.NONE) {
            matrix.m_85836_();
            this.renderMonocle(matrix, buffer, packedLight, packedOverlay, (Player)player, extras, partialTicks);
            matrix.m_85849_();
        }
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public void renderHat(PoseStack matrix, MultiBufferSource buffer, int light, int overlay, Player player, PixelExtrasData data, float partialTicks) {
        VertexConsumer vertices;
        ResourceLocation path;
        ModelHolder<GenericSmdModel> hat;
        block0 : switch (data.getHatType()) {
            case TOP_HAT: {
                hat = this.TOPHAT_MODEL;
                path = this.TOP_HAT_TEXTURE;
                break;
            }
            case FEZ: {
                hat = this.FEZ_MODEL;
                path = this.FEZ_TEXTURE;
                break;
            }
            case FEDORA: {
                hat = this.FEDORA_MODEL;
                path = this.FEDORA_TEXTURE;
                break;
            }
            case TRAINER_CAP: {
                hat = this.TRAINERHAT_MODEL;
                path = this.TRAINERHAT_TEXTURE;
                break;
            }
            case PIKA_HOOD: {
                hat = this.PIKAHOOD_MODEL;
                path = this.PIKAHOOD_TEXTURE;
                break;
            }
            case EEVEE_HOOD: {
                hat = this.PIKAHOOD_MODEL;
                path = this.EEVEEHOOD_TEXTURE;
                break;
            }
            case SCOR_HOOD: {
                hat = this.PIKAHOOD_MODEL;
                path = this.SCORHOOD_TEXTURE;
                break;
            }
            case WIKI: {
                hat = this.WIKI_MODEL;
                path = this.WIKI_TEXTURE;
                break;
            }
            case WELKIN_HAT: {
                hat = this.WELKIN_MODEL;
                path = this.WELKIN_TEXTURE;
                break;
            }
            case ESPEON_SCARF: {
                hat = this.ESPEON_SCARF;
                path = this.ESPEON_SCARF_TEXTURE;
                break;
            }
            case FLAREON_SCARF: {
                hat = this.FLAREON_SCARF;
                path = this.FLAREON_SCARF_TEXTURE;
                break;
            }
            case GLACEON_SCARF: {
                hat = this.GLACEON_SCARF;
                path = this.GLACEON_SCARF_TEXTURE;
                break;
            }
            case JOLTEON_SCARF: {
                hat = this.JOLTEON_SCARF;
                path = this.JOLTEON_SCARF_TEXTURE;
                break;
            }
            case LEAFEON_SCARF: {
                hat = this.LEAFEON_SCARF;
                path = this.LEAFEON_SCARF_TEXTURE;
                break;
            }
            case SYLVEON_SCARF: {
                hat = this.SYLVEON_SCARF;
                path = this.SYLVEON_SCARF_TEXTURE;
                break;
            }
            case UMBREON_SCARF: {
                hat = this.UMBREON_SCARF;
                path = this.UMBREON_SCARF_TEXTURE;
                break;
            }
            case VAPOREON_SCARF: {
                hat = this.VAPOREON_SCARF;
                path = this.VAPOREON_SCARF_TEXTURE;
                break;
            }
            case SABLEYE_HOOD: {
                hat = this.SABLEYE_HOOD_HEAD_MODEL;
                path = this.SABLEYE_HOOD_TEXTURE;
                break;
            }
            case SPHEAL_HAT: {
                hat = this.SPHEALHAT_MODEL;
                switch (data.getSphealType()) {
                    default: {
                        path = this.SPHEAL_TEXTURE;
                        break block0;
                    }
                    case SHINY: {
                        path = this.SHINYSPHEAL_TEXTURE;
                        break block0;
                    }
                    case STITCHED: {
                        path = this.SPHEAL_STITCHED_TEXTURE;
                        break block0;
                    }
                    case SHINY_STITCHED: 
                }
                path = this.SHINYSPHEAL_STICHED_TEXTURE;
                break;
            }
            default: {
                return;
            }
        }
        matrix.m_85836_();
        this.head.m_104299_(matrix);
        matrix.m_252880_(0.0f, 1.5f, 0.0f);
        if (data.getHatType() == PixelExtrasData.HatType.TRAINER_CAP) {
            vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(this.locationCapBG));
            if (data.getColours(PixelExtrasData.Category.HAT)[0] == -1) {
                int i = player.f_19797_ / 25 + player.m_19879_();
                int j = DyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f7 = ((float)(player.f_19797_ % 25) + partialTicks) / 25.0f;
                float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
                float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
                float r = afloat1[0] * (1.0f - f7) + afloat2[0] * f7;
                float g = afloat1[1] * (1.0f - f7) + afloat2[1] * f7;
                float b = afloat1[2] * (1.0f - f7) + afloat2[2] * f7;
                this.capBG.m_117991_().m_84988_(0, 0, 0xFF000000 | (int)((double)(r * 255.0f) + 0.5) << 16 | (int)((double)(g * 255.0f) + 0.5) << 8 | (int)((double)(b * 255.0f) + 0.5));
            } else {
                this.capBG.m_117991_().m_84988_(0, 0, 0xFF000000 | data.getColours(PixelExtrasData.Category.HAT)[0] << 16 | data.getColours(PixelExtrasData.Category.HAT)[1] << 8 | data.getColours(PixelExtrasData.Category.HAT)[2]);
            }
            this.capBG.m_117985_();
            hat.getModel().render(matrix, vertices, light, overlay);
        }
        vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(path));
        hat.getModel().render(matrix, vertices, light, overlay);
        matrix.m_85849_();
    }

    public void renderMonocle(PoseStack matrix, MultiBufferSource buffer, int light, int overlay, Player player, PixelExtrasData data, float partialTicks) {
        matrix.m_85836_();
        this.head.m_104299_(matrix);
        matrix.m_252880_(0.0f, 1.5f, 0.0f);
        matrix.m_252880_(0.15f, -1.45f, -0.29f);
        matrix.m_85841_(0.3f, 0.3f, 0.3f);
        ResourceLocation texture = data.getMonocleType() == PixelExtrasData.MonocleType.GOLD_MONOCLE ? this.GOLD_MONOCLE_TEXTURE : (data.getMonocleType() == PixelExtrasData.MonocleType.BLACK_MONOCLE ? this.BLACK_MONOCLE_TEXTURE : this.GOLD_MONOCLE_TEXTURE);
        VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(texture));
        this.MONOCLE_MODEL.getModel().render(matrix, vertices, light, overlay);
        matrix.m_85849_();
    }

    public void renderMask(PoseStack matrix, MultiBufferSource buffer, int light, int overlay, Player player, PixelExtrasData data, float partialTicks) {
        matrix.m_85836_();
        this.head.m_104299_(matrix);
        matrix.m_252880_(0.0f, 1.7f, -1.735f);
        if (data.getMonocleType() == PixelExtrasData.MonocleType.QUAGSIRE_MASK) {
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(this.QUAGSIRE_MASK_TEXTURE));
            this.QUAGSIRE_MASK_MODEL.getModel().render(matrix, vertices, light, overlay);
        } else {
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(this.QUARANTINE_MASK_TEXTURE));
            this.QUARANTINE_MASK_MODEL.getModel().render(matrix, vertices, light, overlay);
        }
        matrix.m_85849_();
    }
}

