/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.model.data.ModelData;

public class LayerWings
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public static final ResourceLocation WINGS_MODEL = ResourceLocationHelper.of("pixelmon", "playeritems/wings/articuno_wings");
    public static final ResourceLocation VALENTINES_WINGS_MODEL = ResourceLocationHelper.of("pixelmon", "playeritems/wings/heart_wings");
    private final PlayerRenderer renderer;

    public LayerWings(PlayerRenderer renderer) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        PixelExtrasData extras = PlayerExtraDataStore.get((Player)player);
        if (!extras.isReady() || !extras.isEnabled(PixelExtrasData.Category.WINGS) || extras.getWingType() == PixelExtrasData.WingType.NONE || player.m_20145_()) {
            return;
        }
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        ModelPart body = ((PlayerModel)this.renderer.m_7200_()).f_102810_;
        matrix.m_85836_();
        body.m_104299_(matrix);
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.m_85837_(-0.5, -1.5, -0.5);
        BakedModel model = null;
        if (extras.getWingType() == PixelExtrasData.WingType.CHRISTMAS_ARTICUNO) {
            model = Minecraft.m_91087_().m_91304_().getModel(WINGS_MODEL);
        } else if (extras.getWingType() == PixelExtrasData.WingType.VALENTINES_HEART) {
            model = Minecraft.m_91087_().m_91304_().getModel(VALENTINES_WINGS_MODEL);
        }
        if (model != null) {
            PixelmonRendering.renderQuadList(matrix.m_85850_(), buffer.m_6299_(RenderType.m_110463_()), 1.0f, 1.0f, 1.0f, model.getQuads(null, null, RandomSource.m_216327_(), ModelData.EMPTY, RenderType.m_110463_()), packedLight, packedOverlay);
        }
        matrix.m_85849_();
        Minecraft.m_91087_().m_91307_().m_7238_();
    }
}

