/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class LayerSash
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final ResourceLocation normalSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/otherstuff.png");
    private final ResourceLocation boostSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/boost_sash.png");
    private final ResourceLocation adminSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/admin.png");
    private final ResourceLocation developerSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/developer.png");
    private final ResourceLocation moddelerSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/modeler.png");
    private final ResourceLocation supportSash = ResourceLocationHelper.of("pixelmon:textures/playeritems/support.png");
    private final ModelHolder<GenericSmdModel> SASH_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/sash/sash.pqc");
    private final PlayerRenderer renderer;
    private ResourceLocation locationSashBG;
    private DynamicTexture sashBG;
    private boolean init = false;

    public LayerSash(PlayerRenderer renderer) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        String[] balls;
        ResourceLocation tex;
        PixelExtrasData extras;
        if (!this.init) {
            this.sashBG = new DynamicTexture(1, 1, true);
            this.sashBG.m_117991_().m_84988_(0, 0, -1);
            this.sashBG.m_117985_();
            this.locationSashBG = Minecraft.m_91087_().m_91097_().m_118490_("sashbg2", this.sashBG);
            this.init = true;
        }
        if (!(extras = PlayerExtraDataStore.get((Player)player)).isReady() || !extras.isEnabled(PixelExtrasData.Category.SASH) || extras.getSashType() == PixelExtrasData.SashType.NONE || player.m_20145_()) {
            return;
        }
        float scale = 1.0f;
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        Minecraft.m_91087_().m_91307_().m_6180_("layer_sash");
        ModelPart body = ((PlayerModel)this.renderer.m_7200_()).f_102810_;
        matrix.m_85836_();
        boolean needsColouring = false;
        ResourceLocation texture = this.normalSash;
        switch (extras.getSashType()) {
            case RANK_ADMIN: 
            case RANK_JR: {
                texture = this.adminSash;
                break;
            }
            case RANK_DEV: {
                texture = this.developerSash;
                break;
            }
            case RANK_MODELER: {
                texture = this.moddelerSash;
                break;
            }
            case RANK_SUPPORT: {
                texture = this.supportSash;
                break;
            }
            case BOOSTER: {
                texture = this.boostSash;
                break;
            }
            default: {
                needsColouring = true;
            }
        }
        body.m_104299_(matrix);
        matrix.m_85837_(0.0, 1.5, 0.0);
        if (!((ItemStack)player.m_150109_().f_35975_.get(2)).m_41619_() || extras.isEnabled(PixelExtrasData.Category.ROBE)) {
            matrix.m_85841_(scale, scale, scale + 0.31f);
        } else {
            matrix.m_85841_(scale, scale, scale);
        }
        if (extras.getSashType() == PixelExtrasData.SashType.RAINBOW) {
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(this.locationSashBG));
            int i = player.f_19797_ / 25 + player.m_19879_();
            int j = DyeColor.values().length;
            int k = i % j;
            int l = (i + 1) % j;
            float f7 = ((float)(player.f_19797_ % 25) + partialTicks) / 25.0f;
            float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
            float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
            float r = afloat1[0] * (1.0f - f7) + afloat2[0] * f7;
            float g = afloat1[1] * (1.0f - f7) + afloat2[1] * f7;
            float b = afloat1[2] * (1.0f - f7) + afloat2[2] * f7;
            this.sashBG.m_117991_().m_84988_(0, 0, 0xFF000000 | (int)((double)(r * 255.0f) + 0.5) << 16 | (int)((double)(g * 255.0f) + 0.5) << 8 | (int)((double)(b * 255.0f) + 0.5));
            this.sashBG.m_117985_();
            this.SASH_MODEL.getModel().m_7695_(matrix, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
            needsColouring = false;
        }
        if (needsColouring) {
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(this.locationSashBG));
            float[] color = new float[3];
            if (extras.getColours(PixelExtrasData.Category.SASH)[0] != -1) {
                color[0] = extras.getColours(PixelExtrasData.Category.SASH)[0];
                color[1] = extras.getColours(PixelExtrasData.Category.SASH)[1];
                color[2] = extras.getColours(PixelExtrasData.Category.SASH)[2];
            } else {
                color[0] = 183.0f;
                color[1] = 42.0f;
                color[2] = 53.0f;
            }
            this.sashBG.m_117991_().m_84988_(0, 0, 0xFF000000 | (int)color[0] << 16 | (int)color[1] << 8 | (int)color[2]);
            this.sashBG.m_117985_();
            this.SASH_MODEL.getModel().m_7695_(matrix, vertices, packedLight, packedOverlay, color[0], color[1], color[2], 1.0f);
            tex = this.normalSash;
        } else {
            tex = texture;
        }
        VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(tex));
        this.SASH_MODEL.getModel().render(matrix, vertices, packedLight, packedOverlay);
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.m_85837_(-0.175, 1.44, 0.15);
        for (String ball : balls = EntityPlayerExtension.getPlayerPokeballs((Player)player)) {
            PokeBall pokeball;
            if (ball == null || ball.isEmpty() || (pokeball = PokeBallRegistry.getPokeBall(ball).orElse((Object)null)) == null) continue;
            matrix.m_85837_(0.0275, -0.05, 0.0);
            VertexConsumer ballVertices = buffer.m_6299_(PixelmonRendering.getOBJRenderType(pokeball.getModelTexture()));
            matrix.m_85836_();
            matrix.m_85841_(6.0E-4f, 6.0E-4f, 6.0E-4f);
            ((ModelPokeballs)((Object)pokeball.getModelHolder().getModel())).m_7695_(matrix, ballVertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrix.m_85849_();
        }
        matrix.m_85849_();
        Minecraft.m_91087_().m_91307_().m_7238_();
    }
}

