/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class LayerMegaItems
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/megabraceletoras.png");
    private static final ResourceLocation NECKLACE_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/boost_necklace.png");
    private static final ResourceLocation GLASSES_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_glasses.png");
    private static final ResourceLocation ANCHOR_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_anchor.png");
    private static final ResourceLocation DYNAMAX_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/dynamax_band.png");
    private static final ResourceLocation TIARA_TEXTURE = ResourceLocationHelper.of("pixelmon:textures/playeritems/mega_tiara.png");
    private final ModelHolder<GenericSmdModel> braceletModel = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/megabraceletoras.pqc");
    private final ModelHolder<GenericSmdModel> stoneModel = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/megabraceletorasstone.pqc");
    private final ModelHolder<GenericSmdModel> necklace = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/boost_necklace.pqc");
    private final ModelHolder<GenericSmdModel> glasses = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/mega_glasses.pqc");
    private final ModelHolder<GenericSmdModel> anchor = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/mega_anchor.pqc");
    private final ModelHolder<GenericSmdModel> dynamax = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/dynamax_band.pqc");
    private final ModelHolder<GenericSmdModel> tiara = new GenericModelHolder<GenericSmdModel>("playeritems/megaitems/mega_tiara.pqc");
    private final RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer;

    public LayerMegaItems(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!EntityPlayerExtension.isDefined((Player)player)) {
            return;
        }
        float scale = 1.0f;
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        EnumMegaItem megaItem = EntityPlayerExtension.getPlayerMegaItem((Player)player);
        if (megaItem == EnumMegaItem.Disabled || megaItem == EnumMegaItem.None || player.m_20145_()) {
            return;
        }
        if (megaItem == EnumMegaItem.BoostNecklace) {
            PixelExtrasData extras = PlayerExtraDataStore.get((Player)player);
            if (!extras.isReady()) {
                return;
            }
            if (!extras.hasBoostedNecklace()) {
                megaItem = EnumMegaItem.BraceletORAS;
            }
        }
        ModelPart left = ((PlayerModel)this.renderer.m_7200_()).f_102812_;
        ModelPart body = ((PlayerModel)this.renderer.m_7200_()).f_102810_;
        ModelPart head = ((PlayerModel)this.renderer.m_7200_()).f_102808_;
        Minecraft.m_91087_().m_91307_().m_6180_("layer_mega_wear");
        matrix.m_85836_();
        if (megaItem == EnumMegaItem.BraceletORAS) {
            this.renderBracelet(left, HumanoidArm.LEFT, player.m_6144_(), matrix, buffer, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.DynamaxBand) {
            scale = 1.05f;
            if (!left.f_104212_.isEmpty() && ((ModelPart.Cube)left.f_104212_.get((int)0)).f_104338_ == 2.0f) {
                scale = 1.02f;
            }
            ((PlayerModel)this.renderer.m_7200_()).m_6002_(HumanoidArm.LEFT, matrix);
            matrix.m_252880_(0.0f, 0.4f, 0.0f);
            matrix.m_85841_(scale, scale, scale);
            matrix.m_252781_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
            matrix.m_252880_(-0.3f, 0.0f, 0.875f);
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(DYNAMAX_TEXTURE));
            this.dynamax.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.BoostNecklace) {
            PixelExtrasData extras = PlayerExtraDataStore.get((Player)player);
            float offset = -0.01f;
            float scaleBoost = -0.03f;
            if (extras.getSashType() != PixelExtrasData.SashType.NONE) {
                offset = -0.02f;
                scaleBoost = 0.0f;
            }
            if (extras.getRobeType() != PixelExtrasData.RobeType.NONE) {
                scaleBoost = 0.12f;
                offset = -0.03f;
            }
            body.m_104299_(matrix);
            matrix.m_252880_(0.0f, 0.0f, offset);
            matrix.m_85841_(scale, scale, scale + scaleBoost);
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(NECKLACE_TEXTURE));
            this.necklace.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.MegaAnchor) {
            PixelExtrasData extras = PlayerExtraDataStore.get((Player)player);
            float offset = -0.01f;
            float scaleBoost = -0.03f;
            scale = 1.0f;
            if (extras.getSashType() != PixelExtrasData.SashType.NONE) {
                offset = -0.02f;
                scaleBoost = 0.0f;
            }
            if (extras.getRobeType() != PixelExtrasData.RobeType.NONE) {
                scaleBoost = 0.12f;
                offset = -0.03f;
            }
            body.m_104299_(matrix);
            matrix.m_252880_(0.0f, 0.0f, offset);
            matrix.m_85841_(scale, scale, scale + scaleBoost);
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(ANCHOR_TEXTURE));
            this.anchor.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.MegaGlasses) {
            head.m_104299_(matrix);
            matrix.m_252880_(0.0f, 1.5f, 0.0f);
            matrix.m_252880_(0.0f, -1.72f, -0.15f);
            matrix.m_85841_(0.62f, 0.62f, 0.62f);
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(GLASSES_TEXTURE));
            this.glasses.getModel().render(matrix, vertices, packedLight, packedOverlay);
        } else if (megaItem == EnumMegaItem.MegaTiara) {
            head.m_104299_(matrix);
            matrix.m_252880_(0.0f, 1.5f, 0.0f);
            VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(TIARA_TEXTURE));
            this.tiara.getModel().render(matrix, vertices, packedLight, packedOverlay);
        }
        matrix.m_85849_();
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    void renderBracelet(ModelPart arm, HumanoidArm side, boolean sneak, PoseStack matrix, MultiBufferSource buffer, int light, int overlay) {
        matrix.m_85836_();
        float scale = !arm.f_104212_.isEmpty() && ((ModelPart.Cube)arm.f_104212_.get((int)0)).f_104338_ == 2.0f ? 0.17f : 0.19f;
        ((PlayerModel)this.renderer.m_7200_()).m_6002_(side, matrix);
        matrix.m_252880_(0.0f, 0.4f, 0.0f);
        matrix.m_85841_(scale, scale, scale);
        matrix.m_252880_(0.35f, 0.0f, 0.0f);
        VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(TEXTURE));
        this.braceletModel.getModel().render(matrix, vertices, light, overlay);
        vertices = buffer.m_6299_(PixelmonRendering.getSMDCulledRenderType(TEXTURE));
        this.stoneModel.getModel().m_7695_(matrix, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 0.4f);
        matrix.m_85849_();
    }
}

