/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.BadgeCaseItem;
import com.pixelmonmod.pixelmon.items.BadgeItem;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.RelicCrownItem;
import com.pixelmonmod.pixelmon.items.SpriteItem;
import com.pixelmonmod.pixelmon.items.SymbolItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class LayerEquippables
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final double[][] BC_POSITIONS = new double[][]{{0.08, 0.13}, {0.15, 0.13}, {0.08, 0.2}, {0.15, 0.2}, {0.08, 0.27}, {0.15, 0.27}, {0.08, 0.34}, {0.15, 0.34}};
    private final PlayerRenderer renderer;
    private final Map<String, GenericModelHolder<GenericSmdModel>> equippableModels = new HashMap<String, GenericModelHolder<GenericSmdModel>>();
    private static PixelmonEntity pokemon;

    public LayerEquippables(PlayerRenderer renderer) {
        super((RenderLayerParent)renderer);
        this.renderer = renderer;
        this.equippableModels.put("safety_goggles", new GenericModelHolder("playeritems/equippables/safety_goggles.pqc"));
    }

    public static boolean hasEquippables(AbstractClientPlayer player) {
        for (ItemStack stack : player.m_6168_()) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof IEquippable)) continue;
            return true;
        }
        return false;
    }

    public static PixelmonEntity getPokemon(Level world, Optional<Pokemon> newPoke) {
        if (pokemon != null && newPoke.isPresent() && Objects.equals(newPoke.get().getSpecies(), pokemon.getPokemon().getSpecies()) && Objects.equals(newPoke.get().getForm(), pokemon.getPokemon().getForm()) && Objects.equals(newPoke.get().getPalette(), pokemon.getPokemon().getPalette()) && Objects.equals(newPoke.get().getGender(), pokemon.getPokemon().getGender())) {
            return pokemon;
        }
        if (pokemon == null || newPoke.isPresent()) {
            pokemon = new PixelmonEntity(world, newPoke.get());
            pokemon.setDisableNametag(true);
            pokemon.setAnimation(AnimationType.IDLE);
        }
        return pokemon;
    }

    public static PixelmonEntity getPokemon() {
        return pokemon;
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        ModelPart body = ((PlayerModel)this.renderer.m_7200_()).f_102810_;
        ModelPart head = ((PlayerModel)this.renderer.m_7200_()).f_102808_;
        HashSet equippables = Sets.newHashSet();
        for (ItemStack stack : player.m_6168_()) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof IEquippable)) continue;
            equippables.add((IEquippable)stack.m_41720_());
        }
        if (equippables.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        for (IEquippable equippable : equippables) {
            matrix.m_85836_();
            Item item = equippable.getEquippableItem();
            if (item == PixelmonItems.safety_goggles) {
                GenericModelHolder<GenericSmdModel> model = this.equippableModels.get(equippable.getEquippableModelKey());
                VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(equippable.getEquippableTexture()));
                head.m_104299_(matrix);
                matrix.m_252880_(0.0f, 1.54f, 0.0f);
                matrix.m_252880_(0.0f, -1.82f, -0.15f);
                matrix.m_85841_(0.62f, 0.62f, 0.62f);
                model.render(matrix, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            } else if (item instanceof BadgeItem || item instanceof SymbolItem) {
                body.m_104299_(matrix);
                matrix.m_85837_(0.1, 0.2, -0.11);
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                float s = 0.15f;
                matrix.m_85841_(s, s, 1.0f);
                Minecraft.m_91087_().m_91291_().m_269491_((LivingEntity)player, new ItemStack((ItemLike)equippable.getEquippableItem()), ItemDisplayContext.NONE, true, matrix, buffer, player.m_9236_(), packedLight, packedOverlay, 0);
            } else if (item instanceof BadgeCaseItem) {
                BadgeCaseItem.BadgeCase badgeCase;
                stack = player.m_6844_(EquipmentSlot.CHEST);
                if (stack.m_41782_() && (badgeCase = BadgeCaseItem.BadgeCase.readFromItemStack(stack)) != null) {
                    int i = 0;
                    body.m_104299_(matrix);
                    for (ItemStack badge : badgeCase.badges) {
                        if (i < 8) {
                            matrix.m_85836_();
                            double[] pos = BC_POSITIONS[i];
                            matrix.m_85837_(pos[0], pos[1], -0.11);
                            matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
                            matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 1.0f, 0.0f));
                            float s = 0.075f;
                            matrix.m_85841_(s, s, 1.0f);
                            Minecraft.m_91087_().m_91291_().m_269491_((LivingEntity)player, badge, ItemDisplayContext.NONE, true, matrix, buffer, player.m_9236_(), packedLight, packedOverlay, 0);
                            matrix.m_85849_();
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else if (item instanceof SpriteItem) {
                stack = player.m_6844_(EquipmentSlot.HEAD);
                if (stack.m_41782_() && stack.m_41720_() instanceof SpriteItem && stack.m_41783_().m_128441_("ndex")) {
                    Optional<Pokemon> spriteItem = SpriteItemHelper.getPokemon(stack);
                    if (!spriteItem.isPresent()) {
                        return;
                    }
                    head.m_104299_(matrix);
                    matrix.m_252880_(0.0f, 1.54f, 0.0f);
                    matrix.m_252880_(0.0f, -2.02f, -0.15f);
                    matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                    PixelmonRendering.renderEntity(new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), LayerEquippables.getPokemon(player.m_9236_(), spriteItem), false, partialTicks);
                }
            } else if (item instanceof RelicCrownItem) {
                matrix.m_85836_();
                head.m_104299_(matrix);
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                matrix.m_85837_(-0.5, 0.5, -0.5);
                BlockRenderDispatcher blockrendererdispatcher = Minecraft.m_91087_().m_91289_();
                BlockState state = PixelmonBlocks.relic_crown.m_49966_();
                blockrendererdispatcher.m_110937_().renderModel(matrix.m_85850_(), buffer.m_6299_(RenderType.m_110451_()), state, blockrendererdispatcher.m_110910_(state), 1.0f, 1.0f, 1.0f, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f), ModelData.EMPTY, RenderType.m_110451_());
                matrix.m_85849_();
            }
            matrix.m_85849_();
        }
        mc.m_91307_().m_7238_();
    }
}

