/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.enums.CustomModel;
import com.pixelmonmod.pixelmon.enums.items.EnumCharms;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class LayerCharms
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final ResourceLocation shinyCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/shiny_charm.png");
    private final ResourceLocation ovalCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/oval_charm.png");
    private final ResourceLocation expCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/exp_charm.png");
    private final ResourceLocation catchingCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/catching_charm.png");
    private final ResourceLocation markCharmTexture = ResourceLocationHelper.of("pixelmon:textures/playeritems/mark_charm.png");
    private final Model shinyCharmModel = CustomModel.SHINY_CHARM.getModel();
    private final Model ovalCharmModel = CustomModel.OVAL_CHARM.getModel();
    private final Model expCharmModel = CustomModel.EXP_CHARM.getModel();
    private final Model catchingCharmModel = CustomModel.CATCHING_CHARM.getModel();
    private final Model markCharmModel = CustomModel.MARK_CHARM.getModel();
    private static final float[][] yz = new float[][]{{0.7f, 0.04f}, {0.7f, -0.04f}, {0.8f, 0.08f}, {0.8f, 0.0f}, {0.8f, -0.08f}};
    private static final float[][] syz = new float[][]{{0.8f, 0.38f}, {0.85f, 0.3f}, {0.85f, 0.42f}, {0.9f, 0.34f}, {0.95f, 0.26f}};

    public LayerCharms(PlayerRenderer renderer) {
        super((RenderLayerParent)renderer);
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Minecraft.m_91087_().m_91307_().m_6180_("layer_charm_wear");
        float scale = 1.0f;
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        int i = 0;
        for (EnumCharms charm : EnumCharms.values()) {
            boolean render = false;
            ResourceLocation texture = null;
            Model model = null;
            switch (charm) {
                case Shiny: {
                    if (!EntityPlayerExtension.getPlayerShinyCharm((Player)player).isActive()) break;
                    render = true;
                    texture = this.shinyCharmTexture;
                    model = this.shinyCharmModel;
                    break;
                }
                case Oval: {
                    if (!EntityPlayerExtension.getPlayerOvalCharm((Player)player).isActive()) break;
                    render = true;
                    texture = this.ovalCharmTexture;
                    model = this.ovalCharmModel;
                    break;
                }
                case Exp: {
                    if (!EntityPlayerExtension.getPlayerExpCharm((Player)player).isActive()) break;
                    render = true;
                    texture = this.expCharmTexture;
                    model = this.expCharmModel;
                    break;
                }
                case Catching: {
                    if (!EntityPlayerExtension.getPlayerCatchingCharm((Player)player).isActive()) break;
                    render = true;
                    texture = this.catchingCharmTexture;
                    model = this.catchingCharmModel;
                    break;
                }
                case Mark: {
                    if (!EntityPlayerExtension.getPlayerMarkCharm((Player)player).isActive()) break;
                    render = true;
                    texture = this.markCharmTexture;
                    model = this.markCharmModel;
                }
            }
            if (render) {
                matrix.m_85836_();
                if (player.m_6047_()) {
                    matrix.m_252880_(-0.2525f, syz[i][0], syz[i][1]);
                } else {
                    matrix.m_252880_(-0.2525f, yz[i][0], yz[i][1]);
                }
                scale = 3.5E-4f;
                matrix.m_85841_(scale, scale, scale);
                matrix.m_252781_(QuaternionHelper.fromEuler(90.0f, 0.0f, 1.0f, 0.0f));
                matrix.m_252880_(-0.3f, 0.0f, 0.875f);
                model.m_7695_(matrix, buffer.m_6299_(PixelmonRendering.getSMDCulledRenderType(texture)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                matrix.m_85849_();
            }
            ++i;
        }
        Minecraft.m_91087_().m_91307_().m_7238_();
    }
}

