/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PokeBallRenderer
extends EntityRenderer<PokeBallEntity> {
    private static final String PATH = "pixelmon:textures/pokeballs/";

    public PokeBallRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(PokeBallEntity pokeball, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLightIn) {
        float[] color;
        matrix.m_85836_();
        int id = pokeball.getPairedEntity();
        Entity pair = pokeball.f_19853_.m_6815_(id);
        if (!Float.isNaN(pokeball.clientRotation)) {
            matrix.m_252781_(QuaternionHelper.fromEuler(pokeball.clientRotation, 0.0f, 1.0f, 0.0f));
        } else if (pair != null) {
            pokeball.m_7618_(EntityAnchorArgument.Anchor.EYES, pair.m_20182_());
            pokeball.clientRotation = -pokeball.f_19857_;
            matrix.m_252781_(QuaternionHelper.fromEuler(pokeball.clientRotation, 0.0f, 1.0f, 0.0f));
        } else {
            Quaternionf q1 = QuaternionHelper.fromEuler(-pokeball.getInitialPitch(), -((float)Math.cos((double)pokeball.getInitialYaw() * Math.PI / 180.0)), 0.0f, -((float)Math.sin((double)pokeball.getInitialYaw() * Math.PI / 180.0)));
            Quaternionf q2 = QuaternionHelper.fromEuler(pokeball.f_19857_, 0.0f, 1.0f, 0.0f);
            q1.mul((Quaternionfc)q2);
            matrix.m_252781_(q1);
        }
        GenericModelHolder<ModelPokeballs> model = pokeball.getBallType().getModelHolder(true);
        pokeball.setModel((ModelPokeballs)((Object)model.getModel()));
        ((ModelPokeballs)((Object)model.getModel())).setupForRender(pokeball);
        boolean flash = pokeball.getShakeCount() == (pokeball.getCritical() ? 1 : 4) && pokeball.getIsWaiting() && pokeball.getWaitTimer() < 1;
        int packedOverlay = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.0f), (int)OverlayTexture.m_118096_((boolean)false));
        VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(this.resolveTexture(pokeball, flash)));
        if (!pokeball.getIsWaiting()) {
            pokeball.premierFlash();
        }
        if (pokeball.getMode() == PokeBallMode.EMPTY && pokeball.getAnimation() == AnimationType.BOUNCEOPEN) {
            pokeball.onCaptureAttemptEffect();
        }
        if (pokeball.getShakeCount() == (pokeball.getCritical() ? 1 : 4) && pokeball.getIsWaiting() && pokeball.getWaitTimer() < 1) {
            color = new float[]{0.006f, 0.006f, 0.006f, 1.0f};
            pokeball.successfulCaptureEffect();
            pokeball.setAnimation(AnimationType.IDLE);
        } else {
            color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        }
        if (pokeball.getMode() == PokeBallMode.FULL && pokeball.getAnimation() == AnimationType.BOUNCECLOSED) {
            pokeball.releaseEffect();
        }
        ((ModelPokeballs)((Object)model.getModel())).partialTick = partialTicks;
        matrix.m_85836_();
        matrix.m_85841_(0.0033333334f, 0.0033333334f, 0.0033333334f);
        if (pokeball.f_19797_ >= 2) {
            ((ModelPokeballs)((Object)model.getModel())).render((Entity)pokeball, matrix, vertices, packedLightIn, packedOverlay, color[0], color[1], color[2], color[3]);
        }
        matrix.m_85849_();
        matrix.m_85849_();
        RenderSystem.enableCull();
    }

    public ResourceLocation getTextureLocation(PokeBallEntity pokeball) {
        return pokeball.getBallType().getModelTexture();
    }

    public ResourceLocation resolveTexture(PokeBallEntity pokeball, boolean flash) {
        return flash ? pokeball.getBallType().getFlashingTexture() : this.getTextureLocation(pokeball);
    }
}

