/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.entities.custom.PixelmonBoatEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

public class PixelmonBoatRenderer
extends BoatRenderer {
    private Map<String, ResourceLocation> textureCache = Maps.newHashMap();
    private Map<UUID, PixelmonEntity> entities = Maps.newHashMap();

    public PixelmonBoatRenderer(EntityRendererProvider.Context p_i46190_1_, boolean chestBoat) {
        super(p_i46190_1_, chestBoat);
    }

    public void m_7392_(Boat entity, float p_225623_2_, float p_225623_3_, PoseStack matrix, MultiBufferSource buffer, int partialTick) {
        super.m_7392_(entity, p_225623_2_, p_225623_3_, matrix, buffer, partialTick);
        if (!(entity.m_6688_() instanceof Player) || !Objects.equals(entity.m_6688_().m_20148_(), Minecraft.m_91087_().f_91074_.m_20148_())) {
            this.entities.clear();
            return;
        }
        matrix.m_85836_();
        int counter = 0;
        for (Pokemon pokemon : ClientStorageManager.party.getAll()) {
            if (pokemon == null || !pokemon.getSpecies().is(PixelmonSpecies.MAGIKARP)) continue;
            matrix.m_85836_();
            PixelmonEntity pixelmonEntity = this.getEntity(pokemon, entity);
            pixelmonEntity.getAnimationVariables().tick();
            Vec3 lookAngle = entity.m_20154_();
            matrix.m_85837_(-lookAngle.f_82479_ * ((double)(2 * (counter + 1)) + Math.sin(counter)), -0.5, -lookAngle.f_82481_ * (double)(2 * (counter + 1)) + Math.sin(counter));
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f - p_225623_2_));
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            PixelmonRendering.renderEntity(new GuiGraphics(Minecraft.m_91087_(), matrix, (MultiBufferSource.BufferSource)buffer), pixelmonEntity, false, partialTick);
            matrix.m_85849_();
            ++counter;
        }
        matrix.m_85849_();
    }

    private PixelmonEntity getEntity(Pokemon pokemon, Boat entity) {
        return this.entities.computeIfAbsent(pokemon.getUUID(), ___ -> {
            PixelmonEntity pixelmonEntity = new PixelmonEntity(entity.m_9236_(), pokemon);
            pixelmonEntity.f_19857_ = entity.f_19857_;
            pixelmonEntity.f_20885_ = entity.f_19857_;
            pixelmonEntity.setDisableNametag(true);
            pixelmonEntity.setAnimation(AnimationType.SWIM);
            return pixelmonEntity;
        });
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        Pair modelWithLocation = super.getModelWithLocation(boat);
        return new Pair((Object)this.m_5478_(boat), (Object)((ListModel)modelWithLocation.getSecond()));
    }

    public ResourceLocation m_5478_(Boat p_110775_1_) {
        String name = ((PixelmonBoatEntity)p_110775_1_).getWoodType().f_61839_().toLowerCase(Locale.ROOT);
        return this.textureCache.computeIfAbsent(name, ___ -> ResourceLocationHelper.of("pixelmon", "textures/entity/boat/" + name.replace("pixelmon:", "") + ".png"));
    }
}

