/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.render.layers.npc.LayerMegaItemsNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class NPCRenderer
extends LivingEntityRenderer<NPCEntity, PlayerModel<NPCEntity>> {
    private static final ResourceLocation BUG_CATCHER = ResourceLocationHelper.ofTexture("pixelmon", "textures/steve/bugcatcher3.png");
    private final int defaultNameRenderDistance = 8;
    private final int defaultBossNameRenderDistanceExtension = 8;
    private final int configNameRenderMultiplier = Math.max(1, Math.min(PixelmonConfigProxy.getGraphics().getNamePlateRange(), 3));
    private final int nameRenderDistanceNormal;
    private final int nameRenderDistanceBoss;

    public NPCRenderer(EntityRendererProvider.Context manager) {
        super(manager, (EntityModel)new PlayerModel(manager.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        Objects.requireNonNull(this);
        this.nameRenderDistanceNormal = 8 * this.configNameRenderMultiplier;
        Objects.requireNonNull(this);
        this.nameRenderDistanceBoss = this.nameRenderDistanceNormal + 8;
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(manager.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(manager.m_174023_(ModelLayers.f_171165_)), manager.m_266367_()));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, manager.m_174027_(), manager.m_234598_()));
        this.m_115326_(new LayerMegaItemsNPC(this));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, manager.m_174027_()));
    }

    public void render(NPCEntity npc, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        if (this.f_115290_ == null) {
            return;
        }
        float distance = 20.0f;
        if (Minecraft.m_91087_().f_91075_ != null) {
            distance = npc.m_20270_(Minecraft.m_91087_().f_91075_);
        }
        float renderDistance = this.nameRenderDistanceNormal;
        if (npc.getBossTier() != null) {
            float f = renderDistance = npc.getBossTier().isBoss() ? (float)this.nameRenderDistanceBoss : (float)this.nameRenderDistanceNormal;
        }
        if (distance <= renderDistance) {
            this.drawNameTag(npc, entityYaw, partialTicks, matrix, buffer, packedLight);
        }
        this.setModelVisibilities(npc);
        super.m_7392_((LivingEntity)npc, entityYaw, partialTicks, matrix, buffer, packedLight);
    }

    public Vec3 getRenderOffset(NPCEntity entityIn, float partialTicks) {
        return entityIn.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)entityIn, partialTicks);
    }

    protected boolean shouldShowName(NPCEntity npc) {
        return false;
    }

    public void drawNameTag(NPCEntity npc, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        if (Minecraft.m_91404_()) {
            String displayText = npc.getDisplayText();
            String subtitleText = npc.getSubTitleText();
            if (!displayText.equals("")) {
                this.renderLivingLabel(npc, displayText, subtitleText, entityYaw, partialTicks, matrix, buffer, packedLight);
            }
        }
    }

    protected void renderLivingLabel(NPCEntity npc, String displayText, String subtitleText, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        Font fontRenderer = this.m_114481_();
        float var13 = 1.6f;
        float var14 = 0.016666668f * var13;
        matrix.m_85836_();
        if (npc.getModelScale().y() < 1.0f) {
            matrix.m_252880_(0.0f, 2.1f, 0.0f);
        } else {
            matrix.m_252880_(0.0f, 2.5f, 0.0f);
        }
        matrix.m_252781_(this.f_114476_.m_253208_());
        matrix.m_85841_(-var14, -var14, var14);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        if (npc instanceof NPCTrainer && npc.getBossTier().isBoss()) {
            BossTier bossTier = npc.getBossTier();
            String bossTag = I18n.m_118938_((String)"gui.boss.text", (Object[])new Object[0]);
            String bossMode = I18n.m_118936_((String)bossTier.getName()) ? I18n.m_118938_((String)bossTier.getName(), (Object[])new Object[0]) : bossTier.getName();
            int bossTagWidth = fontRenderer.m_92895_(bossMode);
            int bossTagpos = bossTagWidth / 2 * -1;
            matrix.m_85836_();
            matrix.m_85837_(-2.5 + (double)bossTagpos, -5.5, 0.0);
            matrix.m_85841_(0.5f, 0.5f, 0.5f);
            fontRenderer.m_272077_((Component)Component.m_237113_((String)bossTag), 0.0f, 0.0f, -1, false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            matrix.m_85849_();
            fontRenderer.m_272077_((Component)Component.m_237113_((String)bossMode), (float)bossTagpos, 0.0f, bossTier.getColor().getRGB(), false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        } else {
            if (subtitleText != null) {
                int displayTextWidth = fontRenderer.m_92895_(displayText);
                int displayTextPos = displayTextWidth / 2 * -1;
                matrix.m_85836_();
                matrix.m_85837_(-2.5 + (double)displayTextPos, -5.5, 0.0);
                matrix.m_85841_(0.5f, 0.5f, 0.5f);
                fontRenderer.m_272077_((Component)Component.m_237113_((String)subtitleText), 0.0f, 0.0f, -1, false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
                matrix.m_85849_();
            }
            fontRenderer.m_272077_((Component)Component.m_237113_((String)displayText), (float)(-fontRenderer.m_92895_(displayText)) / 2.0f, 0.0f, -1, false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        matrix.m_85849_();
    }

    public ResourceLocation getTextureLocation(NPCEntity entity) {
        ResourceLocation resourceLocation = ResourceLocationHelper.of(entity.getTexture());
        if (resourceLocation != null) {
            return resourceLocation;
        }
        resourceLocation = ResourceLocationHelper.of(entity.getTexture().replace(";", ""));
        if (resourceLocation != null) {
            return resourceLocation;
        }
        return BUG_CATCHER;
    }

    protected void scale(NPCEntity npc, PoseStack matrix, float partialTickTime) {
        Vector3f scale = npc.getModelScale();
        matrix.m_85841_(scale.x(), scale.y(), scale.z());
        super.m_7546_((LivingEntity)npc, matrix, partialTickTime);
    }

    private void setModelVisibilities(NPCEntity npc) {
        PlayerModel model = (PlayerModel)this.m_7200_();
        if (npc.m_5833_()) {
            model.m_8009_(false);
            model.f_102808_.f_104207_ = true;
            model.f_102809_.f_104207_ = true;
        } else {
            model.m_8009_(true);
            model.f_102809_.f_104207_ = true;
            model.f_103378_.f_104207_ = true;
            model.f_103376_.f_104207_ = true;
            model.f_103377_.f_104207_ = true;
            model.f_103374_.f_104207_ = true;
            model.f_103375_.f_104207_ = true;
            model.f_102817_ = npc.m_6047_();
            HumanoidModel.ArmPose bipedmodel$armpose = NPCRenderer.getArmPose(npc, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose bipedmodel$armpose1 = NPCRenderer.getArmPose(npc, InteractionHand.OFF_HAND);
            if (bipedmodel$armpose.m_102897_()) {
                HumanoidModel.ArmPose armPose = bipedmodel$armpose1 = npc.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (npc.m_5737_() == HumanoidArm.RIGHT) {
                model.f_102816_ = bipedmodel$armpose;
                model.f_102815_ = bipedmodel$armpose1;
            } else {
                model.f_102816_ = bipedmodel$armpose1;
                model.f_102815_ = bipedmodel$armpose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(NPCEntity npc, InteractionHand hand) {
        ItemStack itemstack = npc.m_21120_(hand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (npc.m_7655_() == hand && npc.m_21212_() > 0) {
            UseAnim useaction = itemstack.m_41780_();
            if (useaction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useaction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAnim.CROSSBOW && hand == npc.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!npc.f_20911_ && itemstack.m_41720_() == Items.f_42717_ && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public void renderRightArm(PoseStack matrix, MultiBufferSource buffer, int combinedLight, NPCEntity npc) {
        this.renderItem(matrix, buffer, combinedLight, npc, ((PlayerModel)this.f_115290_).f_102811_, ((PlayerModel)this.f_115290_).f_103375_);
    }

    public void renderLeftArm(PoseStack matrix, MultiBufferSource buffer, int combinedLight, NPCEntity npc) {
        this.renderItem(matrix, buffer, combinedLight, npc, ((PlayerModel)this.f_115290_).f_102812_, ((PlayerModel)this.f_115290_).f_103374_);
    }

    private void renderItem(PoseStack matrix, MultiBufferSource buffer, int combinedLightIn, NPCEntity npc, ModelPart rendererArm, ModelPart rendererArmwear) {
        PlayerModel model = (PlayerModel)this.m_7200_();
        this.setModelVisibilities(npc);
        model.f_102608_ = 0.0f;
        model.f_102817_ = false;
        model.f_102818_ = 0.0f;
        model.m_6973_((LivingEntity)npc, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        rendererArm.f_104203_ = 0.0f;
        rendererArm.m_104301_(matrix, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(npc))), combinedLightIn, OverlayTexture.f_118083_);
        rendererArmwear.f_104203_ = 0.0f;
        rendererArmwear.m_104301_(matrix, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(npc))), combinedLightIn, OverlayTexture.f_118083_);
    }

    protected void setupRotations(NPCEntity entityLiving, PoseStack PoseStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = entityLiving.m_20998_(partialTicks);
        if (entityLiving.m_21255_()) {
            super.m_7523_((LivingEntity)entityLiving, PoseStackIn, ageInTicks, rotationYaw, partialTicks);
            float f1 = (float)entityLiving.m_21256_() + partialTicks;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.m_21209_()) {
                PoseStackIn.m_252781_(Axis.f_252529_.m_252977_(f2 * (-90.0f - entityLiving.f_19858_)));
            }
            Vec3 vector3d = entityLiving.m_20252_(partialTicks);
            Vec3 vector3d1 = entityLiving.m_20184_();
            double d0 = vector3d1.f_82479_ * vector3d1.f_82479_ + vector3d1.f_82481_ * vector3d1.f_82481_;
            double d1 = vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82481_ * vector3d.f_82481_;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.f_82479_ * vector3d.f_82479_ + vector3d1.f_82481_ * vector3d.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.f_82479_ * vector3d.f_82481_ - vector3d1.f_82481_ * vector3d.f_82479_;
                PoseStackIn.m_252781_(Axis.f_252436_.m_252961_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)entityLiving, PoseStackIn, ageInTicks, rotationYaw, partialTicks);
            float f3 = entityLiving.m_20069_() ? -90.0f - entityLiving.f_19858_ : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            PoseStackIn.m_252781_(Axis.f_252529_.m_252977_(f4));
            if (entityLiving.m_6067_()) {
                PoseStackIn.m_85837_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)entityLiving, PoseStackIn, ageInTicks, rotationYaw, partialTicks);
        }
    }
}

