/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;

public class DenRenderer
extends EntityRenderer<DenEntity> {
    private static final GenericModelHolder<GenericSmdModel> model = new GenericModelHolder("blocks/den/raid_den.pqc");
    private static final ResourceLocation texture = ResourceLocationHelper.of("pixelmon", "textures/block/den/raid_den.png");

    public DenRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public ResourceLocation getTextureLocation(DenEntity entity) {
        return texture;
    }

    public void render(DenEntity entity, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f);
        VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(texture));
        matrix.m_85836_();
        float scale = 0.6f;
        matrix.m_85841_(scale, scale, scale);
        matrix.m_252781_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
        if (!entity.isBaseHidden()) {
            model.render(matrix, vertices, packedLight, packedOverlay);
        }
        matrix.m_85849_();
        matrix.m_85836_();
        this.renderMultipass(matrix, buffer, entity, 0.0, 0.0, 0.0, entityYaw, partialTicks, packedLight);
        matrix.m_85849_();
    }

    public void renderMultipass(PoseStack matrix, MultiBufferSource buffer, DenEntity entity, double x, double y, double z, float entityYaw, float partialTicks, int packedLight) {
        Optional<RaidData> optional = entity.getData();
        boolean decoration = entity.isDecoration();
        boolean raid = optional.isPresent();
        boolean animate = entity.isAnimating();
        int beams = entity.getBeams();
        boolean beamOn = entity.isBeamOn();
        boolean beamTaper = entity.isBeamTaper();
        float beamLength = entity.getBeamLength();
        float beamWidth = entity.getBeamWidth();
        if (raid || decoration) {
            ++entity.ticker;
            float f = ((float)entity.ticker + partialTicks) / 8.0f;
            Entity view = Minecraft.m_91087_().m_91288_();
            if (view == null) {
                view = Minecraft.m_91087_().f_91074_;
            }
            float tx = (float)(view.f_19854_ + (view.m_20185_() - view.f_19854_) * (double)partialTicks);
            float tz = (float)(view.f_19856_ + (view.m_20189_() - view.f_19856_) * (double)partialTicks);
            float angle = (float)(Math.atan2(entity.m_20189_() - (double)tz, entity.m_20185_() - (double)tx) * 180.0 / Math.PI) + 90.0f;
            float dist = entity.m_20270_(view) - 20.0f;
            float alpha = Math.min(1.0f, 1.0f - dist / 30.0f);
            matrix.m_85836_();
            matrix.m_85837_(x, y, z);
            if (raid || beamOn) {
                double rXa = beamWidth <= 0.0f ? -0.3 : (double)(-beamWidth);
                double rXb = beamWidth <= 0.0f ? 0.3 : (double)(-beamWidth);
                double rY = beamLength;
                double rZa = beamWidth <= 0.0f ? -0.3 : (double)(-beamWidth);
                double rZb = beamWidth <= 0.0f ? 0.3 : (double)beamWidth;
                double[] rots = new double[]{Math.sin((double)f * 0.13) * 50.0, Math.sin((double)(-f) * 0.07) * 65.0, Math.cos((double)f * 0.1) * 55.0, Math.sin((double)(-f) * 0.14) * 50.0, Math.sin((double)f * 0.11) * 75.0, Math.cos((double)(-f) * 0.04) * 70.0};
                float[] sizes = new float[]{1.0f, 0.75f, 0.55f, 0.4f, 0.2f, 0.1f};
                Color color = entity.getColorRGBA();
                for (int i = 0; i < Math.min(5, raid ? optional.get().getStars() + 1 : beams); ++i) {
                    float size = sizes[i];
                    matrix.m_85836_();
                    matrix.m_252781_(QuaternionHelper.fromEuler(-angle + 45.0f, 0.0f, 1.0f, 0.0f));
                    if (animate) {
                        size = (float)((double)size + Math.abs(rots[i]) * 0.002);
                    } else {
                        matrix.m_252781_(QuaternionHelper.fromEuler(45.0f, 0.0f, 1.0f, 0.0f));
                    }
                    matrix.m_85837_((double)i * -0.01, 0.0, 0.0);
                    Matrix4f mat = matrix.m_85850_().m_252922_();
                    VertexConsumer bufferbuilder = buffer.m_6299_(beamTaper ? PixelmonRendering.getTriangleRenderType(RenderStateShard.ShaderStateShard.f_173104_, PixelmonRendering.GLOW_TRANSPARENCY, RenderType.f_110110_, RenderType.f_110153_, RenderType.f_110154_) : PixelmonRendering.getQuadRenderType(new RenderStateShard.TextureStateShard(PixelmonRendering.EMPTY_TEX, false, false), RenderType.f_173104_, PixelmonRendering.GLOW_TRANSPARENCY, RenderType.f_110110_, RenderType.f_110153_, RenderType.f_110154_));
                    bufferbuilder.m_252986_(mat, (float)(rXa * (double)size), 0.05f, (float)(rZa * (double)size)).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 255).m_5752_();
                    bufferbuilder.m_252986_(mat, (float)(rXb * (double)size), 0.05f, (float)(rZb * (double)size)).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 255).m_5752_();
                    if (beamTaper) {
                        bufferbuilder.m_252986_(mat, (float)((rXb + rXa) / 2.0 * (double)size), (float)(rY * 2.0), (float)((rZb + rZa) / 2.0 * (double)size)).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 0).m_5752_();
                    } else {
                        bufferbuilder.m_252986_(mat, (float)(rXb * (double)size), (float)(rY * 2.0), (float)(rZb * (double)size)).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 255).m_5752_();
                        bufferbuilder.m_252986_(mat, (float)(rXa * (double)size), (float)(rY * 2.0), (float)(rZa * (double)size)).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 255).m_5752_();
                    }
                    matrix.m_85849_();
                }
            }
            if (alpha > 0.0f) {
                entity.getDisplay().ifPresent(display -> {
                    matrix.m_85836_();
                    matrix.m_85837_(0.0, 1.5, 0.0);
                    matrix.m_85841_(1.5f, 1.5f, 1.5f);
                    matrix.m_252781_(QuaternionHelper.fromEuler(f / 2.0f, 0.0f, 1.0f, 0.0f));
                    EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
                    display.setRenderColor(0.0f, 0.0f, 0.0f, alpha);
                    EntityRenderer entityClassRenderObject = renderManager.m_114382_((Entity)display);
                    PixelmonRenderer rp = (PixelmonRenderer)entityClassRenderObject;
                    rp.render(display, 0.0f, partialTicks, matrix, buffer, packedLight);
                    matrix.m_85849_();
                });
            }
            matrix.m_85849_();
        }
    }
}

