/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.species.dimensions.Dimensions;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.ModelAttachment;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelData;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelBase;
import com.pixelmonmod.pixelmon.client.models.items.SpriteItemModel;
import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.DynamaxRenderer;
import com.pixelmonmod.pixelmon.client.render.shader.PixelmonShaders;
import com.pixelmonmod.pixelmon.client.render.shader.ShaderParameters;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LensInfoPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.CustomModel;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public abstract class AbstractPokemonRenderer<E extends AbstractClientEntity>
extends MobRenderer<E, PixelmonModelBase<E>> {
    private static final float[] DYNAMAX_RED = new float[]{1.0f, 0.0f, 0.0f, 0.15f};
    private static final float[] DYNAMAX_BLUE = new float[]{0.0f, 0.1f, 1.0f, 0.35f};
    private final Model DYNAMAX_CLOUDS = CustomModel.DYNAMAX_CLOUDS.getModel();
    private static final int DEFAULT_NAME_RENDER_DISTANCE = 8;
    private static final int DEFAULT_BOSS_NAME_RENDER_DISTANCE_EXTENSION = 8;
    private final int configNameRenderMultiplier = Math.max(1, Math.min(PixelmonConfigProxy.getGraphics().getNamePlateRange(), 3));
    private final int nameRenderDistanceNormal = 8 * this.configNameRenderMultiplier;
    private final int nameRenderDistanceBoss = this.nameRenderDistanceNormal + 8;
    protected String lvlTag;
    protected String bossTag;

    public AbstractPokemonRenderer(EntityRendererProvider.Context manager) {
        super(manager, null, 0.5f);
    }

    protected boolean shouldShowName(E entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(E entity) {
        return Resources.EMPTY_TEXTURE;
    }

    public void scale(E entity, PoseStack matrix, float partialTicks) {
        float scale = this.calculateScale((AbstractClientEntity)((Object)entity), matrix);
        matrix.m_85841_(-0.0625f * scale, -0.0625f * scale, 0.0625f * scale);
    }

    public void render(E entityIn, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        if (entityIn.m_20145_()) {
            return;
        }
        if (this.shouldRenderAsSprite(entityIn)) {
            this.renderSprite(entityIn, matrix, buffer, packedLight);
            return;
        }
        this.f_114478_ = !((AbstractBaseEntity)((Object)entityIn)).isOverlay() && ((AbstractBaseEntity)((Object)entityIn)).getColor() != null ? (float)((AbstractBaseEntity)((Object)entityIn)).getColor().getAlpha() / 255.0f : 1.0f;
        if (((AbstractBaseEntity)((Object)entityIn)).isDisableShadow()) {
            this.f_114477_ = 0.0f;
            this.f_114478_ = 0.0f;
        } else {
            this.f_114477_ = (float)(((AbstractClientEntity)((Object)entityIn)).getPokemon().getForm().getDimensions().getWidth() / 2.0);
        }
        if (((AbstractClientEntity)((Object)entityIn)).isEvolving()) {
            this.f_114478_ = 0.0f;
        }
        matrix.m_85836_();
        this.renderNameTag(entityIn, null, matrix, buffer, packedLight);
        matrix.m_85849_();
        matrix.m_85836_();
        ModelData[] models = ((AbstractBaseEntity)((Object)entityIn)).getPalette().getModel((AbstractClientEntity)((Object)entityIn));
        int packedOverlay = LivingEntityRenderer.m_115338_(entityIn, (float)0.0f);
        float lerpedBodyYRot = this.getBodyYRot(entityIn, partialTicks);
        float currentTick = this.m_6930_((LivingEntity)entityIn, partialTicks);
        this.m_7523_((LivingEntity)entityIn, matrix, currentTick, lerpedBodyYRot, partialTicks);
        this.scale(entityIn, matrix, partialTicks);
        for (ModelData modelData : models) {
            VertexConsumer shaderVerticies;
            matrix.m_85836_();
            VertexConsumer vertices = this.getVertexConsumer(entityIn, modelData.texture().get(), buffer);
            if (this.isFullBright(entityIn)) {
                packedLight = 0xF000F0;
            }
            ValveStudioModel model = modelData.getModel();
            ShaderParameters shaderParameters = ((AbstractClientEntity)((Object)entityIn)).getShaderParameters();
            float[] renderColor = this.calculateDefaultRenderColour(entityIn);
            if (this.shouldRenderNormalMap(modelData)) {
                RenderSystem.setShaderTexture((int)6, (ResourceLocation)modelData.texture().get());
                shaderVerticies = buffer.m_6299_(PixelmonRendering.getSMDRenderTypeWithShader(modelData.normalMap().get(), new RenderStateShard.ShaderStateShard(() -> PixelmonShaders.normalMappingShader), false, false));
                this.renderModel(entityIn, matrix, buffer, shaderVerticies, packedOverlay, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, modelData, model, null, false);
            }
            if (shaderParameters == null || !shaderParameters.onlyShader()) {
                this.renderModel(entityIn, matrix, buffer, vertices, packedOverlay, packedLight, renderColor, modelData, model, null);
            }
            if (shaderParameters != null) {
                shaderParameters.apply();
                shaderParameters.getShaderState().m_173356_("RealTime").m_5985_((float)((AbstractClientEntity)((Object)entityIn)).f_19797_ / 40.0f);
                shaderVerticies = buffer.m_6299_(PixelmonRendering.getSMDRenderTypeWithShader(modelData.texture().get(), new RenderStateShard.ShaderStateShard(shaderParameters::getShaderState), shaderParameters.isWireframe(), shaderParameters.isVertex()));
                float[] shaderColor = shaderParameters.getRenderColor().getRGBComponents(null);
                if (((AbstractClientEntity)((Object)entityIn)).getEvoStage() != null && ((AbstractClientEntity)((Object)entityIn)).getEvoStage() != EvolutionStage.End) {
                    shaderColor[3] = (float)((AbstractClientEntity)((Object)entityIn)).fadeCount / 20.0f;
                }
                this.renderModel(entityIn, matrix, buffer, shaderVerticies, packedOverlay, packedLight, shaderColor, modelData, model, shaderParameters);
            }
            if (this.shouldRenderEmissive(modelData, this.getDistance(entityIn))) {
                vertices = buffer.m_6299_(PixelmonRendering.getSMDEmissiveRenderType(modelData.emissive().get()));
                this.renderModel(entityIn, matrix, buffer, vertices, packedOverlay, 0xF000F0, 1.0f, 1.0f, 1.0f, 1.0f, modelData, model, null, true);
            }
            if (((AbstractClientEntity)((Object)entityIn)).isDynamaxed()) {
                DynamaxRenderer.dynamaxRender(entityIn, matrix, buffer, Resources.DYNAMAX_CLOUDS_TEX, this.DYNAMAX_CLOUDS, partialTicks, packedLight, packedOverlay);
            }
            this.renderEvolutionLightBeams(entityIn, matrix, buffer);
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    private void renderBone(PoseStack matrix, MultiBufferSource buffer, int packedOverlay, int packedLight, Bone bone) {
        matrix.m_85836_();
        Matrix4f newPos = bone.modified.mul((Matrix4fc)bone.getWorldTransform(), new Matrix4f());
        matrix.m_252931_(newPos);
        matrix.m_85836_();
        matrix.m_85841_(0.01f, 0.01f, 0.01f);
        this.m_114481_().m_271703_(bone.name, 0.0f, 0.0f, Color.RED.getRGB(), false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 1, packedLight);
        matrix.m_85849_();
        matrix.m_85841_(0.0625f, 0.0625f, 0.0625f);
        CustomModel.SPHERE_SIMPLE.getModel().m_7695_(matrix, buffer.m_6299_(PixelmonRendering.getSMDRenderType(Resources.EMPTY_TEXTURE)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.m_85849_();
        for (Bone child : bone.children) {
            this.renderBone(matrix, buffer, packedOverlay, packedLight, child);
        }
    }

    private boolean shouldRenderAsSprite(E entity) {
        return ((AbstractClientEntity)((Object)entity)).isSpriteModel() || PixelmonConfigProxy.getGraphics().isGlobalSpriteToggle() || !this.doesModelExist(((AbstractBaseEntity)((Object)entity)).getPalette().getModel((AbstractClientEntity)((Object)entity)));
    }

    private VertexConsumer getVertexConsumer(E entity, ResourceLocation texture, MultiBufferSource buffer) {
        VertexConsumer vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(texture));
        if (!((AbstractBaseEntity)((Object)entity)).isOverlay() && ((AbstractBaseEntity)((Object)entity)).isDisableTexture()) {
            vertices = buffer.m_6299_(PixelmonRendering.getSMDRenderType(Resources.EMPTY_TEXTURE));
        }
        if (PixelmonConfigProxy.getGraphics().isGlobalVertexToggle()) {
            vertices = buffer.m_6299_(PixelmonRendering.getVertexSMDRenderType(texture));
        }
        if (((AbstractClientEntity)((Object)entity)).isWireFrame() || PixelmonConfigProxy.getGraphics().isGlobalWireFrame()) {
            vertices = buffer.m_6299_(PixelmonRendering.getWireFrameSMDRenderType(texture));
        }
        return vertices;
    }

    private boolean isFullBright(E entity) {
        return PixelmonConfigProxy.getGraphics().isGlobalEmissiveToggle() || ((AbstractBaseEntity)((Object)entity)).isFullbright();
    }

    private boolean shouldRenderEmissive(ModelData modelData, double distance) {
        if (!PixelmonConfigProxy.getGraphics().isEmissiveTextures()) {
            return false;
        }
        return !modelData.emissive().isNone() && distance <= (double)PixelmonConfigProxy.getGraphics().getEmissiveTexturesDistance();
    }

    private boolean shouldRenderNormalMap(ModelData modelData) {
        return !modelData.normalMap().isNone();
    }

    private double getDistance(E entity) {
        if (Minecraft.m_91087_().f_91075_ != null) {
            return entity.m_20270_(Minecraft.m_91087_().f_91075_);
        }
        return 20.0;
    }

    private float getBodyYRot(E entity, float partialTicks) {
        Entity entity2;
        boolean shouldSit;
        float lerpedBodyYRot = Mth.m_14189_((float)partialTicks, (float)((AbstractClientEntity)((Object)entity)).f_20884_, (float)((AbstractClientEntity)((Object)entity)).f_20883_);
        float lerpedHeadYRot = Mth.m_14189_((float)partialTicks, (float)((AbstractClientEntity)((Object)entity)).f_20886_, (float)((AbstractClientEntity)((Object)entity)).f_20885_);
        boolean bl = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        if (shouldSit && (entity2 = entity.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            lerpedBodyYRot = Mth.m_14189_((float)partialTicks, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
            float headBodyYRotDifference = Mth.m_14177_((float)(lerpedHeadYRot - lerpedBodyYRot));
            if (headBodyYRotDifference < -85.0f) {
                headBodyYRotDifference = -85.0f;
            }
            if (headBodyYRotDifference >= 85.0f) {
                headBodyYRotDifference = 85.0f;
            }
            lerpedBodyYRot = lerpedHeadYRot - headBodyYRotDifference;
            if (headBodyYRotDifference * headBodyYRotDifference > 2500.0f) {
                lerpedBodyYRot += headBodyYRotDifference * 0.2f;
            }
        }
        return lerpedBodyYRot;
    }

    private void renderModel(E entity, PoseStack matrix, MultiBufferSource buffer, VertexConsumer verticies, int packedOverlay, int packedLight, float[] color, ModelData modelData, ValveStudioModel model, ShaderParameters parameters) {
        matrix.m_85836_();
        if (((AbstractBaseEntity)((Object)entity)).isOverlay()) {
            model.m_7695_(matrix, verticies, packedLight, packedOverlay, color[0], color[1], color[2], color[3]);
            if (((AbstractBaseEntity)((Object)entity)).isDisableTexture()) {
                verticies = buffer.m_6299_(PixelmonRendering.getSMDCulledRenderType(Resources.EMPTY_TEXTURE));
            }
            if (((AbstractBaseEntity)((Object)entity)).isFullbright()) {
                packedLight = 0xF000F0;
            }
        }
        float alpha = color[3];
        if (modelData.textureTransparency() < 1.0f) {
            alpha = modelData.textureTransparency();
        }
        this.renderModel(entity, matrix, buffer, verticies, packedOverlay, packedLight, color[0], color[1], color[2], alpha, modelData, model, parameters, true);
        matrix.m_85849_();
    }

    private float[] calculateDefaultRenderColour(E entity) {
        float[] color = ((AbstractClientEntity)((Object)entity)).getRenderColor();
        if (entity instanceof StatueEntity) {
            StatueEntity statue = (StatueEntity)((Object)entity);
            if (statue.getBossTier().isBoss()) {
                color = statue.getBossTier().getColor().getColorComponents(null);
            } else if (statue.getColor() != Color.WHITE && statue.getColor() != null) {
                color = new float[]{(float)statue.getColor().getRed() / 255.0f, (float)statue.getColor().getGreen() / 255.0f, (float)statue.getColor().getBlue() / 255.0f, 1.0f};
            }
        }
        if (((AbstractBaseEntity)((Object)entity)).getColor() != null) {
            color = ((AbstractBaseEntity)((Object)entity)).getColor().getRGBComponents(null);
        }
        return color;
    }

    private void renderModel(E entity, PoseStack matrix, MultiBufferSource buffer, VertexConsumer verticies, int packedOverlay, int packedLight, float red, float green, float blue, float alpha, ModelData modelData, ValveStudioModel model, ShaderParameters parameters, boolean renderAttachments) {
        matrix.m_85836_();
        model.setupAnimation(((AbstractClientEntity)((Object)entity)).getCurrentAnimation(), ((AbstractClientEntity)((Object)entity)).getAnimationVariables(modelData).getCounter(-1));
        model.m_7695_(matrix, verticies, packedLight, packedOverlay, red, green, blue, alpha);
        if (PixelmonConfigProxy.getGraphics().isShowBones()) {
            this.renderBone(matrix, buffer, packedOverlay, packedLight, model.root);
        }
        if (renderAttachments) {
            for (ModelAttachment attachment : modelData.attachments()) {
                Bone bone = model.body.getBoneByName(attachment.attachmentPoint());
                if (bone == null) {
                    Pixelmon.LOGGER.error("Cannot find bone {}", (Object)attachment.attachmentPoint());
                    continue;
                }
                matrix.m_85836_();
                Matrix4f newPos = bone.modified.mul((Matrix4fc)bone.getWorldTransform(), new Matrix4f());
                matrix.m_252931_(newPos);
                VertexConsumer consumer = this.getVertexConsumer(entity, attachment.model().texture().get(), buffer);
                if (parameters != null) {
                    consumer = buffer.m_6299_(PixelmonRendering.getSMDRenderTypeWithShader(parameters.withTexture() ? attachment.model().texture().get() : PixelmonRendering.EMPTY_TEX, new RenderStateShard.ShaderStateShard(parameters::getShaderState), parameters.isWireframe(), parameters.isVertex()));
                }
                this.renderModel(entity, matrix, buffer, consumer, packedOverlay, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, attachment.model(), attachment.getModel(), parameters, true);
                matrix.m_85849_();
            }
        }
        matrix.m_85849_();
    }

    private void renderEvolutionLightBeams(E pixelmon, PoseStack matrix, MultiBufferSource buffer) {
        if (((AbstractClientEntity)((Object)pixelmon)).getEvoStage() == EvolutionStage.PreAnimation || ((AbstractClientEntity)((Object)pixelmon)).getEvoStage() == EvolutionStage.PostAnimation) {
            Matrix4f pose;
            VertexConsumer builder = buffer.m_6299_(PixelmonRendering.getQuadRenderType(new RenderStateShard.TextureStateShard(Resources.EMPTY_TEXTURE, false, false), RenderStateShard.ShaderStateShard.f_285619_, RenderType.f_110134_, RenderType.f_110110_, RenderType.f_110153_, RenderType.f_110154_));
            float ticks = ((AbstractClientEntity)((Object)pixelmon)).evoAnimTicks;
            if (((AbstractClientEntity)((Object)pixelmon)).getEvoStage() == EvolutionStage.PostAnimation) {
                ticks += (float)EvolutionStage.PreAnimation.ticks;
            }
            Dimensions dimensions = ((AbstractClientEntity)((Object)pixelmon)).getPokemon().getForm().getDimensions();
            float width = (float)dimensions.getWidth();
            float height = (float)dimensions.getHeight();
            float scale = ticks / ((float)EvolutionStage.PreAnimation.ticks + (float)EvolutionStage.PostAnimation.ticks);
            if (scale > 1.0f) {
                scale = 1.0f;
            }
            float hScale = (float)((double)(scale * ((AbstractClientEntity)((Object)pixelmon)).heightDiff) / dimensions.getHeight());
            matrix.m_85836_();
            if (((AbstractClientEntity)((Object)pixelmon)).getEvoStage() == EvolutionStage.PreAnimation) {
                matrix.m_252880_(0.0f, -1.0f * (height * (1.0f + hScale)) / 2.0f, 0.0f);
            } else {
                matrix.m_252880_(0.0f, -1.0f * (height * (1.0f - hScale)) / 2.0f, 0.0f);
            }
            float length = scale * 18.0f + 2.0f;
            if (ticks > 20.0f && ((AbstractClientEntity)((Object)pixelmon)).fadeCount > 18) {
                matrix.m_85836_();
                matrix.m_252781_(QuaternionHelper.fromEuler(ticks * 3.0f, 0.0f, 1.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(15.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.m_85850_().m_252922_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.m_85849_();
            }
            if (ticks > 40.0f && ((AbstractClientEntity)((Object)pixelmon)).fadeCount > 15) {
                matrix.m_85836_();
                matrix.m_252781_(QuaternionHelper.fromEuler(ticks * 3.0f + 180.0f, 0.0f, 1.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(15.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.m_85850_().m_252922_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.m_85849_();
            }
            if (ticks > 60.0f && ((AbstractClientEntity)((Object)pixelmon)).fadeCount > 12) {
                matrix.m_85836_();
                matrix.m_252781_(QuaternionHelper.fromEuler(ticks * 3.0f + 270.0f, 0.0f, 1.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(40.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.m_85850_().m_252922_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.m_85849_();
            }
            if (ticks > 80.0f && ((AbstractClientEntity)((Object)pixelmon)).fadeCount > 9) {
                matrix.m_85836_();
                matrix.m_252781_(QuaternionHelper.fromEuler(ticks * 3.0f + 90.0f, 0.0f, 1.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(40.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.m_85850_().m_252922_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.m_85849_();
            }
            if (ticks > 100.0f && ((AbstractClientEntity)((Object)pixelmon)).fadeCount > 6) {
                matrix.m_85836_();
                matrix.m_252781_(QuaternionHelper.fromEuler(ticks * 3.0f + 135.0f, 0.0f, 1.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(65.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.m_85850_().m_252922_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.m_85849_();
            }
            if (ticks > 120.0f && ((AbstractClientEntity)((Object)pixelmon)).fadeCount > 3) {
                matrix.m_85836_();
                matrix.m_252781_(QuaternionHelper.fromEuler(ticks * 3.0f + 315.0f, 0.0f, 1.0f, 0.0f));
                matrix.m_252781_(QuaternionHelper.fromEuler(65.0f, 1.0f, 0.0f, 1.0f));
                pose = matrix.m_85850_().m_252922_();
                this.drawBeam(pose, width / 10.0f, length, builder);
                matrix.m_85849_();
            }
            matrix.m_85849_();
        }
    }

    private void drawBeam(Matrix4f matrix, float width, float length, VertexConsumer builder) {
        float alpha = 0.6f;
        builder.m_252986_(matrix, -width, 1.0f * length, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix, width, 1.0f * length, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix, width * 3.0f, -length, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix, -width * 3.0f, -length, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix, 0.0f, 1.0f * length, -width).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix, 0.0f, 1.0f * length, width).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix, 0.0f, -length, width * 3.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
        builder.m_252986_(matrix, 0.0f, -length, -width * 3.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_5752_();
    }

    private void renderSprite(E entity, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        StatueEntity statue;
        BakedModel ibakedmodel = SpriteItemModel.getBakedModel(((AbstractClientEntity)((Object)entity)).getPokemon(), Minecraft.m_91087_().m_91291_().m_115103_().m_109394_((Item)PixelmonItems.pixelmon_sprite));
        if (ibakedmodel == null) {
            return;
        }
        this.renderNameTag(entity, (Component)Component.m_237119_(), matrix, buffer, packedLight);
        float[] renderColor = ((AbstractClientEntity)((Object)entity)).getRenderColor();
        if (entity instanceof StatueEntity && (statue = (StatueEntity)((Object)entity)).getColor() != Color.WHITE && statue.getColor() != null) {
            renderColor = new float[]{(float)statue.getColor().getRed() / 255.0f, (float)statue.getColor().getGreen() / 255.0f, (float)statue.getColor().getBlue() / 255.0f, 1.0f};
        }
        if (((AbstractBaseEntity)((Object)entity)).getBossTier().isBoss()) {
            renderColor = ((AbstractBaseEntity)((Object)entity)).getBossTier().getColor().getColorComponents(null);
        }
        matrix.m_85836_();
        matrix.m_252781_(this.f_114476_.f_114358_.m_253121_());
        matrix.m_85841_(6.0f, 6.0f, 6.0f);
        matrix.m_85841_(Math.min((float)((AbstractClientEntity)((Object)entity)).getPokemon().getForm().getDimensions().getHeight(), 1.0f), Math.min((float)((AbstractClientEntity)((Object)entity)).getPokemon().getForm().getDimensions().getHeight(), 1.0f), Math.min((float)((AbstractClientEntity)((Object)entity)).getPokemon().getForm().getDimensions().getHeight(), 1.0f));
        matrix.m_252880_(-entity.m_20205_(), 0.0f, -entity.m_20205_());
        PixelmonRendering.renderQuadList(matrix.m_85850_(), buffer.m_6299_(Sheets.m_110791_()), renderColor[0], renderColor[1], renderColor[2], ibakedmodel.getQuads(null, null, RandomSource.m_216327_(), net.minecraftforge.client.model.data.ModelData.EMPTY, RenderType.m_110466_()), packedLight, LivingEntityRenderer.m_115338_(entity, (float)0.0f));
        matrix.m_85849_();
    }

    protected void renderLabel(E entity, PoseStack matrix, MultiBufferSource buffer, int light, boolean owned) {
        PixelmonEntity pixelmon;
        LensInfoPacket info;
        Component line2;
        Object line1;
        matrix.m_85836_();
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        float scale = ((AbstractBaseEntity)((Object)entity)).getPixelmonScale() * scaleFactor * ((AbstractClientEntity)((Object)entity)).getScaleFactor();
        Dimensions dimensions = ((AbstractClientEntity)((Object)entity)).getPokemon().getForm().getDimensions();
        double height = 0.7 + dimensions.getHeight() * (double)scale;
        matrix.m_85837_(0.0, height, 0.0);
        matrix.m_252781_(this.f_114476_.m_253208_());
        matrix.m_85841_(-0.025f, -0.025f, 0.025f);
        String line3 = null;
        int color1 = -1;
        int color2 = -1;
        int pokemonLevel = ((AbstractClientEntity)((Object)entity)).getPokemon().getPokemonLevel();
        if (owned) {
            if (((AbstractClientEntity)((Object)entity)).getPokemon().isShiny()) {
                color2 = -15000;
            }
            line1 = Minecraft.m_91087_().f_91074_.m_7755_().getString();
            line2 = ((AbstractClientEntity)((Object)entity)).getPokemon().getDisplayNameWithRibbon();
            line3 = I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemonLevel;
        } else if (((AbstractBaseEntity)((Object)entity)).m_21805_() != null) {
            Player player;
            if (((AbstractClientEntity)((Object)entity)).getPokemon().isShiny()) {
                color2 = -15000;
            }
            line1 = (player = entity.m_20193_().m_46003_(((AbstractBaseEntity)((Object)entity)).m_21805_())) == null ? "Unknown" : player.m_7755_().getString();
            line2 = ((AbstractClientEntity)((Object)entity)).getPokemon().getDisplayNameWithRibbon();
            line3 = I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemonLevel;
        } else {
            BossTier bossTier = ((AbstractBaseEntity)((Object)entity)).getBossTier();
            if (bossTier.isNotBoss()) {
                if (PixelmonServerConfig.renderWildLevels) {
                    if (this.lvlTag == null) {
                        this.lvlTag = I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]);
                    }
                    line1 = this.lvlTag;
                    line2 = Component.m_237113_((String)String.valueOf(pokemonLevel));
                } else {
                    line1 = "";
                    line2 = Component.m_237119_();
                }
                if (((AbstractClientEntity)((Object)entity)).getPokemon().isShiny()) {
                    int colour;
                    color1 = color2 = (colour = -15000);
                }
            } else {
                if (this.bossTag == null) {
                    this.bossTag = I18n.m_118938_((String)"gui.boss.text", (Object[])new Object[0]);
                }
                line1 = this.bossTag;
                line2 = Component.m_237115_((String)bossTier.getName());
                int color = bossTier.getColor().getRGB();
                if (PixelmonConfigProxy.getGraphics().isShowWildNames()) {
                    color1 = color;
                } else {
                    color2 = color;
                }
            }
            if (PixelmonConfigProxy.getGraphics().isShowWildNames()) {
                line1 = (String)line1 + " " + line2.getString();
                line2 = ((AbstractClientEntity)((Object)entity)).getPokemon().getDisplayNameWithRibbon();
            }
        }
        Font fontrenderer = this.m_114481_();
        int line2Width = fontrenderer.m_92852_((FormattedText)line2);
        int line2Pos = line2Width / 2 * -1;
        int j = 0;
        if (((AbstractBaseEntity)((Object)entity)).getPalette().usingFallback()) {
            matrix.m_85836_();
            matrix.m_252880_((float)(-line2Width), -14.0f, 0.0f);
            fontrenderer.m_271703_(I18n.m_118938_((String)"pixelmon.fallback.warning", (Object[])new Object[0]), 0.0f, 0.0f, Color.RED.getRGB(), false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, j, light);
            matrix.m_85849_();
        }
        matrix.m_85836_();
        matrix.m_85837_(-2.5 + (double)line2Pos, -4.5, 0.0);
        matrix.m_85841_(0.5f, 0.5f, 0.5f);
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        fontrenderer.m_271703_((String)line1, 0.0f, 0.0f, color1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, j, light);
        matrix.m_85849_();
        matrix.m_85836_();
        matrix.m_252880_(0.0f, 2.5f, 0.0f);
        matrix4f = matrix.m_85850_().m_252922_();
        fontrenderer.m_272077_(line2, (float)(-line2Width) / 2.0f, 0.0f, color2, false, matrix4f, buffer, Font.DisplayMode.NORMAL, j, light);
        matrix.m_85849_();
        if (line3 != null) {
            matrix.m_85836_();
            matrix.m_85837_(2.5 + (double)line2Pos, 13.0, 0.0);
            matrix.m_85841_(0.5f, 0.5f, 0.5f);
            fontrenderer.m_271703_(line3, 0.0f, 0.0f, color1, false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, j, light);
            matrix.m_85849_();
        }
        List<String> flags = ((AbstractClientEntity)((Object)entity)).getPokemon().getFlags();
        int positionCounter = 0;
        for (String flag : flags) {
            matrix.m_85836_();
            double d = (line3 != null ? 5.0 : 2.5) + (double)line2Pos;
            int n = line3 != null ? 20 : 13;
            Objects.requireNonNull(this.m_114481_());
            matrix.m_85837_(d, (double)(n + positionCounter * 9), 0.0);
            matrix.m_85841_(0.5f, 0.5f, 0.5f);
            fontrenderer.m_271703_(I18n.m_118938_((String)("pixelmon.flag." + flag.toLowerCase(Locale.ROOT)), (Object[])new Object[0]), 0.0f, 0.0f, color1, false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, j, light);
            matrix.m_85849_();
            ++positionCounter;
        }
        if (entity instanceof PixelmonEntity && (info = (pixelmon = (PixelmonEntity)((Object)entity)).getClientOnlyInfo()) != null) {
            matrix.m_85836_();
            matrix.m_85837_(30.0, -4.5, 0.0);
            matrix.m_85841_(0.5f, 0.5f, 0.5f);
            Matrix4f mat = matrix.m_85850_().m_252922_();
            fontrenderer.m_272077_((Component)Component.m_237115_((String)"gui.screenpokechecker.ability").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)info.abilityLangKey)), 0.0f, 0.0f, -1, false, mat, buffer, Font.DisplayMode.NORMAL, j, light);
            fontrenderer.m_272077_((Component)Component.m_237115_((String)"gui.screenpokechecker.nature").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)info.nature.getTranslationKey())), 0.0f, 10.0f, -1, false, mat, buffer, Font.DisplayMode.NORMAL, j, light);
            fontrenderer.m_272077_((Component)Component.m_237115_((String)"gui.trainereditor.ivs").m_130946_(": (" + info.ivs.getPercentageString(0) + "%) " + info.ivs.getShorthand("/")), 0.0f, 20.0f, -1, false, mat, buffer, Font.DisplayMode.NORMAL, j, light);
            if (pixelmon.getPokemon().getGender() != Gender.NONE) {
                fontrenderer.m_272077_((Component)Component.m_237115_((String)"gui.trainereditor.gender").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)pixelmon.getPokemon().getGender().getTranslationKey())), 0.0f, 30.0f, -1, false, mat, buffer, Font.DisplayMode.NORMAL, j, light);
            }
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    protected float calculateScale(AbstractClientEntity entity, PoseStack matrix) {
        double lScale;
        double hScale;
        double wScale;
        float scale;
        float scaleFactor = PixelmonConfigProxy.getGraphics().isScaleModelsUp() ? 1.3f : 1.0f;
        scaleFactor *= entity.getScaleFactor() * entity.getPixelmonScale();
        Dimensions dimensions = entity.getForm().getDimensions();
        if (entity.transformed != null) {
            dimensions = entity.transformed.getSpecies().getDefaultForm().getDimensions();
        }
        if (entity.getEvoStage() == EvolutionStage.PreAnimation) {
            scale = (float)entity.evoAnimTicks / ((float)EvolutionStage.PreAnimation.ticks + (float)EvolutionStage.PostAnimation.ticks);
            if (scale > 1.0f) {
                scale = 1.0f;
            }
            wScale = (double)(scale * entity.widthDiff) / dimensions.getWidth();
            hScale = (double)(scale * entity.heightDiff) / dimensions.getHeight();
            lScale = (double)(scale * entity.lengthDiff) / dimensions.getWidth();
            matrix.m_85841_((float)(1.0 + wScale), (float)(1.0 + hScale), (float)(1.0 + lScale));
        }
        if (entity.getEvoStage() == EvolutionStage.PostAnimation) {
            scale = ((float)entity.evoAnimTicks + (float)EvolutionStage.PreAnimation.ticks) / ((float)EvolutionStage.PreAnimation.ticks + (float)EvolutionStage.PostAnimation.ticks);
            if (scale > 1.0f) {
                scale = 1.0f;
            }
            scale = 1.0f - scale;
            wScale = (double)(scale * entity.widthDiff) / dimensions.getWidth();
            hScale = (double)(scale * entity.heightDiff) / dimensions.getHeight();
            lScale = (double)(scale * entity.lengthDiff) / dimensions.getWidth();
            matrix.m_85841_((float)(1.0 - wScale), (float)(1.0 - hScale), (float)(1.0 - lScale));
        }
        return scaleFactor;
    }

    private boolean doesModelExist(ModelData[] model) {
        if (model == null) {
            return false;
        }
        for (ModelData modelData : model) {
            if (modelData.getModel() != null) continue;
            return false;
        }
        return true;
    }

    public void renderNameTag(E entity, Component name, PoseStack matrix, MultiBufferSource buffer, int light) {
        float renderDistance;
        if (((AbstractBaseEntity)((Object)entity)).isDisableNametag() || ((AbstractClientEntity)((Object)entity)).getPokemon() == null || !Minecraft.m_91404_() || entity.m_6144_() || entity.m_6688_() == Minecraft.m_91087_().f_91074_) {
            return;
        }
        boolean owned = ((AbstractClientEntity)((Object)entity)).getPokemon().getOwnerPlayerUUID() == Minecraft.m_91087_().f_91074_.m_20148_();
        float f = renderDistance = ((AbstractBaseEntity)((Object)entity)).getBossTier().isBoss() ? (float)this.nameRenderDistanceBoss : (float)this.nameRenderDistanceNormal;
        if (this.getDistance(entity) <= (double)renderDistance || owned) {
            this.renderLabel(entity, matrix, buffer, light, owned);
        }
    }
}

