/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Transformation;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModelLoader;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL32;

public class PixelmonRendering {
    public static final int FULLBRIGHT = 0xF000F0;
    public static final ResourceLocation EMPTY_TEX = ResourceLocationHelper.of("pixelmon:textures/entity/pixel.png");
    public static final ItemTransforms STANDARD_ITEM_TRANSFORMS = new ItemTransforms(new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0625f), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransform(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(0.070625f, 0.2f, 0.070625f), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0625f), new Vector3f(0.55f, 0.55f, 0.55f)), new ItemTransform(new Vector3f(0.0f, -90.0f, 25.0f), new Vector3f(0.070625f, 0.2f, 0.070625f), new Vector3f(0.68f, 0.68f, 0.68f)), new ItemTransform(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 0.8125f, 0.4375f), new Vector3f(1.0f, 1.0f, 1.0f)), ItemTransform.f_111754_, new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.125f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f)), new ItemTransform(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(), new Vector3f(1.0f, 1.0f, 1.0f)));
    public static final ImmutableMap<ItemDisplayContext, Transformation> STANDARD_ITEM_TRANSFORMATIONS = new ImmutableMap.Builder().put((Object)ItemDisplayContext.GROUND, (Object)new Transformation(new Vector3f(0.0f, 0.125f, 0.0f), QuaternionHelper.fromOld(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null)).put((Object)ItemDisplayContext.HEAD, (Object)new Transformation(new Vector3f(0.0f, 0.8125f, 0.4375f), QuaternionHelper.fromOld(0.0f, 180.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null)).put((Object)ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.1875f, 0.0625f), QuaternionHelper.fromOld(0.0f, 0.0f, 0.0f, true), new Vector3f(0.55f, 0.55f, 0.55f), null)).put((Object)ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.070625f, 0.2f, 0.070625f), QuaternionHelper.fromOld(0.0f, -90.0f, 25.0f, true), new Vector3f(0.68f, 0.68f, 0.68f), null)).put((Object)ItemDisplayContext.THIRD_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.1875f, 0.0625f), QuaternionHelper.fromOld(0.0f, 0.0f, 0.0f, true), new Vector3f(0.55f, 0.55f, 0.55f), null)).put((Object)ItemDisplayContext.FIRST_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.070625f, 0.2f, 0.070625f), QuaternionHelper.fromOld(0.0f, -90.0f, 25.0f, true), new Vector3f(0.68f, 0.68f, 0.68f), null)).put((Object)ItemDisplayContext.FIXED, (Object)new Transformation(null, QuaternionHelper.fromOld(0.0f, 180.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null)).build();
    public static RenderStateShard.TransparencyStateShard GLOW_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("glow_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final RenderType GUI = RenderType.m_173209_((String)"pixelmon_gui", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_285573_).m_110685_(RenderType.f_110139_).m_110663_(RenderType.f_110113_).m_110691_(false));
    private static final RenderType TRIANGLE_FAN = RenderType.m_173209_((String)"triangle_fan", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_FAN, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_285573_).m_110685_(RenderType.f_110139_).m_110663_(RenderType.f_110113_).m_110691_(false));
    private static final RenderType LINE_STRIP = RenderType.m_173209_((String)"pixelmon_line_strip", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.LINE_STRIP, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_285573_).m_110685_(RenderType.f_110139_).m_110663_(RenderType.f_110113_).m_110691_(false));
    public static final RenderType LINES = RenderType.m_173209_((String)"pixelmon_lines", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(RenderType.f_110119_).m_110685_(RenderType.f_110139_).m_110675_(RenderType.f_110129_).m_110687_(RenderType.f_110114_).m_110661_(RenderType.f_110110_).m_110691_(false));
    static final BiFunction<ResourceLocation, RenderStateShard.CullStateShard, RenderType> OUTLINE = Util.m_143821_((p_286176_, p_286177_) -> RenderType.m_173209_((String)"outline", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173101_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_286176_, false, false)).m_110661_(p_286177_).m_110663_(RenderType.f_110113_).m_110675_(RenderType.f_110123_).m_110691_(false)));
    private static final Function<ResourceLocation, RenderType> SMD = Util.m_143827_(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173067_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110154_).m_110691_(true);
        return RenderType.m_173215_((String)"entity_smd", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> SMD_EMISSIVE = Util.m_143827_(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_234323_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110158_).m_110671_(RenderType.f_110153_).m_110677_(RenderType.f_110154_).m_110687_(RenderStateShard.f_110115_).m_110691_(false);
        return RenderType.m_173215_((String)"entity_emissive_smd", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> WIRE_FRAME_SMD = Util.m_143827_(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173067_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110155_).m_110687_(RenderStateShard.f_110115_).m_110683_(new RenderStateShard.TexturingStateShard("wire_frame", () -> RenderSystem.polygonMode((int)1032, (int)6913), () -> RenderSystem.polygonMode((int)1032, (int)6914))).m_110691_(false);
        return RenderType.m_173215_((String)"entity_wireframe_smd", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> VERTEX_SMD = Util.m_143827_(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173067_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110154_).m_110683_(new RenderStateShard.TexturingStateShard("vertex", () -> {
            GL11.glPointSize((float)3.0f);
            RenderSystem.polygonMode((int)1032, (int)6912);
        }, () -> RenderSystem.polygonMode((int)1032, (int)6914))).m_110691_(false);
        return RenderType.m_173215_((String)"entity_vertex_smd", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });

    public static RenderType outline(ResourceLocation resourceLocation) {
        return OUTLINE.apply(resourceLocation, RenderType.f_110110_);
    }

    public static RenderType outline(RenderStateShard.CullStateShard p_239265_1_) {
        return RenderType.m_173209_((String)"outline", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173104_).m_110661_(p_239265_1_).m_110663_(RenderType.f_110111_).m_110675_(RenderType.f_110123_).m_110691_(false));
    }

    public static RenderType getSMDRenderTypeWithShader(ResourceLocation texture, RenderStateShard.ShaderStateShard shader, boolean wireframe, boolean vertex) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(shader).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110154_).m_110683_(new RenderStateShard.TexturingStateShard("wire_frame", () -> {
            GL32.glProvokingVertex((int)36429);
            if (wireframe) {
                RenderSystem.polygonMode((int)1032, (int)6913);
            } else if (vertex) {
                GL11.glPointSize((float)3.0f);
                RenderSystem.polygonMode((int)1032, (int)6912);
            }
        }, () -> {
            if (wireframe || vertex) {
                RenderSystem.polygonMode((int)1032, (int)6914);
            }
        })).m_110691_(false);
        return RenderType.m_173215_((String)"entity_smd_shader", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType gui() {
        return GUI;
    }

    public static RenderType triangleFan() {
        return TRIANGLE_FAN;
    }

    public static RenderType lineStrip() {
        return LINE_STRIP;
    }

    public static RenderType getBellRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.ShaderStateShard.f_173067_).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110153_).m_110677_(RenderType.f_110155_).m_110687_(RenderType.f_110115_).m_110691_(true);
        return RenderType.m_173215_((String)"bell_type", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_FAN, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getDebugLineStripRenderType(RenderStateShard.ShaderStateShard shading, RenderStateShard.TransparencyStateShard transparency, RenderStateShard.CullStateShard culling, RenderStateShard.LightmapStateShard lightmap, RenderStateShard.OverlayStateShard overlay) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(shading).m_110685_(transparency).m_110661_(culling).m_110671_(lightmap).m_110677_(overlay).m_110691_(false);
        return RenderType.m_173215_((String)"color_uv_line_strip", (VertexFormat)DefaultVertexFormat.f_85816_, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINE_STRIP, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getTriangleRenderType(RenderStateShard.ShaderStateShard shading, RenderStateShard.TransparencyStateShard transparency, RenderStateShard.CullStateShard culling, RenderStateShard.LightmapStateShard lightmap, RenderStateShard.OverlayStateShard overlay) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(shading).m_110685_(transparency).m_110661_(culling).m_110671_(lightmap).m_110677_(overlay).m_110691_(true);
        return RenderType.m_173215_((String)"raw_triangles", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getQuadRenderType(RenderStateShard.TextureStateShard textureState, RenderStateShard.ShaderStateShard shading, RenderStateShard.TransparencyStateShard transparency, RenderStateShard.CullStateShard culling, RenderStateShard.LightmapStateShard lightmap, RenderStateShard.OverlayStateShard overlay) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(shading).m_173290_((RenderStateShard.EmptyTextureStateShard)textureState).m_110685_(transparency).m_110661_(culling).m_110671_(lightmap).m_110677_(overlay).m_110691_(true);
        return RenderType.m_173215_((String)"raw_quads", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getSMDCulledRenderType(ResourceLocation texture) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173067_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110158_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110154_).m_110691_(true);
        return RenderType.m_173215_((String)"entity_smd_culled", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)512, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getSMDRenderType(ResourceLocation texture) {
        return SMD.apply(texture);
    }

    public static RenderType getWireFrameSMDRenderType(ResourceLocation texture) {
        return WIRE_FRAME_SMD.apply(texture);
    }

    public static RenderType getSMDEmissiveRenderType(ResourceLocation texture) {
        return SMD_EMISSIVE.apply(texture);
    }

    public static RenderType getVertexSMDRenderType(ResourceLocation texture) {
        return VERTEX_SMD.apply(texture);
    }

    public static RenderType getOBJRenderType(ResourceLocation texture) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173067_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110154_).m_110691_(true);
        return RenderType.m_173215_((String)"entity_obj", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getOBJRenderTypeUndelegated(ResourceLocation texture) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173101_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(RenderType.f_110139_).m_110661_(RenderType.f_110110_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110154_).m_110691_(true);
        return RenderType.m_173215_((String)"obj", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    public static <T extends Entity> void renderEntity(GuiGraphics graphics, T entity, boolean fullbright, float partialTicks) {
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityClassRenderObject = renderManager.m_114382_(entity);
        entityClassRenderObject.m_7392_(entity, 0.0f, partialTicks, graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), fullbright ? 0xF000F0 : renderManager.m_114394_(entity, partialTicks));
        graphics.m_280091_().m_109911_();
    }

    public static <T extends Entity> void renderEntity(PoseStack matrix, MultiBufferSource.BufferSource buffer, T entity, int packedLight, boolean fullbright, float partialTicks) {
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityClassRenderObject = renderManager.m_114382_(entity);
        entityClassRenderObject.m_7392_(entity, 0.0f, partialTicks, matrix, (MultiBufferSource)buffer, fullbright ? 0xF000F0 : packedLight);
        buffer.m_109911_();
    }

    public static Optional<Model> getModel(String path) {
        return PixelmonRendering.getModel(ResourceLocationHelper.of(path));
    }

    public static Optional<Model> getModel(String mod, String path) {
        return PixelmonRendering.getModel(ResourceLocationHelper.of(mod, path));
    }

    public static Optional<Model> getModel(ResourceLocation resource) {
        if (ValveStudioModelLoader.INSTANCE.accepts(resource)) {
            try {
                return Optional.ofNullable(ValveStudioModelLoader.INSTANCE.loadModel(null, resource));
            }
            catch (GabeNewellException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static void renderBlockModel(PoseStack.Pose mat, VertexConsumer builder, @Nullable BlockState state, BakedModel model, float f, float g, float b, int light, int overlay, ModelData modelData, RenderType type) {
        LegacyRandomSource random = new LegacyRandomSource(42L);
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            PixelmonRendering.renderQuadList(mat, builder, f, g, b, model.getQuads(state, direction, (RandomSource)random, modelData, type), light, overlay);
        }
        random.m_188584_(42L);
        PixelmonRendering.renderQuadList(mat, builder, f, g, b, model.getQuads(state, null, (RandomSource)random, modelData, type), light, overlay);
    }

    public static void renderQuadList(PoseStack.Pose mat, VertexConsumer builder, float r, float g, float b, List<BakedQuad> quads, int light, int overlay) {
        for (BakedQuad bakedquad : quads) {
            builder.m_85987_(mat, bakedquad, Mth.m_14036_((float)r, (float)0.0f, (float)1.0f), Mth.m_14036_((float)g, (float)0.0f, (float)1.0f), Mth.m_14036_((float)b, (float)0.0f, (float)1.0f), light, overlay);
        }
    }
}

