/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OverlayToggles {
    private static final Set<VanillaGuiOverlay> BLOCKED_OVERLAYS = Sets.newHashSet();

    public static void disableOverlays(VanillaGuiOverlay ... overlays) {
        Collections.addAll(BLOCKED_OVERLAYS, overlays);
    }

    public static void enableOverlays(VanillaGuiOverlay ... overlays) {
        for (VanillaGuiOverlay overlay : overlays) {
            BLOCKED_OVERLAYS.remove(overlay);
        }
    }

    public static void resetOverlays() {
        BLOCKED_OVERLAYS.clear();
    }

    public static boolean contains(VanillaGuiOverlay overlay) {
        return BLOCKED_OVERLAYS.contains(overlay);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        for (VanillaGuiOverlay overlay : BLOCKED_OVERLAYS) {
            if (!Objects.equals(event.getOverlay(), overlay.type())) continue;
            event.setCanceled(true);
            return;
        }
    }
}

