/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.systems;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystem;
import com.pixelmonmod.pixelmon.client.particle.particles.Blob;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class UltraWormhole
extends ParticleSystem {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(PoseStack matrix, MultiBufferSource.BufferSource bufferSource, Minecraft mc, Level w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        matrix.m_85836_();
        long time = (long)args[1];
        long mod100 = time % 15L;
        double yaw = args[2] * (Math.PI / 180);
        double pitch = args[3] * (Math.PI / 180);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrix.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        RenderSystem.lineWidth((float)1.0f);
        double[] cx = new double[9];
        double[] cy = new double[9];
        double[] cz = new double[9];
        double[] coords = new double[768];
        int coordsIndex = 0;
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        this.defineTheUltraWormholesShape(coordsIndex, coords, x, y, z, cx, cy, cz);
        this.renderTheUltraWormhole(w, bufferSource, matrix4f, x, y, z, cx, cy, cz, yaw, pitch, args);
        this.createInwardMovingGridLines(bufferSource, matrix4f, x, y, z, cx, cy, cz, yaw, pitch, mod100);
        this.createNonMovingSpokeGridLines(bufferSource, matrix4f, coords, x, y, z, yaw, pitch);
        this.createLightningParticles(bufferSource, matrix4f, x, y, z, yaw, pitch, time, mod100);
        this.createBlobParticle(mc, w, x, y, z, yaw, pitch, args);
        GL11.glDisable((int)2848);
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)2.0f);
        matrix.m_85849_();
    }

    private double[] rotatePoint(double px, double py, double pz, double cx, double cy, double cz, double yaw, double pitch) {
        double rx = Math.cos(yaw) * (px - cx) - Math.sin(yaw) * (pz - cz) + cx;
        double rz = Math.sin(yaw) * (px - cx) + Math.cos(yaw) * (pz - cz) + cz;
        double ry = Math.sin(pitch) * (rz - cz) + Math.cos(pitch) * (py - cy) + cy;
        rz = Math.cos(pitch) * (rz - cz) - Math.sin(pitch) * (py - cy) + cz;
        return new double[]{rx, ry, rz};
    }

    @OnlyIn(value=Dist.CLIENT)
    private void rotatePointAndDraw(Matrix4f mat, VertexConsumer builder, double px, double py, double pz, double cx, double cy, double cz, float r, float g, float b, float a, double yaw, double pitch) {
        double[] points = this.rotatePoint(px, py, pz, cx, cy, cz, yaw, pitch);
        builder.m_252986_(mat, (float)points[0], (float)points[1], (float)points[2]).m_85950_(r, g, b, a).m_85969_(0xF000F0).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private float calcChangingColor(int colorSpeed, int colorDeterminant) {
        float c1 = 1.0f / (float)colorSpeed;
        float c2 = c1 * (float)colorDeterminant;
        if (c2 > 0.5f) {
            float c3 = c2 - 0.5f;
            c2 -= c3 * 2.0f;
        }
        return Mth.m_14036_((float)c2, (float)0.0f, (float)0.5f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private float calcRed(int colorPattern, int colorSpeed, int colorDeterminant) {
        switch (colorPattern) {
            case 0: 
            case 1: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 2: 
            case 3: {
                return 0.2f;
            }
            case 4: 
            case 5: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private float calcGreen(int colorPattern, int colorSpeed, int colorDeterminant) {
        switch (colorPattern) {
            case 2: 
            case 4: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 0: 
            case 5: {
                return 0.2f;
            }
            case 1: 
            case 3: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private float calcBlue(int colorPattern, int colorSpeed, int colorDeterminant) {
        switch (colorPattern) {
            case 3: 
            case 5: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 1: 
            case 4: {
                return 0.2f;
            }
            case 0: 
            case 2: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void defineTheUltraWormholesShape(int coordsIndex, double[] coords, double x, double y, double z, double[] cx, double[] cy, double[] cz) {
        for (int spokes = 0; spokes < 16; ++spokes) {
            double zFront = 0.0;
            double zBack = 0.1;
            float radiusDecay = 0.35f;
            double radius = 3.25;
            double dx = Math.cos(0.39269908169872414 * (double)spokes);
            double dy = Math.sin(0.39269908169872414 * (double)spokes);
            for (int segments = 0; segments < 8; ++segments) {
                double radius2 = radius - (double)radiusDecay;
                coords[coordsIndex++] = x + dx * radius;
                coords[coordsIndex++] = y + dy * radius;
                coords[coordsIndex++] = z + zFront;
                coords[coordsIndex++] = x + dx * radius2;
                coords[coordsIndex++] = y + dy * radius2;
                coords[coordsIndex++] = z + zBack;
                if (segments == 0) {
                    cx[segments] = radius;
                    cy[segments] = radius;
                    cz[segments] = zFront;
                }
                if (spokes == 1) {
                    cx[segments + 1] = radius2;
                    cy[segments + 1] = radius2;
                    cz[segments + 1] = zBack;
                }
                zFront = zBack;
                zBack += 0.2 * (double)(segments + 1);
                radius -= (double)radiusDecay;
                radiusDecay -= 0.02f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void createNonMovingSpokeGridLines(MultiBufferSource.BufferSource bufferSource, Matrix4f mat, double[] coords, double x, double y, double z, double yaw, double pitch) {
        int coordsIndex = 0;
        for (int spokes = 0; spokes < 16; ++spokes) {
            GL11.glHint((int)3154, (int)4354);
            VertexConsumer lineStripBuilder = bufferSource.m_6299_(PixelmonRendering.getDebugLineStripRenderType(RenderStateShard.ShaderStateShard.f_173095_, RenderType.f_110139_, RenderType.f_110110_, RenderType.f_110153_, RenderType.f_110154_));
            for (int segments = 0; segments < 8; ++segments) {
                for (int i = 0; i < 2; ++i) {
                    this.rotatePointAndDraw(mat, lineStripBuilder, coords[coordsIndex++], coords[coordsIndex++], coords[coordsIndex++], x, y, z, 1.0f, 1.0f, 1.0f, (float)segments / 9.0f, yaw, pitch);
                }
            }
            bufferSource.m_109911_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void createInwardMovingGridLines(MultiBufferSource.BufferSource bufferSource, Matrix4f mat, double x, double y, double z, double[] cx, double[] cy, double[] cz, double yaw, double pitch, long mod100) {
        for (int i = 0; i < 9; ++i) {
            if (i <= 1) continue;
            GL11.glHint((int)3154, (int)4354);
            VertexConsumer lineStripBuilder = bufferSource.m_6299_(PixelmonRendering.getDebugLineStripRenderType(RenderStateShard.ShaderStateShard.f_173095_, RenderType.f_110139_, RenderType.f_110110_, RenderType.f_110153_, RenderType.f_110154_));
            double ox = cx[i];
            double oy = cx[i];
            double oz = cz[i];
            if (i != 8) {
                ox = cx[i] + (cx[i + 1] - cx[i]) * ((double)mod100 / 15.0);
                oy = cy[i] + (cy[i + 1] - cy[i]) * ((double)mod100 / 15.0);
                oz = cz[i] + (cz[i + 1] - cz[i]) * ((double)mod100 / 15.0);
            }
            float a = (float)i / 9.0f * (i == 2 ? (float)mod100 / 15.0f * 2.0f : 1.0f);
            for (int spokes = 0; spokes < 17; ++spokes) {
                double theta = 0.39269908169872414 * (double)(spokes == 16 ? 0 : spokes);
                double dx = Math.cos(theta);
                double dy = Math.sin(theta);
                this.rotatePointAndDraw(mat, lineStripBuilder, x + ox * dx, y + oy * dy, z + oz, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
            }
            bufferSource.m_109911_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderTheUltraWormhole(Level w, MultiBufferSource.BufferSource bufferSource, Matrix4f mat, double x, double y, double z, double[] cx, double[] cy, double[] cz, double yaw, double pitch, double ... args) {
        int colorPattern = (int)args[0];
        int colorSpeed = 120;
        int determinant = ((int)args[1] + (int)w.m_46467_() % (colorSpeed * 2)) % colorSpeed;
        for (int i = 0; i < 9; ++i) {
            RenderSystem.disableCull();
            if (i != 8) {
                for (int spokes = 0; spokes < 16; ++spokes) {
                    int colorDeterminant = determinant + i * 4;
                    float r = this.calcRed(colorPattern, colorSpeed, colorDeterminant);
                    float g = this.calcGreen(colorPattern, colorSpeed, colorDeterminant);
                    float b = this.calcBlue(colorPattern, colorSpeed, colorDeterminant);
                    float a = 1.0f - 0.11f * (float)(i + 1);
                    GL11.glHint((int)3155, (int)4354);
                    VertexConsumer quadBuilder = bufferSource.m_6299_(PixelmonRendering.getQuadRenderType(new RenderStateShard.TextureStateShard(PixelmonRendering.EMPTY_TEX, false, false), RenderStateShard.ShaderStateShard.f_285619_, RenderType.f_110139_, RenderType.f_110110_, RenderType.f_110153_, RenderType.f_110154_));
                    double theta1 = 0.39269908169872414 * (double)spokes;
                    double dx1 = Math.cos(theta1);
                    double dy1 = Math.sin(theta1);
                    double theta2 = 0.39269908169872414 * (double)(spokes + 1 == 16 ? 0 : spokes + 1);
                    double dx2 = Math.cos(theta2);
                    double dy2 = Math.sin(theta2);
                    this.rotatePointAndDraw(mat, quadBuilder, x + cx[7 - i] * dx1, y + cy[7 - i] * dy1, z + cz[7 - i], x, y, z, r, g, b, a, yaw, pitch);
                    this.rotatePointAndDraw(mat, quadBuilder, x + cx[7 - i] * dx2, y + cy[7 - i] * dy2, z + cz[7 - i], x, y, z, r, g, b, a, yaw, pitch);
                    this.rotatePointAndDraw(mat, quadBuilder, x + cx[7 - i + 1] * dx2, y + cy[7 - i + 1] * dy2, z + cz[7 - i + 1], x, y, z, r, g, b, a, yaw, pitch);
                    this.rotatePointAndDraw(mat, quadBuilder, x + cx[7 - i + 1] * dx1, y + cy[7 - i + 1] * dy1, z + cz[7 - i + 1], x, y, z, r, g, b, a, yaw, pitch);
                    bufferSource.m_109911_();
                }
            }
            RenderSystem.enableCull();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void createLightningParticles(MultiBufferSource.BufferSource bufferSource, Matrix4f mat, double x, double y, double z, double yaw, double pitch, long time, long mod100) {
        RenderSystem.lineWidth((float)1.0f);
        long seed = time - mod100 + (long)x + (long)y + (long)z;
        Random rand = new Random(seed);
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (mod100 >= 7L) continue;
            int forks = rand.nextInt(5) + 5;
            double dx = x;
            double dy = y;
            double dz = z + 5.5;
            float a = 1.0f - 0.14285715f * (float)mod100;
            for (int i = 0; i < forks; ++i) {
                GL11.glHint((int)3154, (int)4354);
                VertexConsumer lineStripBuilder1 = bufferSource.m_6299_(PixelmonRendering.getDebugLineStripRenderType(RenderStateShard.ShaderStateShard.f_173095_, RenderType.f_110134_, RenderType.f_110110_, RenderType.f_110153_, RenderType.f_110154_));
                this.rotatePointAndDraw(mat, lineStripBuilder1, x, dy, dz, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
                this.rotatePointAndDraw(mat, lineStripBuilder1, dx += (rand.nextDouble() * 2.0 - 1.0) / 2.0, dy += rand.nextDouble() * 2.0 - 1.0, dz -= rand.nextDouble() * 2.0, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
                bufferSource.m_109911_();
                if (i <= 4) continue;
                GL11.glHint((int)3154, (int)4354);
                VertexConsumer lineStripBuilder2 = bufferSource.m_6299_(PixelmonRendering.getDebugLineStripRenderType(RenderStateShard.ShaderStateShard.f_173095_, RenderType.f_110134_, RenderType.f_110110_, RenderType.f_110153_, RenderType.f_110154_));
                this.rotatePointAndDraw(mat, lineStripBuilder2, dx, dy, dz, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
                this.rotatePointAndDraw(mat, lineStripBuilder2, dx + (rand.nextDouble() * 2.0 - 1.0) / 2.0, dy + rand.nextDouble() * 2.0 - 1.0, dz + rand.nextDouble() * 2.0, x, y, z, 1.0f, 1.0f, 1.0f, a, yaw, pitch);
                bufferSource.m_109911_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void createBlobParticle(Minecraft mc, Level w, double x, double y, double z, double yaw, double pitch, double ... args) {
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        double rad = 0.85;
        double posX = RandomHelper.getRandom().nextDouble() * (rad * 2.0) - rad;
        double posY = RandomHelper.getRandom().nextDouble() * (rad * 2.0) - rad;
        double posZ = RandomHelper.getRandom().nextDouble() * (rad * 2.0) - rad;
        if (Math.sqrt(posX * posX + posY * posY + posZ * posZ) <= rad) {
            double[] center = this.rotatePoint(x, y, z + 5.0, x, y, z, yaw, pitch);
            mc.f_91061_.m_107344_((Particle)new ParticleArcanery(center[0] + posX, center[1] + posY, center[2] + posZ, 0.0, 0.0, 0.0, new Blob(0.0, 0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f, true, 10, (int)args[0], 1.7f)));
        }
    }
}

