/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles.shiny;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.client.render.shader.PixelmonCodecs;
import com.pixelmonmod.pixelmon.init.registry.ParticleRegistration;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class ShinyParticleData
implements ParticleOptions {
    public static final Codec<ShinyParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PixelmonCodecs.COLOR_CODEC.fieldOf("tint").forGetter(d -> d.tint), (App)Codec.DOUBLE.fieldOf("diameter").forGetter(d -> d.diameter), (App)Codec.INT.fieldOf("lifetime").forGetter(d -> d.lifetime)).apply((Applicative)instance, ShinyParticleData::new));
    private Color tint;
    private double diameter;
    private int lifetime;
    public static final ParticleOptions.Deserializer<ShinyParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ShinyParticleData>(){

        @Nonnull
        public ShinyParticleData fromCommand(@Nonnull ParticleType<ShinyParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double diameter = reader.readDouble();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            int red = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int alpha = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue, alpha);
            return new ShinyParticleData(color, diameter, lifetime);
        }

        public ShinyParticleData fromNetwork(@Nonnull ParticleType<ShinyParticleData> type, FriendlyByteBuf buf) {
            int red = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int green = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int blue = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int alpha = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue, alpha);
            double diameter = buf.readDouble();
            int lifetime = buf.readInt();
            return new ShinyParticleData(color, diameter, lifetime);
        }
    };

    public ShinyParticleData(Color tint, double diameter, int lifetime) {
        this.tint = tint;
        this.diameter = diameter;
        this.lifetime = lifetime;
    }

    public ShinyParticleData(int tintRGB, double diameter, int lifetime) {
        this.tint = new Color(tintRGB);
        this.diameter = diameter;
        this.lifetime = lifetime;
    }

    public Color getTint() {
        return this.tint;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    @Nonnull
    public ParticleType<ShinyParticleData> m_6012_() {
        return (ParticleType)ParticleRegistration.SHINY.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeInt(this.tint.getAlpha());
        buf.writeDouble(this.diameter);
        buf.writeInt(this.lifetime);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s", this.m_6012_());
    }
}

