/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles.cyclone;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.init.registry.ParticleRegistration;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class CycloneParticleData
implements ParticleOptions {
    public static final Codec<CycloneParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tint").forGetter(d -> d.tint.getRGB()), (App)Codec.DOUBLE.fieldOf("diameter").forGetter(d -> d.diameter), (App)Codec.INT.fieldOf("lifetime").forGetter(d -> d.lifetime)).apply((Applicative)instance, CycloneParticleData::new));
    private Color tint;
    private double diameter;
    private int lifetime;
    public static final ParticleOptions.Deserializer<CycloneParticleData> DESERIALIZER = new ParticleOptions.Deserializer<CycloneParticleData>(){

        @Nonnull
        public CycloneParticleData fromCommand(@Nonnull ParticleType<CycloneParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double diameter = reader.readDouble();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            int red = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int alpha = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue, alpha);
            return new CycloneParticleData(color, diameter, lifetime);
        }

        public CycloneParticleData fromNetwork(@Nonnull ParticleType<CycloneParticleData> type, FriendlyByteBuf buf) {
            int red = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int green = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int blue = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int alpha = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue, alpha);
            double diameter = buf.readDouble();
            int lifetime = buf.readInt();
            return new CycloneParticleData(color, diameter, lifetime);
        }
    };

    public CycloneParticleData(Color tint, double diameter, int lifetime) {
        this.tint = tint;
        this.diameter = diameter;
        this.lifetime = lifetime;
    }

    public CycloneParticleData(int tintRGB, double diameter, int lifetime) {
        this.tint = new Color(tintRGB);
        this.diameter = diameter;
        this.lifetime = lifetime;
    }

    public Color getTint() {
        return this.tint;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    @Nonnull
    public ParticleType<CycloneParticleData> m_6012_() {
        return (ParticleType)ParticleRegistration.CYCLONE.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeInt(this.tint.getAlpha());
        buf.writeDouble(this.diameter);
        buf.writeInt(this.lifetime);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s", this.m_6012_());
    }
}

