/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles.beams;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.init.registry.ParticleRegistration;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class EvolutionBeamParticleData
implements ParticleOptions {
    public static final Codec<EvolutionBeamParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tint").forGetter(d -> d.tint.getRGB()), (App)Codec.DOUBLE.fieldOf("diameter").forGetter(d -> d.diameter), (App)Codec.INT.fieldOf("beams").forGetter(d -> d.beams), (App)Codec.INT.fieldOf("lifetime").forGetter(d -> d.lifetime)).apply((Applicative)instance, EvolutionBeamParticleData::new));
    private Color tint;
    private double diameter;
    private int beams;
    private int lifetime;
    public static final ParticleOptions.Deserializer<EvolutionBeamParticleData> DESERIALIZER = new ParticleOptions.Deserializer<EvolutionBeamParticleData>(){

        @Nonnull
        public EvolutionBeamParticleData fromCommand(@Nonnull ParticleType<EvolutionBeamParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double diameter = reader.readDouble();
            reader.expect(' ');
            int beams = reader.readInt();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            int red = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int alpha = Mth.m_14045_((int)reader.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue, alpha);
            return new EvolutionBeamParticleData(color, diameter, beams, lifetime);
        }

        public EvolutionBeamParticleData fromNetwork(@Nonnull ParticleType<EvolutionBeamParticleData> type, FriendlyByteBuf buf) {
            int red = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int green = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int blue = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            int alpha = Mth.m_14045_((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue, alpha);
            double diameter = buf.readDouble();
            int beams = buf.readInt();
            int lifetime = buf.readInt();
            return new EvolutionBeamParticleData(color, diameter, beams, lifetime);
        }
    };

    public EvolutionBeamParticleData(Color tint, double diameter, int beams, int lifetime) {
        this.tint = tint;
        this.diameter = diameter;
        this.beams = beams;
        this.lifetime = lifetime;
    }

    public EvolutionBeamParticleData(int tintRGB, double diameter, int beams, int lifetime) {
        this.tint = new Color(tintRGB);
        this.diameter = diameter;
        this.beams = beams;
        this.lifetime = lifetime;
    }

    public Color getTint() {
        return this.tint;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public int getBeams() {
        return this.beams;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    @Nonnull
    public ParticleType<EvolutionBeamParticleData> m_6012_() {
        return (ParticleType)ParticleRegistration.EVOLUTION_BEAM.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeInt(this.tint.getAlpha());
        buf.writeDouble(this.diameter);
        buf.writeInt(this.beams);
        buf.writeInt(this.lifetime);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %i %i %i", this.m_6012_().toString(), this.diameter, this.tint.getRed(), this.tint.getGreen(), this.tint.getBlue());
    }
}

