/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles.beams;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EvolutionBeamParticle
extends RisingParticle {
    public static final ParticleRenderType EVO_BEAM = new ParticleRenderType(){
        private final ResourceLocation EMPTY_TEX = ResourceLocationHelper.of("pixelmon:textures/entity/pixel.png");

        public void m_6505_(BufferBuilder buffer, TextureManager p_217600_2_) {
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85816_);
            Minecraft.m_91087_().f_91063_.m_109155_().m_118087_();
            RenderSystem.disableCull();
            RenderSystem.disableBlend();
            TextureManager textureManager = Minecraft.m_91087_().m_91097_();
            textureManager.m_174784_(this.EMPTY_TEX);
            textureManager.m_118506_(this.EMPTY_TEX).m_117960_(false, false);
        }

        public void m_6294_(Tesselator p_217599_1_) {
            p_217599_1_.m_85914_();
            Minecraft.m_91087_().f_91063_.m_109155_().m_118098_();
            RenderSystem.enableCull();
        }

        public String toString() {
            return "EVO_BEAM";
        }
    };
    private static final int BLOCK_LIGHT = 15;
    private static final int SKY_LIGHT = 15;
    private static final int FULL_BRIGHTNESS_VALUE = LightTexture.m_109885_((int)15, (int)15);
    private int ticks = 0;
    private int beams;

    public EvolutionBeamParticle(ClientLevel world, double x, double y, double z, int beams, int lifetime, double velocityX, double velocityY, double velocityZ, Color tint, double diameter, SpriteSet sprites) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.m_107253_(tint.getRGBComponents(null)[0], tint.getRGBComponents(null)[1], tint.getRGBComponents(null)[2]);
        this.m_107250_((float)diameter, (float)diameter);
        this.f_107225_ = lifetime;
        this.beams = beams;
        this.f_107230_ = tint.getRGBComponents(null)[3];
        this.f_107219_ = false;
    }

    public boolean shouldCull() {
        return false;
    }

    public int m_6355_(float partialTick) {
        int BLOCK_LIGHT = 15;
        int SKY_LIGHT = 15;
        int FULL_BRIGHTNESS_VALUE = LightTexture.m_109885_((int)15, (int)15);
        return FULL_BRIGHTNESS_VALUE;
    }

    public ParticleRenderType m_7556_() {
        return EVO_BEAM;
    }

    public void m_5744_(VertexConsumer builder, Camera renderInfo, float partialTicks) {
        this.drawBeam(0.1f, this.f_107221_, builder, renderInfo, partialTicks);
    }

    private void drawBeam(float width, float length, VertexConsumer builder, Camera renderInfo, float partialTicks) {
        Vec3 lvt_4_1_ = renderInfo.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - lvt_4_1_.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - lvt_4_1_.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - lvt_4_1_.m_7094_());
        Vector3f[] points = new Vector3f[]{new Vector3f(-width, length, 0.0f), new Vector3f(width, length, 0.0f), new Vector3f(width * 3.0f, -length, 0.0f), new Vector3f(-width * 3.0f, -length, 0.0f), new Vector3f(0.0f, length, -width), new Vector3f(0.0f, length, width), new Vector3f(0.0f, -length, width * 3.0f), new Vector3f(0.0f, -length, -width * 3.0f)};
        float delta = 360.0f / (float)this.beams;
        for (int i = 0; i < this.beams; ++i) {
            this.renderBeam(builder, renderInfo, points, (float)i * delta, x, y, z, partialTicks);
        }
    }

    private void renderBeam(VertexConsumer builder, Camera renderInfo, Vector3f[] points, float offset, float x, float y, float z, float partialTicks) {
        for (int i = 0; i < points.length; ++i) {
            Vector3f point = new Vector3f((Vector3fc)points[i]);
            point.rotate((Quaternionfc)renderInfo.m_253121_());
            point.rotate((Quaternionfc)QuaternionHelper.fromEuler(offset + (float)this.ticks * 3.0f, 0.0f, 1.0f, 0.0f));
            point.add(x, y, z);
            builder.m_5483_((double)point.x(), (double)point.y(), (double)point.z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(partialTicks)).m_5752_();
        }
    }

    public void m_5989_() {
        super.m_5989_();
        ++this.ticks;
    }
}

