/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class SlingRing
extends ParticleEffect {
    private final boolean parent;
    private final int maxAge;
    private static final ResourceLocation tex = ResourceLocationHelper.of("pixelmon", "textures/particle/sling_ring.png");

    public SlingRing(boolean parent, int maxAge) {
        this.parent = parent;
        this.maxAge = maxAge;
    }

    @Override
    public void init(ParticleArcanery particle, Level world, double x, double y, double z, double vx, double vy, double vz, float size) {
        particle.setRGBA(1.0f, 1.0f, 1.0f, this.parent ? 0.0f : 0.5f);
        particle.setSize(0.75f);
        particle.m_107257_(this.maxAge);
    }

    @Override
    public void update(ParticleArcanery particle) {
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        particle.incrementAge();
        if (particle.getAge() >= particle.m_107273_()) {
            particle.m_107274_();
        }
        if (this.parent) {
            ParticleArcanery child = new ParticleArcanery(particle.getX(), particle.getY(), particle.getZ(), 0.0, 0.0, 0.0, new SlingRing(false, 5));
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)child);
        } else {
            particle.setMotion(0.2 * (RandomHelper.getRandom().nextDouble() * 2.0 - 1.0), 0.2 * (RandomHelper.getRandom().nextDouble() * 2.0 - 1.0), 0.2 * (RandomHelper.getRandom().nextDouble() * 2.0 - 1.0));
            particle.m_6257_(particle.getMotionX(), particle.getMotionY(), particle.getMotionZ());
            particle.setRGBA(1.0f, 1.0f, 1.0f, 1.0f - (float)particle.getAge() / (float)particle.m_107273_());
            particle.setSize(0.75f - (float)particle.getAge() / (float)particle.m_107273_() * 0.75f);
        }
    }

    @Override
    public ResourceLocation texture() {
        return tex;
    }
}

