/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ShadowBlob
extends ParticleEffect {
    private double random;
    private static final ResourceLocation tex1 = ResourceLocationHelper.of("pixelmon", "textures/particle/shadow1.png");
    private static final ResourceLocation tex2 = ResourceLocationHelper.of("pixelmon", "textures/particle/shadow2.png");
    private static final ResourceLocation tex3 = ResourceLocationHelper.of("pixelmon", "textures/particle/shadow3.png");

    public ShadowBlob(double random) {
        this.random = random;
    }

    @Override
    public void preRender(ParticleArcanery particle, float partialTicks) {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    public void init(ParticleArcanery particle, Level world, double x, double y, double z, double vx, double vy, double vz, float size) {
        particle.setRGBA(1.0f - RandomHelper.getRandom().nextFloat() / 10.0f, 1.0f - RandomHelper.getRandom().nextFloat() / 10.0f, 1.0f - RandomHelper.getRandom().nextFloat() / 10.0f, 1.0f - RandomHelper.getRandom().nextFloat() / 10.0f);
        particle.setMotion(particle.getMotionX() * (double)0.1f + this.random * (RandomHelper.getRandom().nextGaussian() - 0.5), particle.getMotionY() * (double)0.1f + this.random * (RandomHelper.getRandom().nextGaussian() - 0.5), particle.getMotionZ() * (double)0.1f + this.random * (RandomHelper.getRandom().nextGaussian() - 0.5));
        particle.setSize(0.15f);
        particle.m_107257_(6);
    }

    @Override
    public void update(ParticleArcanery particle) {
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        particle.incrementAge();
        if (particle.getAge() >= particle.m_107273_()) {
            particle.m_107274_();
        }
        particle.m_107271_((float)particle.getAge() / (float)particle.m_107273_());
        particle.m_6257_(particle.getMotionX(), particle.getMotionY(), particle.getMotionZ());
        particle.setMotion(particle.getMotionX() * (double)0.7f, particle.getMotionY() * (double)0.7f, particle.getMotionZ() * (double)0.7f);
    }

    @Override
    public ResourceLocation texture() {
        switch (RandomHelper.getRandom().nextInt(3)) {
            case 0: {
                return tex1;
            }
            case 1: {
                return tex2;
            }
        }
        return tex3;
    }
}

