/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class Leaf
extends ParticleEffect {
    private static final ResourceLocation TEX_1 = ResourceLocationHelper.of("pixelmon", "textures/particle/petal.png");
    private static final ResourceLocation TEX_2 = ResourceLocationHelper.of("pixelmon", "textures/particle/leaf.png");
    private final double swingArc;
    private short timeOnGround = 0;
    private double currentRot = 0.0;
    private boolean rotIncreasing = true;
    private final float scale;
    private final boolean shiny;

    public Leaf(double swingArc, float scale, boolean shiny) {
        this.swingArc = swingArc;
        this.scale = scale;
        this.shiny = shiny;
    }

    @Override
    public void preRender(ParticleArcanery particle, float partialTicks) {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    public boolean customRenderer() {
        return true;
    }

    @Override
    public void render(PoseStack matrix, ParticleArcanery particle, Tesselator tesselator, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91097_().m_174784_(particle.getTexture());
        tesselator.m_85915_().m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        float f4 = particle.getSize();
        int combined = 0xF000F0;
        int k3 = combined >> 16 & 0xFFFF;
        int l3 = combined & 0xFFFF;
        float f5 = (float)(particle.getPrevX() + (particle.getX() - particle.getPrevX()) * (double)partialTicks - particle.interpPosX);
        float f6 = (float)(particle.getPrevY() + (particle.getY() - particle.getPrevY()) * (double)partialTicks - particle.interpPosY);
        float f7 = (float)(particle.getPrevZ() + (particle.getZ() - particle.getPrevZ()) * (double)partialTicks - particle.interpPosZ);
        int i = particle.m_6355_(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3[] avec3d = new Vec3[]{new Vec3((double)(-particle.rotationX * f4 - particle.rotationXY * f4), (double)(-particle.rotationZ * f4), (double)(-particle.rotationYZ * f4 - particle.rotationXZ * f4)), new Vec3((double)(-particle.rotationX * f4 + particle.rotationXY * f4), (double)(particle.rotationZ * f4), (double)(-particle.rotationYZ * f4 + particle.rotationXZ * f4)), new Vec3((double)(particle.rotationX * f4 + particle.rotationXY * f4), (double)(particle.rotationZ * f4), (double)(particle.rotationYZ * f4 + particle.rotationXZ * f4)), new Vec3((double)(particle.rotationX * f4 - particle.rotationXY * f4), (double)(-particle.rotationZ * f4), (double)(particle.rotationYZ * f4 - particle.rotationXZ * f4))};
        if (particle.getAngle() != 0.0f) {
            Vec3 view = Minecraft.m_91087_().m_91288_().m_20154_();
            float f8 = particle.getAngle() + (particle.getAngle() - particle.getPrevAngle()) * partialTicks;
            float f9 = Mth.m_14089_((float)(f8 * 0.5f));
            float f10 = Mth.m_14031_((float)(f8 * 0.5f)) * (float)view.f_82479_;
            float f11 = Mth.m_14031_((float)(f8 * 0.5f)) * (float)view.f_82480_;
            float f12 = Mth.m_14031_((float)(f8 * 0.5f)) * (float)view.f_82481_;
            Vec3 vec3d = new Vec3((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.m_82490_(2.0 * avec3d[l].m_82526_(vec3d)).m_82549_(avec3d[l].m_82490_((double)(f9 * f9) - vec3d.m_82526_(vec3d))).m_82549_(vec3d.m_82537_(avec3d[l]).m_82490_((double)(2.0f * f9)));
            }
        }
        Matrix4f pose = matrix.m_85850_().m_252922_();
        tesselator.m_85915_().m_252986_(pose, (float)((double)f5 + avec3d[0].f_82479_), (float)((double)f6 + avec3d[0].f_82480_), (float)((double)f7 + avec3d[0].f_82481_)).m_85950_(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF()).m_7421_(0.0f, 1.0f).m_7120_(k3, l3).m_5752_();
        tesselator.m_85915_().m_252986_(pose, (float)((double)f5 + avec3d[1].f_82479_), (float)((double)f6 + avec3d[1].f_82480_), (float)((double)f7 + avec3d[1].f_82481_)).m_85950_(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF()).m_7421_(1.0f, 1.0f).m_7120_(k3, l3).m_5752_();
        tesselator.m_85915_().m_252986_(pose, (float)((double)f5 + avec3d[2].f_82479_), (float)((double)f6 + avec3d[2].f_82480_), (float)((double)f7 + avec3d[2].f_82481_)).m_85950_(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF()).m_7421_(1.0f, 0.0f).m_7120_(k3, l3).m_5752_();
        tesselator.m_85915_().m_252986_(pose, (float)((double)f5 + avec3d[3].f_82479_), (float)((double)f6 + avec3d[3].f_82480_), (float)((double)f7 + avec3d[3].f_82481_)).m_85950_(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF()).m_7421_(0.0f, 0.0f).m_7120_(k3, l3).m_5752_();
        tesselator.m_85914_();
    }

    @Override
    public void init(ParticleArcanery particle, Level world, double x, double y, double z, double vx, double vy, double vz, float size) {
        particle.setRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        particle.setMotion(particle.getMotionX() + vx, particle.getMotionY() + vy, particle.getMotionZ() + vz);
        particle.m_6569_(0.33333334f);
        particle.m_107257_(40);
    }

    @Override
    public void update(ParticleArcanery particle) {
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        particle.incrementAge();
        if (particle.getAge() > 15) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
            BlockPos blockPos = new BlockPos((int)particle.getX(), (int)(particle.getY() - 0.3), (int)particle.getZ());
            if (clientWorld.m_8055_(blockPos).m_60783_((BlockGetter)clientWorld, blockPos, Direction.UP)) {
                particle.setOnGround();
            }
        }
        if (particle.onGround()) {
            this.timeOnGround = (short)(this.timeOnGround + 1);
            particle.setRGBA(1.0f, 1.0f - (float)this.timeOnGround / (float)particle.m_107273_() / 2.5f, 1.0f - (float)this.timeOnGround / (float)particle.m_107273_(), 1.0f - (float)this.timeOnGround / (float)particle.m_107273_());
        } else {
            if (particle.getMotionY() < 0.0) {
                if (this.rotIncreasing) {
                    this.currentRot += 0.2 * Math.max(0.2, Math.abs(this.swingArc + this.currentRot));
                    particle.setAngle((float)this.currentRot);
                    if ((double)particle.getAngle() >= this.swingArc) {
                        this.rotIncreasing = false;
                    }
                } else {
                    this.currentRot -= 0.2 * Math.max(0.2, Math.abs(this.swingArc - this.currentRot));
                    particle.setAngle((float)this.currentRot);
                    if ((double)particle.getAngle() <= -this.swingArc) {
                        this.rotIncreasing = true;
                    }
                }
            }
            particle.m_6257_(particle.getMotionX(), particle.getMotionY(), particle.getMotionZ());
            particle.setMotion(particle.getMotionX() / 2.0, Math.max(-0.15, particle.getMotionY() - 0.1), particle.getMotionZ() / 2.0);
        }
        if (this.timeOnGround >= particle.m_107273_()) {
            particle.m_107274_();
        }
    }

    @Override
    public ResourceLocation texture() {
        if (this.shiny) {
            return TEX_1;
        }
        return TEX_2;
    }
}

