/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Electric
extends ParticleEffect {
    private final int age;
    private final boolean parent;
    private final float pitch;
    private final float yaw;
    private final float velocity;
    private final float inaccuracy;
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public Electric(int age, boolean parent, float pitch, float yaw, float velocity, float inaccuracy, float r, float g, float b) {
        this.age = age;
        this.parent = parent;
        this.pitch = pitch;
        this.yaw = yaw;
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public Electric(int age, boolean parent, float pitch, float yaw, float velocity, float inaccuracy, float r, float g, float b, float a) {
        this.age = age;
        this.parent = parent;
        this.pitch = pitch;
        this.yaw = yaw;
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    @Override
    public void render(PoseStack matrix, ParticleArcanery particle, Tesselator tesselator, float partialTicks) {
        if (!this.parent) {
            matrix.m_85836_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.depthMask((boolean)false);
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
            float a1 = 0.75f * this.a * (1.0f - (float)particle.getAge() / (float)particle.m_107273_());
            float a2 = Math.max(0.75f * this.a * (1.0f - (float)particle.getAge() / (float)particle.m_107273_()) - 0.3f, 0.0f);
            Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            matrix.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
            BufferBuilder builder = tesselator.m_85915_();
            Matrix4f mat = matrix.m_85850_().m_252922_();
            RenderSystem.lineWidth((float)8.0f);
            builder.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85816_);
            builder.m_252986_(mat, (float)particle.getX(), (float)particle.getY(), (float)particle.getZ()).m_85950_(this.r, this.g, this.b, a2).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(mat, (float)particle.getPrevX(), (float)particle.getPrevY(), (float)particle.getPrevZ()).m_85950_(this.r, this.g, this.b, a2).m_85969_(0xF000F0).m_5752_();
            tesselator.m_85914_();
            RenderSystem.lineWidth((float)3.0f);
            builder.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85816_);
            builder.m_252986_(mat, (float)particle.getX(), (float)particle.getY(), (float)particle.getZ()).m_85950_(this.r, this.g, this.b, a1).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(mat, (float)particle.getPrevX(), (float)particle.getPrevY(), (float)particle.getPrevZ()).m_85950_(this.r, this.g, this.b, a1).m_85969_(0xF000F0).m_5752_();
            tesselator.m_85914_();
            GL11.glDisable((int)2848);
            RenderSystem.disableBlend();
            RenderSystem.lineWidth((float)2.0f);
            matrix.m_85849_();
        }
    }

    @Override
    public boolean customRenderer() {
        return true;
    }

    @Override
    public void init(ParticleArcanery particle, Level world, double x, double y, double z, double vx, double vy, double vz, float size) {
        particle.setRGBA(1.0f, 1.0f, 1.0f, 0.8f * this.a);
        particle.setSize(0.05f);
        particle.m_107257_(this.age);
        particle.m_107264_(x, y, z);
        particle.setPrevPos(vx, vy, vz);
        this.setAim(this.pitch, this.yaw, this.velocity, this.inaccuracy, particle);
    }

    @Override
    public void update(ParticleArcanery particle) {
        if (this.parent) {
            particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
            particle.m_6257_(particle.getMotionX(), particle.getMotionY(), particle.getMotionZ());
            particle.m_6257_((RandomHelper.getRandom().nextDouble() - 0.5) * Doubles.constrainToRange((double)(0.15 + (double)particle.getAge() / 3.0), (double)0.0, (double)1.75), (RandomHelper.getRandom().nextDouble() - 0.5) * Doubles.constrainToRange((double)(0.15 + (double)particle.getAge() / 3.0), (double)0.0, (double)1.75), (RandomHelper.getRandom().nextDouble() - 0.5) * Doubles.constrainToRange((double)(0.15 + (double)particle.getAge() / 3.0), (double)0.0, (double)1.75));
            ParticleArcanery child = new ParticleArcanery(particle.getX(), particle.getY(), particle.getZ(), particle.getPrevX(), particle.getPrevY(), particle.getPrevZ(), new Electric(8, false, 0.0f, 0.0f, 0.0f, 0.0f, this.r, this.g, this.b, this.a));
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)child);
        }
        particle.incrementAge();
        if (particle.getAge() >= particle.m_107273_()) {
            particle.m_107274_();
        }
    }

    @Override
    public ResourceLocation texture() {
        return null;
    }

    private void setAim(float pitch, float yaw, float velocity, float inaccuracy, ParticleArcanery particle) {
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        this.setHeading(f, f1, f2, velocity, inaccuracy, particle);
    }

    private void setHeading(double x, double y, double z, float velocity, float inaccuracy, ParticleArcanery particle) {
        float f = Mth.m_14116_((float)((float)(x * x + y * y + z * z)));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += RandomHelper.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += RandomHelper.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += RandomHelper.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy;
        particle.setMotion(x *= (double)velocity, y *= (double)velocity, z *= (double)velocity);
    }
}

