/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class CycloneBlob
extends ParticleEffect {
    private final double random;
    private double mx;
    private double mz;
    private double theta;
    private final double wu;
    private final double r;
    private final boolean yellow;
    private static final ResourceLocation tex = ResourceLocationHelper.of("pixelmon", "textures/particle/orb.png");

    public CycloneBlob(double random, double theta, double wu, double r, double y) {
        this.random = random;
        this.theta = theta;
        this.wu = wu;
        this.r = r;
        this.yellow = y == 1.0;
    }

    @Override
    public void preRender(ParticleArcanery particle, float partialTicks) {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    public void init(ParticleArcanery particle, Level world, double x, double y, double z, double vx, double vy, double vz, float size) {
        particle.setRGBA(1.0f, this.yellow ? 1.0f : 0.0f, this.yellow ? 1.0f : 0.0f, 0.4f);
        particle.setMotion(particle.getMotionX() * (double)0.1f + this.random * (RandomHelper.getRandom().nextGaussian() - 0.5), particle.getMotionY() * (double)0.1f, particle.getMotionZ() * (double)0.1f + this.random * (RandomHelper.getRandom().nextGaussian() - 0.5));
        particle.setMotion(particle.getMotionX() + vx, particle.getMotionY() + vy, particle.getMotionZ() + vz);
        this.mx = vx;
        this.mz = vz;
        particle.setSize(0.55f);
        particle.m_107257_(10);
    }

    @Override
    public void update(ParticleArcanery particle) {
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        particle.incrementAge();
        if (particle.getSize() <= 0.5f || particle.getAge() >= particle.m_107273_()) {
            particle.m_107274_();
            return;
        }
        particle.setSize(particle.getSize() / 45.0f * (float)(45 - particle.getAge()));
        particle.m_6257_(particle.getMotionX(), particle.getMotionY(), particle.getMotionZ());
        this.theta += this.wu * (double)particle.getAge() / 2.0;
        this.mx = this.r * Math.cos(this.theta) / 6.0;
        this.mz = this.r * Math.sin(this.theta) / 6.0;
        particle.setMotion(this.mx, particle.getMotionY(), this.mz);
        particle.setRGBA(Math.min(0.1f + 0.8f / ((float)particle.getAge() / 2.5f), 1.0f), this.yellow ? Math.min(0.1f + 0.8f / ((float)particle.getAge() / 2.5f), 1.0f) : 0.0f, this.yellow ? Math.min(0.1f + 0.8f / ((float)particle.getAge() / 2.5f), 1.0f) : 0.0f, 0.4f);
    }

    @Override
    public ResourceLocation texture() {
        return tex;
    }
}

