/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Beam
extends ParticleEffect {
    private final Entity start;
    private final Entity end;
    private final Vec3 startOffset;
    private final Vec3 endOffset;
    private final double theta;
    private final int sections;
    private final float variance;
    private final float fadeIn;
    private final float fadeOut;
    private final float rateIn;
    private final int delay;
    private final float rateOut;
    private final float r;
    private final float g;
    private final float b;
    private final List<Vec3> points = Lists.newArrayList();

    public Beam(Entity start, Entity end, Vec3 startOffset, Vec3 endOffset, double theta, int sections, float variance, float fadeIn, float fadeOut, float rateIn, int delay, float rateOut, float r, float g, float b) {
        this.start = start;
        this.end = end;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.theta = theta;
        this.sections = sections;
        this.variance = variance;
        this.fadeIn = fadeIn;
        this.fadeOut = fadeOut;
        this.rateIn = rateIn;
        this.delay = delay;
        this.rateOut = rateOut;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Override
    public void render(PoseStack matrix, ParticleArcanery particle, Tesselator tesselator, float partialTicks) {
        matrix.m_85836_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.depthMask((boolean)false);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        BufferBuilder builder = tesselator.m_85915_();
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrix.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        Matrix4f mat = matrix.m_85850_().m_252922_();
        for (int i = 1; i < this.points.size(); ++i) {
            Vec3 a = this.points.get(i - 1);
            Vec3 b = i + 1 == this.points.size() ? this.points.get(this.points.size() - 1) : this.points.get(i);
            float age = (float)particle.getAge() * this.rateIn;
            float alpha = Mth.m_14036_((float)((age - (float)i) * this.fadeIn), (float)0.0f, (float)1.0f);
            if (particle.getAge() >= this.sections + this.delay) {
                float oldAge = (float)(particle.getAge() - (this.sections + this.delay)) * this.rateOut;
                alpha = Mth.m_14036_((float)(((float)(this.sections - i) - oldAge) * this.fadeOut), (float)0.0f, (float)1.0f);
            }
            if (i > this.points.size() - 4) {
                int i2 = Math.abs(i - this.points.size()) - 1;
                alpha *= Math.min(1.0f, (float)i2 / 3.0f + 0.1f);
            }
            if (particle.getAge() > particle.m_107273_() - 10) {
                int i2 = Math.abs(particle.getAge() - particle.m_107273_()) - 1;
                alpha *= Math.min(1.0f, (float)i2 / 10.0f);
            }
            RenderSystem.lineWidth((float)6.0f);
            builder.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85816_);
            builder.m_252986_(mat, (float)a.f_82479_, (float)a.f_82480_, (float)a.f_82481_).m_85950_(this.r, this.g, this.b, alpha / 3.0f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(mat, (float)b.f_82479_, (float)b.f_82480_, (float)b.f_82481_).m_85950_(this.r, this.g, this.b, alpha / 3.0f).m_85969_(0xF000F0).m_5752_();
            tesselator.m_85914_();
            RenderSystem.lineWidth((float)1.0f);
            builder.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85816_);
            builder.m_252986_(mat, (float)a.f_82479_, (float)a.f_82480_, (float)a.f_82481_).m_85950_(this.r, this.g, this.b, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(mat, (float)b.f_82479_, (float)b.f_82480_, (float)b.f_82481_).m_85950_(this.r, this.g, this.b, alpha).m_85969_(0xF000F0).m_5752_();
            tesselator.m_85914_();
        }
        GL11.glDisable((int)2848);
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)2.0f);
        matrix.m_85849_();
    }

    @Override
    public boolean customRenderer() {
        return true;
    }

    @Override
    public void init(ParticleArcanery particle, Level world, double x, double y, double z, double vx, double vy, double vz, float size) {
        Vec3 start = this.start.m_20182_().m_82549_(this.startOffset);
        Vec3 end = this.end.m_20182_().m_82549_(this.endOffset);
        double ptheta = 1.5707963267948966 - this.theta;
        double arc = (this.theta + 1.5707963267948966) / (double)this.sections;
        double h = start.f_82480_ - end.f_82480_;
        double dx = (end.f_82479_ - start.f_82479_) / (double)this.sections;
        double dz = (end.f_82481_ - start.f_82481_) / (double)this.sections;
        double r = h / Math.cos(this.theta);
        this.points.add(start);
        for (int i = 1; i < this.sections; ++i) {
            Vec3 variance = RandomHelper.nextSpherePoint(this.variance);
            double nx = start.f_82479_ + dx * (double)i + variance.f_82479_;
            double ny = end.f_82480_ + r * Math.sin(ptheta + arc * (double)i) + variance.f_82480_;
            double nz = start.f_82481_ + dz * (double)i + variance.f_82481_;
            this.points.add(new Vec3(nx, ny, nz));
        }
        this.points.add(end);
        particle.setRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        particle.setSize(0.05f);
        particle.m_107257_((int)Math.floor(this.rateIn * (float)this.sections) + this.delay);
        double px = (start.f_82479_ + end.f_82479_) / 2.0;
        double py = (start.f_82480_ + end.f_82480_) / 2.0;
        double pz = (start.f_82481_ + end.f_82481_) / 2.0;
        particle.m_107264_(px, py, pz);
        particle.setPrevPos(px, py, pz);
    }

    @Override
    public void update(ParticleArcanery particle) {
        particle.incrementAge();
        if (particle.getAge() >= particle.m_107273_()) {
            particle.m_107274_();
        }
    }

    @Override
    public ResourceLocation texture() {
        return null;
    }
}

