/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.IAttackEffect;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AttackEffect
extends ParticleEffect {
    public double startX;
    public double startY;
    public double startZ;
    public double endX;
    public double endY;
    public double endZ;
    public double innaccuracy;
    public double travelledDistance = 0.0;
    public double totalDistance;
    public int maxAge;
    public int age = 0;
    public boolean eol = false;
    public double speed;
    public double mX;
    public double mY;
    public double mZ;
    public Element type;
    public float r = -1.0f;
    public float g = -1.0f;
    public float b = -1.0f;
    public float scale = -1.0f;
    public ResourceLocation texture = null;
    public int hiddenUntil;
    public boolean hiddenIsDisable;
    public int ticker = 0;
    public double noiseParam = 20.0;
    public int startID;
    public int endID;
    public Minecraft mc;
    public IAttackEffect callback = null;

    public AttackEffect() {
    }

    public AttackEffect setLifetimeTicks(int ticks) {
        this.maxAge = ticks;
        return this;
    }

    public AttackEffect setHideTicks(int hideTicks, boolean hideWhileDisabled) {
        if (hideTicks == 0) {
            this.hiddenUntil = 0;
            this.hiddenIsDisable = false;
            return this;
        }
        this.hiddenUntil = hideTicks;
        this.hiddenIsDisable = hideWhileDisabled;
        return this;
    }

    public AttackEffect setNoise(double noiseParam) {
        this.noiseParam = noiseParam;
        if (noiseParam == 0.0) {
            this.innaccuracy = 0.0;
        }
        return this;
    }

    public AttackEffect setStartPos(float startX, float startY, float startZ) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.setHeading();
        return this;
    }

    public AttackEffect setStartPos(double startX, double startY, double startZ) {
        return this.setStartPos((float)startX, (float)startY, (float)startZ);
    }

    public AttackEffect setEndPos(float endX, float endY, float endZ) {
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.setHeading();
        return this;
    }

    public AttackEffect setEndPos(double endX, double endY, double endZ) {
        return this.setEndPos((float)endX, (float)endY, (float)endZ);
    }

    public AttackEffect(IAttackEffect effect, int startEntityID, float[] startPos, int endEntityID, float[] endPos, StandardParticleAnimationData data) {
        this.callback = effect;
        this.startID = startEntityID;
        this.startX = startPos[0];
        this.startY = startPos[1];
        this.startZ = startPos[2];
        this.endID = endEntityID;
        this.endX = endPos[0];
        this.endY = endPos[1];
        this.endZ = endPos[2];
        if (data != null) {
            this.speed = data.speed;
            this.r = (float)data.rgb[0] / 255.0f;
            this.g = (float)data.rgb[1] / 255.0f;
            this.b = (float)data.rgb[2] / 255.0f;
            this.texture = data.texture.texture;
            this.maxAge = data.lifetimeTicks;
            this.scale = data.scale;
        }
        this.innaccuracy = 0.05f;
        this.setHeading();
        this.callback = effect;
        this.callback.onConstruct(this);
    }

    public AttackEffect(IAttackEffect effect, double startX, double startY, double startZ, double endX, double endY, double endZ, int accuracy, int hiddenUntil, boolean hiddenIsDisable, double noiseParam, double speed, int startID, int endID) {
        this.innaccuracy = 1.0 - (double)accuracy / 100.0 + 0.05;
        this.speed = speed;
        this.hiddenUntil = hiddenUntil;
        this.hiddenIsDisable = hiddenIsDisable;
        this.noiseParam = noiseParam;
        this.startID = startID;
        this.endID = endID;
        this.mc = Minecraft.m_91087_();
        this.callback = effect;
        this.callback.onConstruct(this);
    }

    public void setHeading() {
        double dX = this.endX - this.startX;
        double dY = this.endY - this.startY;
        double dZ = this.endZ - this.startZ;
        this.totalDistance = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double distanceFactor = this.speed / this.totalDistance;
        Vec3 offsetVector = this.offset();
        this.mX = dX * distanceFactor + offsetVector.f_82479_;
        this.mY = dY * distanceFactor + offsetVector.f_82480_;
        this.mZ = dZ * distanceFactor + offsetVector.f_82481_;
    }

    private Vec3 offset() {
        return ParticleMathHelper.generatePointInSphere(0.5 * this.innaccuracy * 1.2, RandomHelper.getRandom());
    }

    private double noise() {
        if (this.noiseParam == 0.0) {
            return 0.0;
        }
        return (RandomHelper.getLegacyRandom().nextDouble() - 0.5) / this.noiseParam;
    }

    @Override
    public void init(ParticleArcanery particle, Level world, double x, double y, double z, double vx, double vy, double vz, float size) {
        if (this.callback == null && particle.getEffect() instanceof IAttackEffect) {
            this.callback = (IAttackEffect)((Object)particle.getEffect());
        }
        if (this.callback == null) {
            particle.m_107274_();
            return;
        }
        particle.setRGBA(this.r, this.g, this.b, 1.0f);
        if (this.hiddenUntil < 1) {
            particle.setSize(this.scale);
        } else {
            particle.setSize(0.0f);
        }
        particle.m_107257_(this.maxAge);
        particle.m_107264_(x, y, z);
        particle.setPrevPos(x, y, z);
        particle.setMotion(this.mX, this.mY, this.mZ);
        this.callback.onInit(particle, this);
    }

    @Override
    public void update(ParticleArcanery particle) {
        ++this.ticker;
        if (this.ticker > 500) {
            particle.m_107274_();
        }
        if (this.hiddenUntil > 0 && this.ticker >= this.hiddenUntil) {
            particle.setSize(this.scale);
            if (this.hiddenIsDisable) {
                this.callback.onEnable(particle, this);
            }
            this.hiddenIsDisable = false;
        }
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        if (!this.hiddenIsDisable) {
            particle.m_6257_(particle.getMotionX(), particle.getMotionY(), particle.getMotionZ());
            particle.setMotion(particle.getMotionX() + this.noise(), particle.getMotionY() + this.noise(), particle.getMotionZ() + this.noise());
            this.travelledDistance += this.speed;
            this.callback.onUpdate(particle, this);
        }
        if (!this.hiddenIsDisable && this.travelledDistance >= this.totalDistance && !this.eol) {
            this.eol = true;
            this.callback.onTarget(particle, this);
        }
        if (this.eol) {
            particle.incrementAge();
            if (particle.getAge() >= particle.m_107273_()) {
                particle.m_107274_();
            }
            particle.setSize(Math.max(particle.getSize() * 0.95f, 0.0f));
            this.callback.onUpdateEol(particle, this);
        }
        this.callback.onUpdateLast(particle, this);
    }

    @Override
    public boolean customRenderer() {
        return this.callback.hasCustomRenderer(this);
    }

    @Override
    public void preRender(ParticleArcanery particle, float partialTicks) {
        this.callback.onPreRender(particle, partialTicks, this);
    }

    @Override
    public void render(PoseStack matrix, ParticleArcanery particle, Tesselator tesselator, float partialTicks) {
        this.callback.onRender(particle, tesselator, partialTicks, this);
    }

    @Override
    public void postRender(ParticleArcanery particle, float partialTicks) {
        this.callback.onPostRender(particle, partialTicks, this);
    }

    @Override
    public ResourceLocation texture() {
        return this.texture;
    }

    public static enum EnumParticleTexture {
        NORMAL(ResourceLocationHelper.of("pixelmon", "textures/particle/attack.png")),
        LEAF(ResourceLocationHelper.of("pixelmon", "textures/particle/leaf.png")),
        PETAL(ResourceLocationHelper.of("pixelmon", "textures/particle/petal.png")),
        HEART_PURPLE(ResourceLocationHelper.of("pixelmon", "textures/particle/heartpurple.png")),
        HEART_RED(ResourceLocationHelper.of("pixelmon", "textures/particle/heartred.png")),
        FLAME(ResourceLocationHelper.of("pixelmon", "textures/particle/flame.png")),
        BUBBLE(ResourceLocationHelper.of("pixelmon", "textures/particle/bubble.png")),
        WATER(ResourceLocationHelper.of("pixelmon", "textures/particle/water.png")),
        SPIRAL(ResourceLocationHelper.of("pixelmon", "textures/particle/spiral.png")),
        DUST(ResourceLocationHelper.of("pixelmon", "textures/particle/dust.png")),
        SOLID(ResourceLocationHelper.of("pixelmon", "textures/particle/solid.png")),
        UP_ARROW(ResourceLocationHelper.of("pixelmon", "textures/particle/uparrow.png")),
        DOWN_ARROW(ResourceLocationHelper.of("pixelmon", "textures/particle/downarrow.png")),
        GOLD_NUGGET(ResourceLocationHelper.of("pixelmon", "textures/particle/gold_nugget.png")),
        BLUE_MAGIC(ResourceLocationHelper.of("pixelmon", "textures/particle/blue_magic.png")),
        ORB(ResourceLocationHelper.of("pixelmon", "textures/particle/orb.png")),
        FEATHER(ResourceLocationHelper.of("pixelmon", "textures/particle/feather.png"));

        public final ResourceLocation texture;

        private EnumParticleTexture(ResourceLocation texture) {
            this.texture = texture;
        }
    }
}

