/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystem;
import com.pixelmonmod.pixelmon.client.particle.systems.Bloom;
import com.pixelmonmod.pixelmon.client.particle.systems.Discharge;
import com.pixelmonmod.pixelmon.client.particle.systems.Drain;
import com.pixelmonmod.pixelmon.client.particle.systems.Heal;
import com.pixelmonmod.pixelmon.client.particle.systems.RadialThunder;
import com.pixelmonmod.pixelmon.client.particle.systems.RedChainPortal;
import com.pixelmonmod.pixelmon.client.particle.systems.Shiny;
import com.pixelmonmod.pixelmon.client.particle.systems.SlingRing;
import com.pixelmonmod.pixelmon.client.particle.systems.UltraWormhole;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public enum ParticleSystems {
    HEAL(new ResourceLocation("arcanery:heal"), new Heal()),
    REDCHAINPORTAL(new ResourceLocation("arcanery:red_chain_portal"), new RedChainPortal()),
    DRAIN(new ResourceLocation("arcanery:drain"), new Drain()),
    BLOOM(new ResourceLocation("arcanery:bloom"), new Bloom()),
    DISCHARGE(new ResourceLocation("arcanery:discharge"), new Discharge()),
    RADIALTHUNDER(new ResourceLocation("arcanery:radial_thunder"), new RadialThunder()),
    SLINGRING(new ResourceLocation("arcanery:sling_ring"), new SlingRing()),
    ULTRAWORMHOLE(new ResourceLocation("arcanery:ultra_wormhole"), new UltraWormhole()),
    SHINY(new ResourceLocation("arcanery:shiny"), new Shiny());

    private static final Map<ResourceLocation, ParticleSystems> RL_MAP;
    public static final String NAMESPACE = "arcanery";
    private final ResourceLocation rl;
    private final ParticleSystem system;

    private ParticleSystems(ResourceLocation rl, ParticleSystem system) {
        this.rl = rl;
        this.system = system;
    }

    public ParticleSystem getSystem() {
        return this.system;
    }

    public ResourceLocation getResource() {
        return this.rl;
    }

    public static ParticleSystem get(int i) {
        return ParticleSystems.values()[i].system;
    }

    public static ParticleSystems get(ResourceLocation rl) {
        return RL_MAP.get(rl);
    }

    static {
        RL_MAP = Maps.newHashMap();
        for (ParticleSystems system : ParticleSystems.values()) {
            RL_MAP.put(system.rl, system);
        }
    }
}

