/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.particle.ParticleEffect;
import com.pixelmonmod.pixelmon.client.particle.ParticleEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ParticleArcanery
extends Particle {
    private static final Comparator<ParticleArcanery> RENDER_ORDER = Comparator.comparingDouble(particle -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            double d0 = player.m_20185_() - particle.f_107212_;
            double d1 = player.m_20188_() - particle.f_107213_;
            double d2 = player.m_20189_() - particle.f_107214_;
            return -(d0 * d0 + d1 * d1 + d2 * d2);
        }
        return 0.0;
    });
    private static final List<ParticleArcanery> PARTICLE_QUEUE = new ArrayList<ParticleArcanery>();
    public ParticleEffect effect;
    private float partialTicks;
    public float rotationX;
    public float rotationZ;
    public float rotationYZ;
    public float rotationXY;
    public float rotationXZ;
    public double interpPosX;
    public double interpPosY;
    public double interpPosZ;
    public Camera info;

    public ParticleArcanery(double x, double y, double z, double vx, double vy, double vz, ParticleEffect effect) {
        this(x, y, z, vx, vy, vz, 0.5f, effect);
    }

    public ParticleArcanery(double x, double y, double z, double vx, double vy, double vz, float size, ParticleEffect effect) {
        super(Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_ : null, x, y, z, vx, vy, vz);
        this.setPrevPos(x, y, z);
        this.effect = effect;
        effect.init(this, this.getWorld(), x, y, z, vx, vy, vz, size);
        this.m_5989_();
    }

    public void setRGBA(float r, float g, float b, float a) {
        this.f_107227_ = r;
        this.f_107228_ = g;
        this.f_107229_ = b;
        this.f_107230_ = a;
    }

    public double getMotionX() {
        return this.f_107215_;
    }

    public double getMotionY() {
        return this.f_107216_;
    }

    public double getMotionZ() {
        return this.f_107217_;
    }

    public void setMotion(double x, double y, double z) {
        this.f_107215_ = x;
        this.f_107216_ = y;
        this.f_107217_ = z;
    }

    public void setOnGround() {
        this.f_107218_ = true;
    }

    public void m_107257_(int lifetime) {
        this.f_107225_ = lifetime;
    }

    public int m_107273_() {
        return this.f_107225_;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public boolean shouldCull() {
        return false;
    }

    public void incrementAge() {
        ++this.f_107224_;
    }

    public int getAge() {
        return this.f_107224_;
    }

    public float getSize() {
        return Math.max(this.f_107221_, this.f_107222_);
    }

    public void setSize(float size) {
        this.m_107250_(size, size);
    }

    public float getWidth() {
        return this.f_107221_;
    }

    public void setWidth(float width) {
        this.f_107221_ = width;
    }

    public float getHeight() {
        return this.f_107222_;
    }

    public void setHeight(float height) {
        this.f_107222_ = height;
    }

    public double getX() {
        return this.f_107212_;
    }

    public double getY() {
        return this.f_107213_;
    }

    public double getZ() {
        return this.f_107214_;
    }

    public void m_107264_(double x, double y, double z) {
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
    }

    public double getPrevX() {
        return this.f_107209_;
    }

    public double getPrevY() {
        return this.f_107210_;
    }

    public double getPrevZ() {
        return this.f_107211_;
    }

    public void setPrevPos(double x, double y, double z) {
        this.f_107209_ = x;
        this.f_107210_ = y;
        this.f_107211_ = z;
    }

    public void setHeading(double x, double y, double z, float velocity, float inaccuracy) {
        float f = Mth.m_14116_((float)((float)(x * x + y * y + z * z)));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += RandomHelper.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += RandomHelper.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += RandomHelper.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.f_107215_ = x *= (double)velocity;
        this.f_107216_ = y *= (double)velocity;
        this.f_107217_ = z *= (double)velocity;
    }

    public boolean onGround() {
        return this.f_107218_;
    }

    public static void dispatch(PoseStack matrix, Tesselator tesselator, float ticks) {
        ParticleEvents.arcaneryParticleCount = 0;
        if (Minecraft.m_91405_()) {
            PARTICLE_QUEUE.sort(RENDER_ORDER);
        }
        for (ParticleArcanery particle : PARTICLE_QUEUE) {
            if (particle == null || Minecraft.m_91087_().m_91104_()) continue;
            if (particle.getEffect().customRenderer()) {
                particle.getEffect().preRender(particle, ticks);
                particle.getEffect().render(matrix, particle, tesselator, ticks);
                particle.getEffect().postRender(particle, ticks);
                continue;
            }
            ResourceLocation texture = particle.getTexture();
            if (texture != null) {
                RenderSystem.enableDepthTest();
                RenderSystem.activeTexture((int)33986);
                RenderSystem.activeTexture((int)33984);
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShader(GameRenderer::m_172829_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)particle.getTexture());
            }
            particle.getEffect().preRender(particle, ticks);
            BufferBuilder buffer = tesselator.m_85915_();
            particle.render(matrix, tesselator, buffer, ticks);
            particle.getEffect().postRender(particle, ticks);
        }
        PARTICLE_QUEUE.clear();
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        this.partialTicks = partialTicks;
        this.interpPosX = Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_);
        this.interpPosY = Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_);
        this.interpPosZ = Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_);
        this.info = renderInfo;
        if (!Minecraft.m_91087_().m_91104_()) {
            PARTICLE_QUEUE.add(this);
        }
    }

    public float getAngle() {
        return this.f_107231_;
    }

    public float getPrevAngle() {
        return this.f_107204_;
    }

    public float getAlphaF() {
        return this.f_107230_;
    }

    public ResourceLocation getTexture() {
        return this.effect.texture();
    }

    public void render(PoseStack matrix, Tesselator tesselator, BufferBuilder buffer, float partialTicks) {
        ++ParticleEvents.arcaneryParticleCount;
        Vector3f[] avector3f = this.doStandardParticleRotation(this.info.m_90583_(), partialTicks);
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        int BLOCK_LIGHT = 15;
        int SKY_LIGHT = 15;
        int j = LightTexture.m_109885_((int)BLOCK_LIGHT, (int)15);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        Matrix4f mat = matrix.m_85850_().m_252922_();
        buffer.m_252986_(mat, avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_252986_(mat, avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_252986_(mat, avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_252986_(mat, avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        tesselator.m_85914_();
    }

    public ParticleEffect getEffect() {
        return this.effect;
    }

    public void m_5989_() {
        this.effect.update(this);
    }

    protected void m_107275_() {
    }

    public void m_6257_(double dx, double dy, double dz) {
        if (!this.getEffect().customRenderer()) {
            if (!this.f_107205_) {
                double d0 = dx;
                double d1 = dy;
                double d2 = dz;
                if (this.f_107219_ && (dx != 0.0 || dy != 0.0 || dz != 0.0)) {
                    Vec3 vector3d = Entity.m_198894_(null, (Vec3)new Vec3(dx, dy, dz), (AABB)this.m_107277_(), (Level)this.f_107208_, Collections.emptyList());
                    dx = vector3d.f_82479_;
                    dy = vector3d.f_82480_;
                    dz = vector3d.f_82481_;
                }
                if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
                    this.f_107212_ += dx;
                    this.f_107213_ += dy;
                    this.f_107214_ += dz;
                }
                if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(dy) < (double)1.0E-5f) {
                    this.f_107205_ = true;
                }
                boolean bl = this.f_107218_ = d1 != dy && d1 < 0.0;
                if (d0 != dx) {
                    this.f_107215_ = 0.0;
                }
                if (d2 != dz) {
                    this.f_107217_ = 0.0;
                }
            }
        } else {
            this.m_107264_(this.getX() + dx, this.getY() + dy, this.getZ() + dz);
            float size = this.getSize() / 2.0f;
            this.m_107259_(new AABB(this.getX() - (double)size, this.getY() - (double)size, this.getZ() - (double)size, this.getX() + (double)size, this.getY() + (double)size, this.getZ() + (double)size));
        }
    }

    public void setAngle(float theta) {
        this.f_107204_ = this.f_107231_;
        this.f_107231_ = theta;
    }

    public RandomSource getRandom() {
        return this.f_107223_;
    }

    public Level getWorld() {
        return this.f_107208_;
    }

    public float getRedColorF() {
        return this.f_107227_;
    }

    public float getGreenColorF() {
        return this.f_107228_;
    }

    public float getBlueColorF() {
        return this.f_107229_;
    }

    public float getAlphaColorF() {
        return this.f_107230_;
    }

    public Vector3f[] doStandardParticleRotation(Vec3 vector3d, float partialTicks) {
        Quaternionf quaternion;
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vector3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vector3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vector3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = this.info.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)this.info.m_253121_());
            float f3 = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.getSize();
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        return avector3f;
    }
}

