/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.music;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.SoundEngineLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="pixelmon", value={Dist.CLIENT})
public class PixelmonMusic {
    public static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pixelmon_music_%d").build());
    private static MusicManager mcMusicTicker;
    private static SoundManager mcSoundHandler;
    private static SoundEngine mcSoundManager;
    private static SoundEngine soundSystem;
    private static final Map<SoundInstance, Float> FADE;

    @SubscribeEvent
    public static void onSoundReloadEvent(SoundEngineLoadEvent event) {
        CompletableFuture future = new CompletableFuture();
        ScheduledFuture<?> scheduledFuture = EXECUTOR.scheduleWithFixedDelay(() -> {
            if (((Boolean)ObfuscationReflectionHelper.getPrivateValue(SoundEngine.class, (Object)mcSoundManager, (String)"field_148617_f")).booleanValue()) {
                PixelmonMusic.init(Minecraft.m_91087_());
                future.complete(null);
            }
        }, 10L, 10L, TimeUnit.MILLISECONDS);
        future.thenAccept(v -> scheduledFuture.cancel(false));
    }

    public static void init(Minecraft mc) {
    }

    public static MusicManager getMusicTicker() {
        return mcMusicTicker;
    }

    public static SoundManager getSoundHandler() {
        return mcSoundHandler;
    }

    public static SoundEngine getSoundManager() {
        return mcSoundManager;
    }

    public static void fadeSoundToStart(SoundInstance sound, long millis) {
        if (!mcSoundManager.m_120305_(sound)) {
            PixelmonMusic.fadeSoundToStartInternal(sound, millis);
        }
    }

    private static void fadeSoundToStartInternal(SoundInstance sound, long millis) {
        try {
            EXECUTOR.submit(() -> {
                PixelmonMusic.resetFade(sound, false);
                mcSoundManager.m_120312_(sound);
                AtomicReference<Object> channel = new AtomicReference<Object>(null);
                PixelmonMusic.mcSoundManager.f_120226_.forEach((s, c) -> {
                    if (Objects.equals(sound, s)) {
                        channel.set(c);
                    }
                });
                float initialVolume = 1.0f;
                if (channel.get() != null) {
                    initialVolume = mcSoundManager.m_120327_(sound);
                }
                try {
                    int i = 0;
                    while ((long)i < millis) {
                        float volume = PixelmonMusic.fadeSound(sound, initialVolume, millis, false);
                        if (channel.get() != null) {
                            ((ChannelAccess.ChannelHandle)channel.get()).m_120154_(source -> source.m_83666_(volume));
                        }
                        Thread.sleep(1L);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PixelmonMusic.resetFade(sound, false);
                if (channel.get() != null) {
                    float finalInitialVolume = initialVolume;
                    ((ChannelAccess.ChannelHandle)channel.get()).m_120154_(source -> source.m_83666_(finalInitialVolume));
                }
            });
        }
        catch (Exception e) {
            mcSoundManager.m_120312_(sound);
        }
    }

    public static void fadeSoundToStop(SoundInstance sound, long millis) {
        if (mcSoundManager.m_120305_(sound)) {
            PixelmonMusic.fadeSoundToStopInternal(sound, millis, null);
        }
    }

    public static void fadeSoundToStop(SoundInstance sound, long millis, Runnable runnable) {
        if (mcSoundManager.m_120305_(sound)) {
            PixelmonMusic.fadeSoundToStopInternal(sound, millis, runnable);
        } else {
            runnable.run();
        }
    }

    private static void fadeSoundToStopInternal(SoundInstance sound, long millis, Runnable runnable) {
        block2: {
            try {
                EXECUTOR.submit(() -> {
                    PixelmonMusic.resetFade(sound, true);
                    AtomicReference<Object> channel = new AtomicReference<Object>(null);
                    PixelmonMusic.mcSoundManager.f_120226_.forEach((s, c) -> {
                        if (Objects.equals(sound, s)) {
                            channel.set(c);
                        }
                    });
                    float initialVolume = 1.0f;
                    if (channel.get() != null) {
                        initialVolume = mcSoundManager.m_120327_(sound);
                    }
                    try {
                        int i = 0;
                        while ((long)i < millis) {
                            float volume = PixelmonMusic.fadeSound(sound, initialVolume, millis, true);
                            if (channel.get() != null) {
                                ((ChannelAccess.ChannelHandle)channel.get()).m_120154_(source -> source.m_83666_(volume));
                            }
                            Thread.sleep(1L);
                            ++i;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    mcSoundManager.m_120274_(sound);
                    PixelmonMusic.resetFade(sound, true);
                    if (channel.get() != null) {
                        float finalInitialVolume = initialVolume;
                        ((ChannelAccess.ChannelHandle)channel.get()).m_120154_(source -> source.m_83666_(finalInitialVolume));
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                });
            }
            catch (Exception e) {
                mcSoundManager.m_120274_(sound);
                if (runnable == null) break block2;
                runnable.run();
            }
        }
    }

    public static void pause(SoundInstance sound) {
        if (mcSoundManager.m_120305_(sound)) {
            mcSoundHandler.m_120391_();
        }
    }

    public static void resume(SoundInstance sound) {
        mcSoundHandler.m_120367_(sound);
    }

    public static float fadeSound(SoundInstance sound, float initialVolume, long factor, boolean fadeOut) {
        float fade = FADE.getOrDefault(sound, Float.valueOf(fadeOut ? 1.0f : 0.0f)).floatValue();
        fade = fadeOut ? (fade -= 1.0f / (float)factor) : (fade += 1.0f / (float)factor);
        FADE.put(sound, Float.valueOf(fade));
        return initialVolume * fade;
    }

    public static void resetFade(SoundInstance sound, boolean fadeOut) {
        FADE.put(sound, Float.valueOf(fadeOut ? 1.0f : 0.0f));
    }

    static {
        FADE = Maps.newConcurrentMap();
    }
}

