/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.music;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.client.music.PixelmonMusic;
import com.pixelmonmod.pixelmon.client.music.VoidMusicTicker;
import com.pixelmonmod.pixelmon.sounds.BattleMusicType;
import com.pixelmonmod.pixelmon.sounds.PixelmonSounds;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class BattleMusic {
    private static SoundInstance song;

    public static void startBattleMusic(BattleMusicType type, int index, long playtime, boolean repeat) {
        if (playtime == -1L) {
            BattleMusic.endBattleMusic();
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        VoidMusicTicker.replaceMusicTicker();
        if (BattleMusic.isPlaying()) {
            mc.m_91106_().m_120399_(song);
            song = null;
        }
        SoundEvent soundEvent = PixelmonSounds.battleMusics.get((Object)type);
        FixedTrackSound record = new FixedTrackSound(soundEvent, SoundSource.MUSIC, PixelmonConfigProxy.getBattle().getBattleMusicVolume(), 1.0f, RandomSource.m_216327_(), new BlockPos(0, 0, 0), index);
        song = record;
        PixelmonMusic.fadeSoundToStart((SoundInstance)record, 2000L);
    }

    public static void endBattleMusic() {
        Minecraft mc = Minecraft.m_91087_();
        if (BattleMusic.isPlaying()) {
            PixelmonMusic.fadeSoundToStop(song, 2000L, VoidMusicTicker::restoreMusicTicker);
        } else if (mc.m_91397_() instanceof VoidMusicTicker) {
            VoidMusicTicker.restoreMusicTicker();
        }
        song = null;
    }

    public static boolean isPlaying() {
        return song != null && PixelmonMusic.getSoundHandler() != null && PixelmonMusic.getSoundHandler().m_120403_(song);
    }

    public static class FixedTrackSound
    extends SimpleSoundInstance {
        int index;

        public FixedTrackSound(SoundEvent p_235109_, SoundSource p_235110_, float p_235111_, float p_235112_, RandomSource p_235113_, BlockPos p_235114_, int index) {
            super(p_235109_, p_235110_, p_235111_, p_235112_, p_235113_, p_235114_);
            this.index = index;
        }

        public WeighedSoundEvents m_6775_(SoundManager handler) {
            List accessorList;
            WeighedSoundEvents accessor = super.m_6775_(handler);
            if (this.index >= 0 && (accessorList = (List)ObfuscationReflectionHelper.getPrivateValue(WeighedSoundEvents.class, (Object)accessor, (String)"f_120441_")).size() > this.index) {
                this.f_119570_ = (Sound)((Weighted)accessorList.get(this.index)).m_213718_(RandomSource.m_216327_());
            }
            return accessor;
        }

        public SoundInstance.Attenuation m_7438_() {
            return super.m_7438_();
        }
    }
}

