/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelData;
import com.pixelmonmod.pixelmon.api.util.RegexPatterns;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimFrame;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimationSequence;
import com.pixelmonmod.pixelmon.client.models.smd.SmdModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.model.Model;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class ValveStudioModel
extends Model {
    public SmdModel body;
    public Bone root;
    ArrayList<Bone> allBones;
    public SmdAnimationSequence currentSequence;
    public ResourceLocation resource;
    private boolean hasAnimations = false;
    public HashMap<AnimationType, SmdAnimationSequence> anims = new HashMap(4);
    private float scale = 1.0f;
    public int renderCount = 0;
    private int lastFrame = -1;

    public ValveStudioModel(ResourceLocation resource) throws GabeNewellException {
        this(null, resource);
    }

    public ValveStudioModel(ModelData modelData, ResourceLocation resource) throws GabeNewellException {
        super(PixelmonRendering::getSMDRenderType);
        this.resource = resource;
        this.loadQC(resource);
        this.reformBones();
        this.precalculateAnimations(modelData);
    }

    public float getScale() {
        return this.scale;
    }

    public boolean hasAnimations() {
        return this.hasAnimations;
    }

    private void precalculateAnimations(ModelData modelData) {
        if (this.anims.values().isEmpty()) {
            SmdAnimation animation;
            Pixelmon.LOGGER.warn("Model {} has no animations!", (Object)this.resource);
            AnimFrame frame = new AnimFrame(0);
            frame.owner = animation = new SmdAnimation(this, "idle", frame);
            frame.addTransforms(0, new Matrix4f());
            this.anims.put(AnimationType.IDLE, new SmdAnimationSequence(AnimationType.IDLE, List.of(animation)));
        }
        for (SmdAnimationSequence anim : this.anims.values()) {
            anim.precalculate(modelData, this.body);
        }
    }

    public void m_7695_(PoseStack matrix, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderCount = (this.renderCount + 1) % 1000000;
        if (this.currentSequence == null || this.currentSequence.current() == null || this.currentSequence.current().currentFrameIndex != this.lastFrame) {
            this.animate();
            this.lastFrame = this.currentSequence.current().currentFrameIndex;
        }
        this.body.render(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnimation(AnimationType animationType, IncrementingVariable variable) {
        if (variable == null) {
            return;
        }
        this.setAnimation(animationType);
        SmdAnimationSequence sequence = this.currentSequence;
        if (sequence != null) {
            SmdAnimation animation = sequence.checkForIncrement(variable);
            int frame = (int)Math.floor(variable.value % (float)animation.totalFrames);
            if (variable.shouldReverse && variable.value >= (float)animation.totalFrames) {
                variable.inReverse = true;
                if (variable.shouldStayAtEnd) {
                    variable.setAtEnd(true);
                }
                frame = animation.totalFrames - 1;
            }
            animation.setCurrentFrame(Mth.m_14045_((int)frame, (int)0, (int)(animation.totalFrames - 1)));
        }
    }

    void sendBoneData(SmdModel model) {
        this.allBones = model.bones;
        if (!model.isBodyGroupPart) {
            this.root = model.root;
        }
    }

    private void reformBones() {
        this.root.reformChildren();
    }

    public void animate() {
        if (this.body.currentAnim == null) {
            this.setAnimation(AnimationType.IDLE);
        }
        this.root.setAndApplyModified(this.renderCount);
    }

    public void setAnimation(AnimationType animType) {
        this.currentSequence = this.anims.containsKey((Object)animType) ? this.anims.get((Object)animType) : this.anims.get((Object)AnimationType.IDLE);
        if (this.currentSequence != null) {
            this.body.setAnimation(this.currentSequence.current());
        } else {
            this.body.setAnimation(null);
        }
    }

    private void loadQC(ResourceLocation resource) throws GabeNewellException {
        BufferedInputStream inputStream = CommonProxy.getStreamForResourceLocation(resource);
        if (inputStream == null) {
            Pixelmon.LOGGER.error("Couldn't find model at location " + resource.toString());
            return;
        }
        int lineCount = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String currentLine;
            String[] bodyParams = null;
            ArrayList<String[]> animParams = new ArrayList<String[]>();
            while ((currentLine = reader.readLine()) != null) {
                ++lineCount;
                String[] params = RegexPatterns.MULTIPLE_WHITESPACE.split(currentLine);
                if (params[0].equalsIgnoreCase("$body")) {
                    bodyParams = params;
                    continue;
                }
                if (params[0].equalsIgnoreCase("$anim")) {
                    this.hasAnimations = true;
                    animParams.add(params);
                    continue;
                }
                if (!params[0].equalsIgnoreCase("$scale")) continue;
                this.scale = Float.parseFloat(params[1]);
            }
            ResourceLocation modelPath = this.getResource((String)bodyParams[1]);
            this.body = new SmdModel(this, modelPath);
            for (String[] animPars : animParams) {
                String animName = animPars[1];
                ArrayList<SmdAnimation> sequence = new ArrayList<SmdAnimation>();
                for (int i = 2; i < animPars.length; ++i) {
                    SmdAnimation animation = new SmdAnimation(this, animName, this.getResource(animPars[i]));
                    sequence.add(animation);
                }
                AnimationType animType = AnimationType.getTypeFor(animName);
                this.anims.put(animType, new SmdAnimationSequence(animType, sequence));
                if (!animName.equalsIgnoreCase("idle")) continue;
                this.currentSequence = this.anims.get((Object)AnimationType.IDLE);
            }
        }
        catch (GabeNewellException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GabeNewellException("An error occurred while reading the " + resource.toString() + " PQC file on line #" + lineCount, e);
        }
    }

    public ResourceLocation getResource(String fileName) {
        if (fileName.contains(":")) {
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)fileName);
            if (resourceLocation != null) {
                return resourceLocation;
            }
            Pixelmon.LOGGER.debug("There was an error attempting to load " + fileName + " (potentially invalid location check ResourceLocation specifications)");
        }
        String urlAsString = this.resource.m_135815_();
        int lastIndex = urlAsString.lastIndexOf(47);
        String startString = urlAsString.substring(0, lastIndex);
        return ResourceLocationHelper.of("pixelmon", (startString + "/" + fileName).toLowerCase(Locale.ROOT));
    }
}

