/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.RegexPatterns;
import com.pixelmonmod.pixelmon.api.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.VectorHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimFrame;
import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import com.pixelmonmod.pixelmon.client.models.smd.DeformVertex;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.NormalizedFace;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.TextureCoordinate;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import info.pixelmon.repack.org.tukaani.xz.XZInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SmdModel {
    public final ValveStudioModel owner;
    public List<NormalizedFace> faces = new LinkedList<NormalizedFace>();
    public List<DeformVertex> verts = Collections.synchronizedList(new ArrayList(0));
    private Map<DeformVertex, DeformVertex> verticies = new HashMap<DeformVertex, DeformVertex>();
    public ArrayList<Bone> bones = new ArrayList(0);
    public HashMap<String, Bone> nameToBoneMapping = new HashMap();
    public SmdAnimation currentAnim;
    private Set<DeformVertex> unattachedVerticies = Sets.newHashSet();
    private int vertexIDBank = 0;
    protected boolean isBodyGroupPart;
    int lineCount = -1;
    public Bone root;

    SmdModel(ValveStudioModel owner, ResourceLocation resloc) throws GabeNewellException {
        this.owner = owner;
        this.isBodyGroupPart = false;
        if (resloc.m_135815_().endsWith(".bmd")) {
            this.loadBmdModel(resloc, null);
        } else {
            this.loadSmdModel(resloc, null);
        }
        this.setBoneChildren();
        this.determineRoot();
        for (DeformVertex vertexID : this.unattachedVerticies) {
            this.root.addVertex(vertexID, 1.0f);
        }
        this.unattachedVerticies.clear();
        owner.sendBoneData(this);
    }

    private void loadSmdModel(ResourceLocation resloc, SmdModel body) throws GabeNewellException {
        BufferedInputStream inputStream = CommonProxy.getStreamForResourceLocation(resloc);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String currentLine;
            this.lineCount = 0;
            while ((currentLine = reader.readLine()) != null) {
                ++this.lineCount;
                if (currentLine.startsWith("version")) continue;
                if (currentLine.startsWith("nodes")) {
                    ++this.lineCount;
                    while (!(currentLine = reader.readLine()).startsWith("end")) {
                        ++this.lineCount;
                        this.parseBone(currentLine, this.lineCount, body);
                    }
                    continue;
                }
                if (currentLine.startsWith("skeleton")) {
                    ++this.lineCount;
                    reader.readLine();
                    ++this.lineCount;
                    while (!(currentLine = reader.readLine()).startsWith("end")) {
                        ++this.lineCount;
                        if (this.isBodyGroupPart) continue;
                        this.parseBoneValues(currentLine, this.lineCount);
                    }
                    continue;
                }
                if (!currentLine.startsWith("triangles")) continue;
                ++this.lineCount;
                while (!(currentLine = reader.readLine()).startsWith("end")) {
                    String[] params = new String[3];
                    for (int i = 0; i < 3; ++i) {
                        ++this.lineCount;
                        params[i] = reader.readLine();
                    }
                    this.parseFace(params, this.lineCount);
                }
            }
        }
        catch (Exception e) {
            if (this.lineCount == -1) {
                throw new GabeNewellException("there was a problem opening the model file : " + resloc, e);
            }
            throw new GabeNewellException("an error occurred reading the SMD file \"" + resloc + "\" on line #" + this.lineCount, e);
        }
    }

    private void loadBmdModel(ResourceLocation modelLoc, SmdModel body) throws GabeNewellException {
        try (BufferedInputStream inputStream = CommonProxy.getStreamForResourceLocation(modelLoc);){
            int version = ((InputStream)inputStream).read();
            if (version != 1 && version != 2) {
                throw new GabeNewellException("Unknown BMD version: " + version);
            }
            DataInputStream in = version == 1 ? new DataInputStream(inputStream) : new DataInputStream(new XZInputStream(inputStream));
            int numNodes = in.readShort();
            CommonHelper.ensureIndex(this.bones, numNodes - 1);
            for (int i = 0; i < numNodes; ++i) {
                short boneID = in.readShort();
                short parentBone = in.readShort();
                String name = SmdModel.readNullTerm(in);
                Bone parent = parentBone != -1 ? this.bones.get(parentBone) : null;
                this.bones.set(boneID, new Bone(name, boneID, parent, this));
            }
            short numSkeletons = in.readShort();
            for (short i = 0; i < numSkeletons; i = (short)(i + 1)) {
                int numBones = in.readShort();
                for (int j = 0; j < numBones; ++j) {
                    short boneId = in.readShort();
                    float locX = in.readFloat();
                    float locY = in.readFloat();
                    float locZ = in.readFloat();
                    float rotX = in.readFloat();
                    float rotY = in.readFloat();
                    float rotZ = in.readFloat();
                    Bone theBone = this.bones.get(boneId);
                    theBone.setRest(VectorHelper.matrix4FromLocRot(locX, -locY, -locZ, rotX, -rotY, -rotZ));
                }
            }
            ArrayList<String> material = new ArrayList<String>();
            int numMaterial = in.readShort();
            for (int i = 0; i < numMaterial; ++i) {
                material.add(SmdModel.readNullTerm(in));
            }
            int vertexCount = 0;
            int numTriangles = in.readShort();
            for (int i = 0; i < numTriangles; ++i) {
                String mat = (String)material.get(in.readByte());
                DeformVertex[] faceVerts = new DeformVertex[3];
                TextureCoordinate[] uvs = new TextureCoordinate[3];
                for (int j = 0; j < 3; ++j) {
                    in.readShort();
                    float x = in.readFloat();
                    float y = -in.readFloat();
                    float z = -in.readFloat();
                    float normX = in.readFloat();
                    float normY = -in.readFloat();
                    float normZ = -in.readFloat();
                    float u = in.readFloat();
                    float v = in.readFloat();
                    int id = vertexCount++;
                    DeformVertex dv = this.getExisting(x, y, z, u, v);
                    faceVerts[j] = dv == null ? new DeformVertex(x, y, z, normX, normY, normZ, this.vertexIDBank++, u, v) : dv;
                    int links = in.readByte();
                    if (links == 0) {
                        Pixelmon.LOGGER.error("ERROR WITH MODEL " + modelLoc + " AT LINE " + i + " LINKS = 0");
                        this.unattachedVerticies.add(faceVerts[j]);
                    }
                    for (int w = 0; w < links; ++w) {
                        short boneID = in.readShort();
                        float weight = in.readFloat();
                        this.bones.get(boneID).addVertex(faceVerts[j], weight);
                    }
                    CommonHelper.ensureIndex(this.verts, id);
                    this.verts.set(id, faceVerts[j]);
                    this.verticies.put(faceVerts[j], faceVerts[j]);
                    uvs[j] = new TextureCoordinate(u, 1.0f - v);
                }
                this.faces.add(new NormalizedFace(faceVerts, uvs));
            }
        }
        catch (IOException e) {
            throw new GabeNewellException("An error occurred while reading BMD " + modelLoc.m_135815_(), e);
        }
        this.verticies.clear();
    }

    private void parseBone(String line, int lineCount, SmdModel body) {
        Bone theBone;
        String[] params = line.split("\"");
        int id = Integer.parseInt(RegexPatterns.SPACE_SYMBOL.matcher(params[0]).replaceAll(""));
        String boneName = params[1];
        Bone bone = theBone = body != null ? body.getBoneByName(boneName) : null;
        if (theBone == null) {
            int parentID = Integer.parseInt(RegexPatterns.SPACE_SYMBOL.matcher(params[2]).replaceAll(""));
            Bone parent = parentID >= 0 ? this.bones.get(parentID) : null;
            theBone = new Bone(boneName, id, parent, this);
        }
        CommonHelper.ensureIndex(this.bones, id);
        this.bones.set(id, theBone);
        this.nameToBoneMapping.put(boneName, theBone);
    }

    private void parseBoneValues(String line, int lineCount) {
        String[] params = RegexPatterns.MULTIPLE_WHITESPACE.split(line);
        int id = Integer.parseInt(params[0]);
        float[] locRots = new float[6];
        for (int i = 1; i < 7; ++i) {
            locRots[i - 1] = Float.parseFloat(params[i]);
        }
        Bone theBone = this.bones.get(id);
        theBone.setRest(VectorHelper.matrix4FromLocRot(locRots[0], -locRots[1], -locRots[2], locRots[3], -locRots[4], -locRots[5]));
    }

    private void parseFace(String[] params, int lineCount) {
        DeformVertex[] faceVerts = new DeformVertex[3];
        TextureCoordinate[] uvs = new TextureCoordinate[3];
        for (int i = 0; i < 3; ++i) {
            String[] values = RegexPatterns.MULTIPLE_WHITESPACE.split(params[i]);
            float x = Float.parseFloat(values[1]);
            float y = -Float.parseFloat(values[2]);
            float z = -Float.parseFloat(values[3]);
            float xn = Float.parseFloat(values[4]);
            float yn = -Float.parseFloat(values[5]);
            float zn = -Float.parseFloat(values[6]);
            DeformVertex v = this.getExisting(x, y, z, 0.0f, 0.0f);
            if (v == null) {
                faceVerts[i] = new DeformVertex(x, y, z, xn, yn, zn, this.vertexIDBank, 0.0f, 0.0f);
                CommonHelper.ensureIndex(this.verts, this.vertexIDBank);
                this.verts.set(this.vertexIDBank, faceVerts[i]);
                this.verticies.put(faceVerts[i], faceVerts[i]);
                ++this.vertexIDBank;
            } else {
                faceVerts[i] = v;
            }
            uvs[i] = new TextureCoordinate(Float.parseFloat(values[7]), 1.0f - Float.parseFloat(values[8]));
            if (values.length <= 10) continue;
            this.doBoneWeights(values, faceVerts[i]);
        }
        this.faces.add(new NormalizedFace(faceVerts, uvs));
    }

    private DeformVertex getExisting(float x, float y, float z, float u, float v) {
        return this.verticies.get(new DeformVertex(x, y, z, 0.0f, 0.0f, 0.0f, 0, u, v));
    }

    private void doBoneWeights(String[] values, DeformVertex vert) {
        int i;
        int links = Integer.parseInt(values[9]);
        float[] weights = new float[links];
        float sum = 0.0f;
        for (i = 0; i < links; ++i) {
            weights[i] = Float.parseFloat(values[i * 2 + 11]);
            sum += weights[i];
        }
        for (i = 0; i < links; ++i) {
            int boneID = Integer.parseInt(values[i * 2 + 10]);
            float weight = weights[i] / sum;
            this.bones.get(boneID).addVertex(vert, weight);
        }
    }

    private void setBoneChildren() {
        for (int i = 0; i < this.bones.size(); ++i) {
            Bone theBone = this.bones.get(i);
            this.bones.stream().filter(child -> child.parent == theBone).forEach(theBone::addChild);
        }
    }

    private void determineRoot() {
        for (Bone b : this.bones) {
            if (b.parent != null || b.children.isEmpty()) continue;
            this.root = b;
            break;
        }
        if (this.root == null) {
            for (Bone b : this.bones) {
                if (b.name.equals("blender_implicit")) continue;
                this.root = b;
                break;
            }
        }
    }

    public void setAnimation(SmdAnimation anim) {
        this.currentAnim = anim;
    }

    public Bone getBoneByName(String name) {
        for (Bone b : this.bones) {
            if (!b.name.equals(name)) continue;
            return b;
        }
        return null;
    }

    public AnimFrame currentFrame() {
        return this.currentAnim == null ? null : (this.currentAnim.frames == null ? null : (this.currentAnim.frames.isEmpty() ? null : this.currentAnim.frames.get(this.currentAnim.currentFrameIndex)));
    }

    public void render(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        boolean cache = buffer instanceof BufferBuilder && !this.root.children.isEmpty();
        int renderCount = this.owner.renderCount;
        if (cache) {
            BufferBuilder builder = (BufferBuilder)buffer;
            ByteBuffer bufferBuilder = builder.f_85648_;
            builder.m_85722_(this.faces.size() * 3 * DefaultVertexFormat.f_85812_.m_86020_());
            bufferBuilder.limit(bufferBuilder.capacity());
        }
        for (NormalizedFace face : this.faces) {
            face.addFaceForRender(pose, normal, buffer, packedLight, packedOverlay, r, g, b, a, this, renderCount, cache);
        }
    }

    private static String readNullTerm(DataInputStream in) throws IOException {
        StringBuilder str = new StringBuilder();
        char ch = '\u0000';
        do {
            if (ch == '\u0000') continue;
            str.append(ch);
        } while ((ch = in.readChar()) != '\u0000');
        return str.toString();
    }
}

