/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.client.models.smd.DeformVertex;
import com.pixelmonmod.pixelmon.client.models.smd.SmdModel;
import com.pixelmonmod.pixelmon.client.models.smd.TextureCoordinate;
import java.nio.ByteBuffer;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class NormalizedFace {
    public DeformVertex[] vertices;
    protected TextureCoordinate[] textureCoordinates;
    protected Vector3f cachedNormal = new Vector3f();
    protected Vector4f cachedPosition = new Vector4f();

    public NormalizedFace(DeformVertex[] xyz, TextureCoordinate[] uvs) {
        this.vertices = xyz;
        this.textureCoordinates = uvs;
    }

    public void addFaceForRender(Matrix4f pose, Matrix3f normal, VertexConsumer bufferBuilder, int packedLight, int packedOverlay, float r, float g, float b, float a, SmdModel body, int renderCount, boolean cacheVerticies) {
        int vertexSize = DefaultVertexFormat.f_85812_.m_86020_();
        for (int i = 0; i < 3; ++i) {
            int pos;
            DeformVertex vertex = this.vertices[i];
            if (!cacheVerticies) {
                Vector4f transformedPosition = pose.transform((Vector4fc)vertex.getCurrentLocation(), this.cachedPosition);
                Vector3f transformedNormal = normal.transform((Vector3fc)vertex.getCurrentNormal(), this.cachedNormal).mul(1.0f / body.owner.getScale());
                bufferBuilder.m_5954_(transformedPosition.x(), transformedPosition.y(), transformedPosition.z(), r, g, b, a, this.textureCoordinates[i].u(), this.textureCoordinates[i].v(), packedOverlay, packedLight, transformedNormal.x(), transformedNormal.y(), transformedNormal.z());
                continue;
            }
            BufferBuilder builder = (BufferBuilder)bufferBuilder;
            ByteBuffer buffer = builder.f_85648_;
            if (vertex.lastCount == renderCount && vertex.id2 != -1) {
                int position = vertex.id2 * vertexSize;
                buffer.position(position);
                buffer.limit(position + vertexSize);
                ByteBuffer byteBuffer = buffer.slice();
                byteBuffer.limit(vertexSize);
                buffer.limit(buffer.capacity());
                buffer.position(builder.f_85652_);
                buffer.put(byteBuffer);
                buffer.position(0);
                builder.f_85654_ += byteBuffer.limit() / vertexSize;
                builder.f_85652_ += byteBuffer.limit();
                continue;
            }
            Vector4f transformedPosition = pose.transform((Vector4fc)vertex.getCurrentLocation(), this.cachedPosition);
            Vector3f transformedNormal = normal.transform((Vector3fc)vertex.getCurrentNormal(), this.cachedNormal).mul(1.0f / body.owner.getScale());
            builder.m_5832_(0, transformedPosition.x());
            builder.m_5832_(4, transformedPosition.y());
            builder.m_5832_(8, transformedPosition.z());
            builder.m_5672_(12, (byte)(r * 255.0f));
            builder.m_5672_(13, (byte)(g * 255.0f));
            builder.m_5672_(14, (byte)(b * 255.0f));
            builder.m_5672_(15, (byte)(a * 255.0f));
            builder.m_5832_(16, this.textureCoordinates[i].u());
            builder.m_5832_(20, this.textureCoordinates[i].v());
            if (builder.f_85660_) {
                builder.m_5586_(24, (short)(packedOverlay & 0xFFFF));
                builder.m_5586_(26, (short)(packedOverlay >> 16 & 0xFFFF));
                pos = 28;
            } else {
                pos = 24;
            }
            builder.m_5586_(pos + 0, (short)(packedLight & 0xFFFF));
            builder.m_5586_(pos + 2, (short)(packedLight >> 16 & 0xFFFF));
            builder.m_5672_(pos + 4, BufferVertexConsumer.m_85774_((float)transformedNormal.x()));
            builder.m_5672_(pos + 5, BufferVertexConsumer.m_85774_((float)transformedNormal.y()));
            builder.m_5672_(pos + 6, BufferVertexConsumer.m_85774_((float)transformedNormal.z()));
            builder.f_85652_ += pos + 8;
            ++builder.f_85654_;
            vertex.id2 = builder.f_85654_ - 1;
        }
    }
}

