/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import java.util.Objects;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class DeformVertex {
    protected final Vector4f baseLoc;
    protected Vector4f currentLocMod;
    protected final Vector3f baseNormal;
    protected Vector3f currentNormalMod;
    protected boolean rendered = false;
    protected Vector4f storage = new Vector4f();
    protected Vector3f storageNorm = new Vector3f();
    protected float u;
    protected float v;
    public final int ID;
    public int id2 = -1;
    public int lastCount = -1;

    public DeformVertex(DeformVertex vertex) {
        this.u = vertex.u;
        this.v = vertex.v;
        this.baseLoc = new Vector4f((Vector4fc)vertex.baseLoc);
        this.baseNormal = new Vector3f((Vector3fc)vertex.baseNormal);
        this.ID = vertex.ID;
        this.currentLocMod = new Vector4f((Vector4fc)vertex.currentLocMod);
        this.currentNormalMod = new Vector3f((Vector3fc)vertex.currentNormalMod);
    }

    public DeformVertex(float x, float y, float z, float xn, float yn, float zn, int ID2, float u, float v) {
        this.baseLoc = new Vector4f(x, y, z, 1.0f);
        this.baseNormal = new Vector3f(xn, yn, zn);
        this.currentLocMod = new Vector4f(x, y, z, 1.0f);
        this.currentNormalMod = new Vector3f(xn, yn, zn);
        this.ID = ID2;
        this.u = u;
        this.v = v;
    }

    public void applyModified(Bone bone, int renderCount, float weight) {
        Matrix4f modified = bone.modified;
        if (modified != null) {
            if (renderCount != this.lastCount) {
                this.id2 = -1;
                this.currentLocMod.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.currentNormalMod.set(0.0f, 0.0f, 0.0f);
                this.lastCount = renderCount;
            }
            modified.transform((Vector4fc)this.baseLoc, this.storage);
            modified.transformDirection((Vector3fc)this.baseNormal, this.storageNorm);
            this.storage.mul(weight);
            this.storageNorm.mul(weight);
            this.storage.add((Vector4fc)this.currentLocMod, this.currentLocMod);
            this.storageNorm.add((Vector3fc)this.currentNormalMod, this.currentNormalMod);
        }
    }

    public boolean equals(float x, float y, float z, float u, float v) {
        return this.currentLocMod.x() == x && this.currentLocMod.y() == y && this.currentLocMod.z() == z && this.u == u && this.v == v;
    }

    public Vector4f getCurrentLocation() {
        return this.currentLocMod;
    }

    public Vector3f getCurrentNormal() {
        return this.currentNormalMod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeformVertex that = (DeformVertex)o;
        return Float.compare(this.u, that.u) == 0 && Float.compare(this.v, that.v) == 0 && Objects.equals(this.baseLoc, that.baseLoc);
    }

    public int hashCode() {
        return Objects.hash(this.baseLoc, Float.valueOf(this.u), Float.valueOf(this.v));
    }
}

