/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.pixelmonmod.pixelmon.client.models.smd.AnimFrame;
import com.pixelmonmod.pixelmon.client.models.smd.DeformVertex;
import com.pixelmonmod.pixelmon.client.models.smd.SmdModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class Bone {
    public String name;
    public int ID;
    public Bone parent;
    protected SmdModel owner;
    protected Matrix4f rest;
    protected Matrix4f restInverted;
    public Matrix4f modified = new Matrix4f();
    public ArrayList<Bone> children = new ArrayList();
    public HashMap<DeformVertex, Float> verts = new HashMap();

    public Bone(String name, int ID2, Bone parent, SmdModel owner) {
        this.name = name;
        this.ID = ID2;
        this.parent = parent;
        this.owner = owner;
    }

    public Bone(Bone b, Bone parent, SmdModel owner) {
        this.name = b.name;
        this.ID = b.ID;
        this.owner = owner;
        this.parent = parent;
        for (Map.Entry<DeformVertex, Float> entry : b.verts.entrySet()) {
            this.verts.put(owner.verts.get(entry.getKey().ID), entry.getValue());
        }
        this.restInverted = b.restInverted;
        this.rest = b.rest;
    }

    public Matrix4f getWorldTransform() {
        return this.rest;
    }

    public void setRest(Matrix4f resting) {
        this.rest = resting;
        this.restInverted = resting.invert(new Matrix4f());
    }

    public void addChild(Bone child) {
        this.children.add(child);
    }

    public void addVertex(DeformVertex v, float weight) {
        if (this.name.equals("blender_implicit")) {
            throw new UnsupportedOperationException("You cannot add verticies to the blender_implicit bone");
        }
        this.verts.put(v, Float.valueOf(weight));
    }

    private void reform(Matrix4f parentMatrix) {
        this.rest = parentMatrix.mul((Matrix4fc)this.rest, new Matrix4f());
        this.restInverted = this.rest.invert(new Matrix4f());
        this.reformChildren();
    }

    public void reformChildren() {
        for (Bone child : this.children) {
            child.reform(this.rest);
        }
    }

    public void setAndApplyModified(int renderCount) {
        for (Bone child : this.children) {
            child.setAndApplyModified(renderCount);
        }
        this.applyModified(renderCount);
    }

    public void applyModified(int renderCount) {
        AnimFrame currentFrame = this.owner.currentFrame();
        if (currentFrame != null) {
            this.modified = currentFrame.transforms.get(this.ID);
        }
        for (Map.Entry<DeformVertex, Float> entry : this.verts.entrySet()) {
            entry.getKey().applyModified(this, renderCount, entry.getValue().floatValue());
        }
    }
}

