/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.client.models.obj.Face;
import com.pixelmonmod.pixelmon.client.models.obj.Group;
import com.pixelmonmod.pixelmon.client.models.obj.Material;
import com.pixelmonmod.pixelmon.client.models.obj.TextureCoordinate;
import com.pixelmonmod.pixelmon.client.models.obj.Vertex;
import com.pixelmonmod.pixelmon.client.models.obj.parser.LineParser;
import com.pixelmonmod.pixelmon.client.models.obj.parser.obj.ObjLineParserFactory;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.model.Model;

public class WavefrontObject
extends Model {
    private ArrayList<Vertex> vertices = new ArrayList();
    private ArrayList<Vertex> normals = new ArrayList();
    private ArrayList<TextureCoordinate> textures = new ArrayList();
    private ArrayList<Group> groups = new ArrayList();
    private HashMap<String, Group> groupsDirectAccess = new HashMap();
    HashMap<String, Material> materials = new HashMap();
    private ObjLineParserFactory parserFactory;
    private Material currentMaterial;
    private Group currentGroup;
    public double radius = 0.0;
    public float xScale;
    public float yScale;
    public float zScale;
    public Vertex translate;
    public Vertex rotate;

    public WavefrontObject(InputStream stream) {
        this(stream, 1.0f, 1.0f, 1.0f, new Vertex(), new Vertex());
    }

    public WavefrontObject(InputStream stream, float xScale, float yScale, float zScale) {
        this(stream, xScale, yScale, zScale, new Vertex(), new Vertex());
    }

    public WavefrontObject(InputStream stream, float scale) {
        this(stream, scale, scale, scale, new Vertex(), new Vertex());
    }

    public WavefrontObject(InputStream stream, float scale, Vertex translation, Vertex rotation) {
        this(stream, scale, scale, scale, translation, rotation);
    }

    public WavefrontObject(InputStream stream, float xScale, float yScale, float zScale, Vertex translation, Vertex rotation) {
        super(PixelmonRendering::getOBJRenderTypeUndelegated);
        try {
            this.translate = translation;
            this.rotate = rotation;
            this.xScale = xScale;
            this.yScale = yScale;
            this.zScale = zScale;
            this.parse(stream);
            this.calculateRadius();
        }
        catch (Exception e) {
            System.out.println("Error, could not load obj");
        }
    }

    private void calculateRadius() {
        for (Vertex vertex : this.vertices) {
            double currentNorm = vertex.norm();
            if (!(currentNorm > this.radius)) continue;
            this.radius = currentNorm;
        }
    }

    public void parse(InputStream fileInput) {
        this.parserFactory = new ObjLineParserFactory(this);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(fileInput));
            String currentLine = null;
            while ((currentLine = in.readLine()) != null) {
                this.parseLine(currentLine);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading file");
        }
    }

    private void parseLine(String currentLine) {
        if ("".equals(currentLine)) {
            return;
        }
        LineParser parser = this.parserFactory.getLineParser(currentLine);
        parser.parse();
        parser.incoporateResults(this);
    }

    public void render(PoseStack PoseStack2, VertexConsumer buffer, int packedLight, int packedOverlay) {
        this.buildVBO(PoseStack2, buffer, packedLight, packedOverlay);
    }

    public void buildVBO(PoseStack matrix, VertexConsumer builder, int packedLight, int packedOverlay) {
        for (Group group : this.groups) {
            this.renderGroup(group, matrix, builder, packedLight, packedOverlay);
        }
    }

    protected void renderGroup(Group group, PoseStack matrix, VertexConsumer builder, int packedLight, int packedOverlay) {
        this.currentGroup = group;
        for (Face face : this.currentGroup.getFaces()) {
            for (int vertexID = 0; vertexID < face.getVertices().length; ++vertexID) {
                Vertex vertex = face.getVertices()[vertexID];
                Vertex normal = face.getNormals()[vertexID];
                TextureCoordinate tex = face.getTextures()[vertexID];
                builder.m_252986_(matrix.m_85850_().m_252922_(), vertex.getX(), vertex.getY(), vertex.getZ()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tex.getU(), tex.getV()).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(matrix.m_85850_().m_252943_(), normal.getX(), normal.getY(), normal.getZ()).m_5752_();
            }
        }
    }

    public void setMaterials(HashMap<String, Material> materials) {
        this.materials = materials;
    }

    public void setTextures(ArrayList<TextureCoordinate> textures) {
        this.textures = textures;
    }

    public ArrayList<TextureCoordinate> getTextureList() {
        return this.textures;
    }

    public void setVertices(ArrayList<Vertex> vertices) {
        this.vertices = vertices;
    }

    public ArrayList<Vertex> getVertices() {
        return this.vertices;
    }

    public void setNormals(ArrayList<Vertex> normals) {
        this.normals = normals;
    }

    public ArrayList<Vertex> getNormals() {
        return this.normals;
    }

    public HashMap<String, Material> getMaterials() {
        return this.materials;
    }

    public Material getCurrentMaterial() {
        return this.currentMaterial;
    }

    public void setCurrentMaterial(Material currentMaterial) {
        this.currentMaterial = currentMaterial;
    }

    public ArrayList<Group> getGroups() {
        return this.groups;
    }

    public HashMap<String, Group> getGroupsDirectAccess() {
        return this.groupsDirectAccess;
    }

    public Group getCurrentGroup() {
        return this.currentGroup;
    }

    public void setCurrentGroup(Group currentGroup) {
        this.currentGroup = currentGroup;
    }

    public String getBoudariesText() {
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        float minZ = 0.0f;
        float maxZ = 0.0f;
        Vertex currentVertex = null;
        for (int i = 0; i < this.getVertices().size(); ++i) {
            currentVertex = this.getVertices().get(i);
            if (currentVertex.getX() > maxX) {
                maxX = currentVertex.getX();
            }
            if (currentVertex.getX() < minX) {
                minX = currentVertex.getX();
            }
            if (currentVertex.getY() > maxY) {
                maxY = currentVertex.getY();
            }
            if (currentVertex.getY() < minY) {
                minY = currentVertex.getY();
            }
            if (currentVertex.getZ() > maxZ) {
                maxZ = currentVertex.getZ();
            }
            if (!(currentVertex.getZ() < minZ)) continue;
            minZ = currentVertex.getZ();
        }
        return "maxX=" + maxX + " minX=" + minX + " maxY=" + maxY + " minY=" + minY + " maxZ=" + maxZ + " minZ=" + minZ;
    }

    public void m_7695_(PoseStack matrix, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.render(matrix, buffer, packedLight, packedOverlay);
    }
}

