/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.items;

import com.mojang.math.Transformation;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.client.models.items.GuiOnlyBakedItemModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public class SpriteItemModel
implements BakedModel {
    public static final ModelResourceLocation RESOURCE_LOCATION = new ModelResourceLocation(ResourceLocationHelper.of("pixelmon:pixelmon_sprite"), "inventory");
    private static final Map<ResourceLocation, BakedModel> MODELS = new WeakHashMap<ResourceLocation, BakedModel>();
    private final BakedModel model;
    private final OverrideList overrides = new OverrideList();

    public SpriteItemModel(BakedModel model) {
        this.model = model;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@javax.annotation.Nullable BlockState state, @javax.annotation.Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        return this.model.m_213637_(state, side, rand);
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.model.m_213637_(state, side, rand);
    }

    public boolean m_7541_() {
        return this.model.m_7541_();
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.model.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.model.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public static BakedModel getBakedModel(Pokemon pixelmon, BakedModel originalModel) {
        if (pixelmon.getSprite() == null) {
            return originalModel;
        }
        ResourceLocation location = ResourceLocationHelper.of(pixelmon.getSprite().toString().replace(".png", "").replace("textures/", ""));
        BakedModel model = MODELS.get(location);
        if (model != null) {
            return model;
        }
        try {
            Function textureGetter = Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_);
            TextureAtlasSprite sprite = (TextureAtlasSprite)textureGetter.apply(location);
            List elements = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)sprite.m_245424_());
            SimpleModelState modelState = new SimpleModelState(Transformation.m_121093_(), false);
            SimpleBakedModel.Builder newModelBuilder = new SimpleBakedModel.Builder(true, false, false, PixelmonRendering.STANDARD_ITEM_TRANSFORMS, ItemOverrides.f_111734_).m_119528_(sprite);
            for (BakedQuad quad : UnbakedGeometryHelper.bakeElements((List)elements, material -> sprite, (ModelState)modelState, (ResourceLocation)location)) {
                newModelBuilder.m_119526_(quad);
            }
            BakedModel newModel = newModelBuilder.build(NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation("cutout")));
            if (PixelmonConfigProxy.getGraphics().isPokeBalls3DInHand()) {
                newModel = new GuiOnlyBakedItemModel(newModel);
            }
            MODELS.put(location, newModel);
            return newModel;
        }
        catch (IllegalStateException e) {
            return originalModel;
        }
    }

    static class OverrideList
    extends ItemOverrides {
        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel p_173467_, @Nullable LivingEntity p_173468_, int p_173469_) {
            Optional<Pokemon> pokemon = SpriteItemHelper.getPokemon(stack);
            if (pokemon.isPresent()) {
                return SpriteItemModel.getBakedModel(pokemon.get(), originalModel);
            }
            return originalModel;
        }
    }
}

