/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.items;

import com.google.common.collect.Maps;
import com.mojang.math.Transformation;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.client.models.items.GuiOnlyBakedItemModel;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PokeBallLidItemModel
implements BakedModel {
    public static final ModelResourceLocation RESOURCE_LOCATION = new ModelResourceLocation(new ResourceLocation("pixelmon:poke_ball_lid"), "inventory");
    private final BakedModel model;
    private final OverrideList overrides = new OverrideList();

    public PokeBallLidItemModel(BakedModel model) {
        this.model = model;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        return this.model.m_213637_(state, side, rand);
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.model.m_213637_(state, side, rand);
    }

    public boolean m_7541_() {
        return this.model.m_7541_();
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return true;
    }

    public TextureAtlasSprite m_6160_() {
        return this.model.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    static class OverrideList
    extends ItemOverrides {
        private static final Map<PokeBall, BakedModel> MODELS = Maps.newHashMap();

        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, ClientLevel p_173467_, @Nullable LivingEntity p_173468_, int p_173469_) {
            Optional<PokeBall> optionalPokeBall = PokeBallPart.getPokeBall(stack);
            if (optionalPokeBall.isPresent()) {
                PokeBall pokeBall = optionalPokeBall.get();
                BakedModel model = MODELS.get(pokeBall);
                if (model != null) {
                    return model;
                }
                try {
                    ResourceLocation location = pokeBall.getLidSprite();
                    Function textureGetter = Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_);
                    TextureAtlasSprite sprite = (TextureAtlasSprite)textureGetter.apply(location);
                    List elements = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)sprite.m_245424_());
                    SimpleModelState modelState = new SimpleModelState(Transformation.m_121093_(), false);
                    SimpleBakedModel.Builder newModelBuilder = new SimpleBakedModel.Builder(true, false, false, PixelmonRendering.STANDARD_ITEM_TRANSFORMS, ItemOverrides.f_111734_).m_119528_(sprite);
                    for (BakedQuad quad : UnbakedGeometryHelper.bakeElements((List)elements, material -> sprite, (ModelState)modelState, (ResourceLocation)location)) {
                        newModelBuilder.m_119526_(quad);
                    }
                    BakedModel newModel = newModelBuilder.build(NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation("cutout")));
                    if (PixelmonConfigProxy.getGraphics().isPokeBalls3DInHand()) {
                        newModel = new GuiOnlyBakedItemModel(newModel);
                    }
                    MODELS.put(pokeBall, newModel);
                    return newModel;
                }
                catch (IllegalStateException e) {
                    return originalModel;
                }
            }
            return originalModel;
        }
    }
}

