/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.ModelCustomWrapper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRenderer;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModelLoader;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import net.minecraft.client.model.Model;
import net.minecraft.resources.ResourceLocation;

public class GenericSmdModel
extends Model {
    public PixelmonModelRenderer modelRenderer;
    private ValveStudioModel model;
    private ResourceLocation pqcResource;

    public GenericSmdModel(ResourceLocation pqcResource) {
        super(PixelmonRendering::getSMDRenderType);
        this.pqcResource = pqcResource;
        this.reloadModel();
    }

    public GenericSmdModel(String basePath, String pqcPath) {
        this(ResourceLocationHelper.of("pixelmon:" + basePath + "/" + pqcPath));
    }

    public void reloadModel() {
        this.modelRenderer = new PixelmonModelRenderer(this, "body");
        try {
            this.model = ValveStudioModelLoader.INSTANCE.loadModel(null, this.pqcResource);
        }
        catch (GabeNewellException e) {
            throw new RuntimeException(e);
        }
        this.modelRenderer.addCustomModel(new ModelCustomWrapper(this.model));
    }

    public ValveStudioModel getModel() {
        return this.model;
    }

    public void setFrame(int frame) {
        ValveStudioModel valveStudioModel = (ValveStudioModel)this.modelRenderer.objs.get((int)0).model;
        SmdAnimation animation = valveStudioModel.currentSequence.checkForFinalFrame(frame);
        animation.setCurrentFrame((int)Math.floor(frame % animation.getNumFrames()));
    }

    public void m_7695_(PoseStack matrix, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.modelRenderer.m_104306_(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(PoseStack matrix, VertexConsumer buffer, int packedLight, int packedOverlay) {
        this.modelRenderer.m_104306_(matrix, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

