/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.models.ModelCustomWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;

public class PixelmonModelRenderer
extends ModelPart {
    public String label;
    public ArrayList<ModelCustomWrapper> objs = new ArrayList();
    private boolean isTransparent = false;
    private float transparency;
    public double offsetX;
    public double offsetY;
    public double offsetZ;
    public boolean isHidden;
    public float scale = 1.0f;
    private final Model model;

    public PixelmonModelRenderer(Model model, String label) {
        super(Collections.emptyList(), (Map)ImmutableMap.of());
        this.model = model;
        this.label = label;
    }

    public PixelmonModelRenderer(Model model) {
        this(model, "");
    }

    public PixelmonModelRenderer(Model model, String label, int texOffX, int texOffY) {
        super(Collections.emptyList(), (Map)ImmutableMap.of());
        this.model = model;
        this.label = label;
    }

    public void addCustomModel(ModelCustomWrapper model) {
        this.objs.add(model);
    }

    public void setTransparent(float transparency) {
        if (transparency > 0.0f) {
            this.isTransparent = true;
            this.transparency = transparency;
        }
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public Model getModel() {
        return this.model;
    }

    public void m_104306_(PoseStack matrix, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderInner(matrix, buffer, packedLight, packedOverlay, Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), Float.valueOf(alpha));
    }

    private void renderInner(PoseStack matrix, VertexConsumer buffer, Integer packedLight, Integer packedOverlay, Float red, Float green, Float blue, Float alpha) {
        matrix.m_85836_();
        float scale = this.scale;
        if (!this.isHidden && this.f_104207_) {
            matrix.m_85837_(this.offsetX, this.offsetY, this.offsetZ);
            if (this.f_104203_ == 0.0f && this.f_104204_ == 0.0f && this.f_104205_ == 0.0f) {
                if (this.f_104200_ == 0.0f && this.f_104201_ == 0.0f && this.f_104202_ == 0.0f) {
                    this.renderCustomModels(matrix, buffer, packedLight, packedOverlay, red.floatValue(), green.floatValue(), blue.floatValue(), alpha.floatValue(), scale, Minecraft.m_91087_().m_91296_());
                    if (this.f_104213_ != null) {
                        for (int var2 = 0; var2 < this.f_104213_.size(); ++var2) {
                            ((ModelPart)this.f_104213_.get(var2)).m_104301_(matrix, buffer, packedLight.intValue(), packedOverlay.intValue());
                        }
                    }
                } else {
                    matrix.m_252880_(this.f_104200_ * scale, this.f_104201_ * scale, this.f_104202_ * scale);
                    this.renderCustomModels(matrix, buffer, packedLight, packedOverlay, red.floatValue(), green.floatValue(), blue.floatValue(), alpha.floatValue(), scale, Minecraft.m_91087_().m_91296_());
                    if (this.f_104213_ != null) {
                        for (int var2 = 0; var2 < this.f_104213_.size(); ++var2) {
                            ((ModelPart)this.f_104213_.get(var2)).m_104301_(matrix, buffer, packedLight.intValue(), packedOverlay.intValue());
                        }
                    }
                    matrix.m_252880_(-this.f_104200_ * scale, -this.f_104201_ * scale, -this.f_104202_ * scale);
                }
            } else {
                matrix.m_85836_();
                matrix.m_252880_(this.f_104200_ * scale, this.f_104201_ * scale, this.f_104202_ * scale);
                if (this.f_104204_ != 0.0f) {
                    matrix.m_252781_(QuaternionHelper.fromEuler(this.f_104204_ * 57.295776f, 0.0f, 1.0f, 0.0f));
                }
                if (this.f_104205_ != 0.0f) {
                    matrix.m_252781_(QuaternionHelper.fromEuler(this.f_104205_ * 57.295776f, 0.0f, 0.0f, 1.0f));
                }
                if (this.f_104203_ != 0.0f) {
                    matrix.m_252781_(QuaternionHelper.fromEuler(this.f_104203_ * 57.295776f, 1.0f, 0.0f, 0.0f));
                }
                this.renderCustomModels(matrix, buffer, packedLight, packedOverlay, red.floatValue(), green.floatValue(), blue.floatValue(), alpha.floatValue(), scale, Minecraft.m_91087_().m_91296_());
                if (this.f_104213_ != null) {
                    for (int var2 = 0; var2 < this.f_104213_.size(); ++var2) {
                        ((ModelPart)this.f_104213_.get(var2)).m_104301_(matrix, buffer, packedLight.intValue(), packedOverlay.intValue());
                    }
                }
                matrix.m_85849_();
            }
            matrix.m_85837_(-this.offsetX, -this.offsetY, -this.offsetZ);
        }
        matrix.m_85849_();
    }

    public void m_104301_(PoseStack matrix, VertexConsumer buffer, int packedLight, int packedOverlay) {
        this.m_104306_(matrix, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderCustomModels(PoseStack matrix, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, float scale, float partialTick) {
        matrix.m_85836_();
        for (ModelCustomWrapper obj : this.objs) {
            if (this.isTransparent) {
                obj.render(matrix, buffer, packedLight, packedOverlay, red, green, blue, this.transparency, scale);
                continue;
            }
            obj.render(matrix, buffer, packedLight, packedOverlay, red, green, blue, alpha, scale);
        }
        matrix.m_85849_();
    }
}

