/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.materials;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EnumMaterialOption {
    NO_LIGHTING{

        @Override
        public void begin(Object ... params) {
            FS.start_unlit();
        }

        @Override
        public void end(Object ... params) {
            FS.end_unlit();
        }
    }
    ,
    WIREFRAME{

        @Override
        public void begin(Object ... params) {
            FS.start_wire();
        }

        @Override
        public void end(Object ... params) {
            GL11.glPopAttrib();
        }
    }
    ,
    TRANSPARENCY{

        @Override
        public void begin(Object ... params) {
            FS.start_transparency(params);
        }

        @Override
        public void end(Object ... params) {
            FS.end_transparency();
        }
    }
    ,
    NOCULL{

        @Override
        public void begin(Object ... params) {
            FS.enable_nocull();
        }

        @Override
        public void end(Object ... params) {
            FS.disable_nocull();
        }
    };

    public static int cubemapID;

    public abstract void begin(Object ... var1);

    public abstract void end(Object ... var1);

    static {
        cubemapID = 33986;
    }

    private static final class FS {
        private FS() {
        }

        public static void start_wire() {
            GL11.glPushAttrib((int)2880);
            GL11.glPolygonMode((int)1032, (int)6913);
        }

        public static void start_unlit() {
            Minecraft.m_91087_().f_91063_.m_109154_().m_109891_();
        }

        public static void end_unlit() {
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        }

        public static void start_transparency(Object[] actuallyAFloat) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            if (actuallyAFloat != null && actuallyAFloat.length > 0 && actuallyAFloat[0] instanceof Float) {
                float f = ((Float)actuallyAFloat[0]).floatValue();
            }
        }

        public static void end_transparency() {
            RenderSystem.disableBlend();
        }

        public static void enable_nocull() {
            RenderSystem.enableCull();
        }

        public static void disable_nocull() {
            RenderSystem.disableCull();
        }
    }
}

