/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.listener;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class WallpapersListener
implements ResourceManagerReloadListener {
    public static final String DEFAULT_WALLPAPER = "default";
    private static final ResourceLocation DEFAULT = ResourceLocationHelper.of("pixelmon", String.format("textures/gui/pc/wallpapers/%s.png", "default"));
    private static final String SEARCH_WALLPAPER = "search";
    private static final ResourceLocation SEARCH = ResourceLocationHelper.of("pixelmon", String.format("textures/gui/pc/wallpapers/%s.png", "search"));
    private static Map<String, ResourceLocation> wallpapersMap = new LinkedHashMap<String, ResourceLocation>();
    private static List<String> wallpaperNames = new ArrayList<String>();
    private static final Gson GSON = new Gson();

    public static List<String> getWallpapers() {
        return wallpaperNames;
    }

    public static boolean hasWallpaper(String name) {
        if (SEARCH_WALLPAPER.equals(name)) {
            return true;
        }
        return name != null && wallpaperNames.contains(name);
    }

    public static ResourceLocation getWallpaper(String name) {
        if (SEARCH_WALLPAPER.equals(name)) {
            return SEARCH;
        }
        ResourceLocation wallpaper = wallpapersMap.get(name);
        return wallpaper == null ? DEFAULT : wallpaper;
    }

    public void m_6213_(ResourceManager manager) {
        wallpapersMap.clear();
        wallpapersMap.put(DEFAULT_WALLPAPER, DEFAULT);
        try {
            for (Resource resource : manager.m_213829_(ResourceLocationHelper.of("pixelmon", "textures/gui/pc/wallpapers/wallpapers.json"))) {
                try {
                    String[] wallpapers;
                    for (String fullName : wallpapers = (String[])GSON.fromJson((Reader)new InputStreamReader(resource.m_215507_()), String[].class)) {
                        String name = fullName.substring(0, fullName.lastIndexOf("."));
                        if (name.equals(DEFAULT_WALLPAPER) || name.equals(SEARCH_WALLPAPER)) continue;
                        wallpapersMap.put(name, ResourceLocationHelper.of("pixelmon", "textures/gui/pc/wallpapers/" + fullName));
                    }
                }
                catch (JsonParseException e) {
                    Pixelmon.LOGGER.error(String.format("There was a problem trying to read 'wallpapers.json' from the resource pack '%s'.", resource), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            Pixelmon.LOGGER.error("There was a problem trying to read 'wallpapers.json'.", (Throwable)e);
        }
        wallpaperNames = ImmutableList.copyOf(wallpapersMap.keySet());
    }
}

